/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.AllowedOriginsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AllowedOriginsCompanyLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public AllowedOriginsCompanyLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public AllowedOriginsCompanyLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public AllowedOriginsResponse createAllowedOrigin(String companyId, String apiCredentialId, AllowedOrigin allowedOrigin) throws ApiException, IOException {
        return this.createAllowedOrigin(companyId, apiCredentialId, allowedOrigin, null);
    }

    public AllowedOriginsResponse createAllowedOrigin(String companyId, String apiCredentialId, AllowedOrigin allowedOrigin, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = allowedOrigin.toJson();
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/apiCredentials/{apiCredentialId}/allowedOrigins", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return AllowedOriginsResponse.fromJson(jsonResult);
    }

    public void deleteAllowedOrigin(String companyId, String apiCredentialId, String originId) throws ApiException, IOException {
        this.deleteAllowedOrigin(companyId, apiCredentialId, originId, null);
    }

    public void deleteAllowedOrigin(String companyId, String apiCredentialId, String originId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        if (originId == null) {
            throw new IllegalArgumentException("Please provide the originId path parameter");
        }
        pathParams.put("originId", originId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/apiCredentials/{apiCredentialId}/allowedOrigins/{originId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public AllowedOrigin getAllowedOrigin(String companyId, String apiCredentialId, String originId) throws ApiException, IOException {
        return this.getAllowedOrigin(companyId, apiCredentialId, originId, null);
    }

    public AllowedOrigin getAllowedOrigin(String companyId, String apiCredentialId, String originId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        if (originId == null) {
            throw new IllegalArgumentException("Please provide the originId path parameter");
        }
        pathParams.put("originId", originId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/apiCredentials/{apiCredentialId}/allowedOrigins/{originId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AllowedOrigin.fromJson(jsonResult);
    }

    public AllowedOriginsResponse listAllowedOrigins(String companyId, String apiCredentialId) throws ApiException, IOException {
        return this.listAllowedOrigins(companyId, apiCredentialId, null);
    }

    public AllowedOriginsResponse listAllowedOrigins(String companyId, String apiCredentialId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (companyId == null) {
            throw new IllegalArgumentException("Please provide the companyId path parameter");
        }
        pathParams.put("companyId", companyId);
        if (apiCredentialId == null) {
            throw new IllegalArgumentException("Please provide the apiCredentialId path parameter");
        }
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/companies/{companyId}/apiCredentials/{apiCredentialId}/allowedOrigins", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AllowedOriginsResponse.fromJson(jsonResult);
    }
}

