/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.ResourceReference;
import com.adyen.model.transfers.TransferData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolder", "amount", "balanceAccount", "balancePlatform", "bookingDate", "creationDate", "eventId", "id", "status", "transfer", "valueDate"})
public class Transaction {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT = "balanceAccount";
    private ResourceReference balanceAccount;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
    private OffsetDateTime bookingDate;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private String eventId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TRANSFER = "transfer";
    private TransferData transfer;
    public static final String JSON_PROPERTY_VALUE_DATE = "valueDate";
    private OffsetDateTime valueDate;

    public Transaction accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public Transaction amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transaction balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    public Transaction balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the balance platform.")
    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public Transaction bookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transaction was booked into the balance account.")
    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getBookingDate() {
        return this.bookingDate;
    }

    @JsonProperty(value="bookingDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
    }

    public Transaction creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public Transaction eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(value="The PSP reference of the transaction in the journal.")
    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Transaction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the transaction.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Transaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the transaction.   Possible values:  * **pending**: The transaction is still pending.  * **booked**: The transaction has been booked to the balance account.  ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Transaction transfer(TransferData transfer) {
        this.transfer = transfer;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="transfer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferData getTransfer() {
        return this.transfer;
    }

    @JsonProperty(value="transfer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransfer(TransferData transfer) {
        this.transfer = transfer;
    }

    public Transaction valueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transfer amount becomes available in the balance account.")
    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    @JsonProperty(value="valueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.accountHolder, transaction.accountHolder) && Objects.equals(this.amount, transaction.amount) && Objects.equals(this.balanceAccount, transaction.balanceAccount) && Objects.equals(this.balancePlatform, transaction.balancePlatform) && Objects.equals(this.bookingDate, transaction.bookingDate) && Objects.equals(this.creationDate, transaction.creationDate) && Objects.equals(this.eventId, transaction.eventId) && Objects.equals(this.id, transaction.id) && Objects.equals((Object)this.status, (Object)transaction.status) && Objects.equals(this.transfer, transaction.transfer) && Objects.equals(this.valueDate, transaction.valueDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.amount, this.balanceAccount, this.balancePlatform, this.bookingDate, this.creationDate, this.eventId, this.id, this.status, this.transfer, this.valueDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    transfer: ").append(this.toIndentedString(this.transfer)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Transaction fromJson(String jsonString) throws JsonProcessingException {
        return (Transaction)JSON.getMapper().readValue(jsonString, Transaction.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        BOOKED("booked"),
        PENDING("pending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

