/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.transfers;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.transfers.CapitalGrant;
import com.adyen.model.transfers.CapitalGrantInfo;
import com.adyen.model.transfers.CapitalGrants;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class CapitalApi
extends Service {
    protected String baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/btl/v3");

    public CapitalApi(Client client) {
        super(client);
    }

    public CapitalGrants getCapitalAccount() throws ApiException, IOException {
        return this.getCapitalAccount(null, null);
    }

    public CapitalGrants getCapitalAccount(String counterpartyAccountHolderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (counterpartyAccountHolderId != null) {
            queryParams.put("counterpartyAccountHolderId", counterpartyAccountHolderId);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return CapitalGrants.fromJson(jsonResult);
    }

    public CapitalGrant getGrantReferenceDetails(String id) throws ApiException, IOException {
        return this.getGrantReferenceDetails(id, null);
    }

    public CapitalGrant getGrantReferenceDetails(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grants/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return CapitalGrant.fromJson(jsonResult);
    }

    public CapitalGrant requestGrantPayout(CapitalGrantInfo capitalGrantInfo) throws ApiException, IOException {
        return this.requestGrantPayout(capitalGrantInfo, null);
    }

    public CapitalGrant requestGrantPayout(CapitalGrantInfo capitalGrantInfo, RequestOptions requestOptions) throws ApiException, IOException {
        String requestBody = capitalGrantInfo.toJson();
        Resource resource = new Resource(this, this.baseURL + "/grants", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, null);
        return CapitalGrant.fromJson(jsonResult);
    }
}

