/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.notification;

import com.adyen.model.notification.NotificationRequestItem;
import com.adyen.model.notification.NotificationRequestItemContainer;
import com.adyen.util.Util;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class NotificationRequest {
    @SerializedName(value="live")
    private String live = null;
    @SerializedName(value="notificationItems")
    private List<NotificationRequestItemContainer> notificationItemContainers = null;

    public String getLive() {
        return this.live;
    }

    public NotificationRequest setLive(String live) {
        this.live = live;
        return this;
    }

    public List<NotificationRequestItemContainer> getNotificationItemContainers() {
        return this.notificationItemContainers;
    }

    public void setNotificationItemContainers(List<NotificationRequestItemContainer> notificationItemContainers) {
        this.notificationItemContainers = notificationItemContainers;
    }

    public List<NotificationRequestItem> getNotificationItems() {
        if (this.notificationItemContainers == null) {
            return null;
        }
        return this.notificationItemContainers.stream().map(s -> s.getNotificationItem()).collect(Collectors.toList());
    }

    public void setNotificationItems(List<NotificationRequestItem> notificationItems) {
        this.notificationItemContainers = new ArrayList<NotificationRequestItemContainer>();
        for (NotificationRequestItem requestItem : notificationItems) {
            NotificationRequestItemContainer requestItemContainer = new NotificationRequestItemContainer();
            requestItemContainer.setNotificationItem(requestItem);
            this.notificationItemContainers.add(requestItemContainer);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationRequestItem {\n");
        sb.append("    live: ").append(Util.toIndentedString(this.live)).append("\n");
        sb.append("    notificationItems: ").append(Util.toIndentedString(this.notificationItemContainers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static NotificationRequest fromJson(String jsonString) throws IOException {
        return (NotificationRequest)new Gson().fromJson(jsonString, NotificationRequest.class);
    }

    public String toJson() {
        return new Gson().toJson((Object)this);
    }
}

