/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.StoreLocation;
import com.adyen.model.management.StoreSplitConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "businessLineIds", "description", "externalReferenceId", "merchantId", "phoneNumber", "reference", "shopperStatement", "splitConfiguration"})
public class StoreCreationWithMerchantCodeRequest {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private StoreLocation address;
    public static final String JSON_PROPERTY_BUSINESS_LINE_IDS = "businessLineIds";
    private List<String> businessLineIds = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EXTERNAL_REFERENCE_ID = "externalReferenceId";
    private String externalReferenceId;
    public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
    private String merchantId;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    public static final String JSON_PROPERTY_SPLIT_CONFIGURATION = "splitConfiguration";
    private StoreSplitConfiguration splitConfiguration;

    public StoreCreationWithMerchantCodeRequest address(StoreLocation address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StoreLocation getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(StoreLocation address) {
        this.address = address;
    }

    public StoreCreationWithMerchantCodeRequest businessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
        return this;
    }

    public StoreCreationWithMerchantCodeRequest addBusinessLineIdsItem(String businessLineIdsItem) {
        if (this.businessLineIds == null) {
            this.businessLineIds = new ArrayList<String>();
        }
        this.businessLineIds.add(businessLineIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/legalentity/latest/post/businessLines#responses-200-id) that the store is associated with. If not specified, the business line of the merchant account is used. Required when there are multiple business lines under the merchant account.")
    @JsonProperty(value="businessLineIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBusinessLineIds() {
        return this.businessLineIds;
    }

    @JsonProperty(value="businessLineIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
    }

    public StoreCreationWithMerchantCodeRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Your description of the store.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public StoreCreationWithMerchantCodeRequest externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @ApiModelProperty(value="Used by certain payment methods and tax authorities to uniquely identify the store.  For CNPJ in Brazil, ZIP in Australia and SIRET in France. This field is conditionally required if the store is in Brazil, Australia or France.  For CNPJ the format is 00.000.000/0000-00, can be submitted as just digits, or with dots, slash & hyphen.  For Australian stores ZIP an optional field used by the Zip payment method.  For SIRET the format is 14 digits.")
    @JsonProperty(value="externalReferenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    @JsonProperty(value="externalReferenceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public StoreCreationWithMerchantCodeRequest merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the merchant account that the store belongs to.")
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public StoreCreationWithMerchantCodeRequest phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The phone number of the store, including '+' and country code.")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public StoreCreationWithMerchantCodeRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference to recognize the store by. Also known as the store code.  Allowed characters: lowercase and uppercase letters without diacritics, numbers 0 through 9, hyphen (-), and underscore (_).  If you do not provide a reference in your POST request, it is populated with the Adyen-generated [id](https://docs.adyen.com/api-explorer/Management/latest/post/stores#responses-200-id).")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoreCreationWithMerchantCodeRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(required=true, value="The store name to be shown on the shopper's bank or credit card statement and on the shopper receipt. Maximum length: 22 characters; can't be all numbers.")
    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public StoreCreationWithMerchantCodeRequest splitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="splitConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StoreSplitConfiguration getSplitConfiguration() {
        return this.splitConfiguration;
    }

    @JsonProperty(value="splitConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreCreationWithMerchantCodeRequest storeCreationWithMerchantCodeRequest = (StoreCreationWithMerchantCodeRequest)o;
        return Objects.equals(this.address, storeCreationWithMerchantCodeRequest.address) && Objects.equals(this.businessLineIds, storeCreationWithMerchantCodeRequest.businessLineIds) && Objects.equals(this.description, storeCreationWithMerchantCodeRequest.description) && Objects.equals(this.externalReferenceId, storeCreationWithMerchantCodeRequest.externalReferenceId) && Objects.equals(this.merchantId, storeCreationWithMerchantCodeRequest.merchantId) && Objects.equals(this.phoneNumber, storeCreationWithMerchantCodeRequest.phoneNumber) && Objects.equals(this.reference, storeCreationWithMerchantCodeRequest.reference) && Objects.equals(this.shopperStatement, storeCreationWithMerchantCodeRequest.shopperStatement) && Objects.equals(this.splitConfiguration, storeCreationWithMerchantCodeRequest.splitConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.businessLineIds, this.description, this.externalReferenceId, this.merchantId, this.phoneNumber, this.reference, this.shopperStatement, this.splitConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreCreationWithMerchantCodeRequest {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    businessLineIds: ").append(this.toIndentedString(this.businessLineIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    splitConfiguration: ").append(this.toIndentedString(this.splitConfiguration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoreCreationWithMerchantCodeRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoreCreationWithMerchantCodeRequest)JSON.getMapper().readValue(jsonString, StoreCreationWithMerchantCodeRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

