/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.JSON;
import com.adyen.model.capital.RepaymentTerm;
import com.adyen.model.capital.ThresholdRepayment;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Repayment {
    public static final String SERIALIZED_NAME_BASIS_POINTS = "basisPoints";
    @SerializedName(value="basisPoints")
    private Integer basisPoints;
    public static final String SERIALIZED_NAME_TERM = "term";
    @SerializedName(value="term")
    private RepaymentTerm term;
    public static final String SERIALIZED_NAME_THRESHOLD = "threshold";
    @SerializedName(value="threshold")
    private ThresholdRepayment threshold;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Repayment basisPoints(Integer basisPoints) {
        this.basisPoints = basisPoints;
        return this;
    }

    @ApiModelProperty(required=true, value="The repayment that is deducted daily from incoming net volume, in [basis points](https://www.investopedia.com/terms/b/basispoint.asp).")
    public Integer getBasisPoints() {
        return this.basisPoints;
    }

    public void setBasisPoints(Integer basisPoints) {
        this.basisPoints = basisPoints;
    }

    public Repayment term(RepaymentTerm term) {
        this.term = term;
        return this;
    }

    @ApiModelProperty(value="")
    public RepaymentTerm getTerm() {
        return this.term;
    }

    public void setTerm(RepaymentTerm term) {
        this.term = term;
    }

    public Repayment threshold(ThresholdRepayment threshold) {
        this.threshold = threshold;
        return this;
    }

    @ApiModelProperty(value="")
    public ThresholdRepayment getThreshold() {
        return this.threshold;
    }

    public void setThreshold(ThresholdRepayment threshold) {
        this.threshold = threshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repayment repayment = (Repayment)o;
        return Objects.equals(this.basisPoints, repayment.basisPoints) && Objects.equals(this.term, repayment.term) && Objects.equals(this.threshold, repayment.threshold);
    }

    public int hashCode() {
        return Objects.hash(this.basisPoints, this.term, this.threshold);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Repayment {\n");
        sb.append("    basisPoints: ").append(this.toIndentedString(this.basisPoints)).append("\n");
        sb.append("    term: ").append(this.toIndentedString(this.term)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Repayment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Repayment` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TERM) != null) {
            RepaymentTerm.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TERM));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THRESHOLD) != null) {
            ThresholdRepayment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THRESHOLD));
        }
    }

    public static Repayment fromJson(String jsonString) throws IOException {
        return (Repayment)JSON.getGson().fromJson(jsonString, Repayment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BASIS_POINTS);
        openapiFields.add(SERIALIZED_NAME_TERM);
        openapiFields.add(SERIALIZED_NAME_THRESHOLD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BASIS_POINTS);
        log = Logger.getLogger(Repayment.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Repayment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Repayment.class));
            return new TypeAdapter<Repayment>(){

                public void write(JsonWriter out, Repayment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Repayment read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Repayment.validateJsonObject(jsonObj);
                    return (Repayment)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

