/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Address {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME = "houseNumberOrName";
    @SerializedName(value="houseNumberOrName")
    private String houseNumberOrName;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postalCode";
    @SerializedName(value="postalCode")
    private String postalCode;
    public static final String SERIALIZED_NAME_STATE_OR_PROVINCE = "stateOrProvince";
    @SerializedName(value="stateOrProvince")
    private String stateOrProvince;
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the city. Maximum length: 3000 characters.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character ISO-3166-1 alpha-2 country code. For example, **US**. > If you don't know the country or are not collecting the country from the shopper, provide `country` as `ZZ`.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Address houseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
        return this;
    }

    @ApiModelProperty(required=true, value="The number or name of the house. Maximum length: 3000 characters.")
    public String getHouseNumberOrName() {
        return this.houseNumberOrName;
    }

    public void setHouseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(required=true, value="A maximum of five digits for an address in the US, or a maximum of ten characters for an address in all other countries.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The two-character ISO 3166-2 state or province code. For example, **CA** in the US or **ON** in Canada. > Required for the US and Canada.")
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public Address street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the street. Maximum length: 3000 characters. > The house number should not be included in this field; it should be separately provided via `houseNumberOrName`.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.city, address.city) && Objects.equals(this.country, address.country) && Objects.equals(this.houseNumberOrName, address.houseNumberOrName) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.stateOrProvince, address.stateOrProvince) && Objects.equals(this.street, address.street);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.houseNumberOrName, this.postalCode, this.stateOrProvince, this.street);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    houseNumberOrName: ").append(this.toIndentedString(this.houseNumberOrName)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Address is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Address` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME) != null && !jsonObj.get(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `houseNumberOrName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `postalCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE) != null && !jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `stateOrProvince` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STREET) != null && !jsonObj.get(SERIALIZED_NAME_STREET).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `street` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STREET).toString()));
        }
    }

    public static Address fromJson(String jsonString) throws IOException {
        return (Address)JSON.getGson().fromJson(jsonString, Address.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME);
        openapiFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiFields.add(SERIALIZED_NAME_STATE_OR_PROVINCE);
        openapiFields.add(SERIALIZED_NAME_STREET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CITY);
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY);
        openapiRequiredFields.add(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_STREET);
        log = Logger.getLogger(Address.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Address.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Address.class));
            return new TypeAdapter<Address>(){

                public void write(JsonWriter out, Address value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Address read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Address.validateJsonObject(jsonObj);
                    return (Address)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

