/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.CustomNotification;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestCompanyWebhookRequest {
    public static final String SERIALIZED_NAME_MERCHANT_IDS = "merchantIds";
    @SerializedName(value="merchantIds")
    private List<String> merchantIds = null;
    public static final String SERIALIZED_NAME_NOTIFICATION = "notification";
    @SerializedName(value="notification")
    private CustomNotification notification;
    public static final String SERIALIZED_NAME_TYPES = "types";
    @SerializedName(value="types")
    private List<String> types = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TestCompanyWebhookRequest merchantIds(List<String> merchantIds) {
        this.merchantIds = merchantIds;
        return this;
    }

    public TestCompanyWebhookRequest addMerchantIdsItem(String merchantIdsItem) {
        if (this.merchantIds == null) {
            this.merchantIds = new ArrayList<String>();
        }
        this.merchantIds.add(merchantIdsItem);
        return this;
    }

    @ApiModelProperty(value="List of `merchantId` values for which test webhooks will be sent. The list can have a maximum of 20 `merchantId` values.  If not specified, we send sample notifications to all the merchant accounts that the webhook is configured for. If this is more than 20 merchant accounts, use this list to specify a subset of the merchant accounts for which to send test notifications.")
    public List<String> getMerchantIds() {
        return this.merchantIds;
    }

    public void setMerchantIds(List<String> merchantIds) {
        this.merchantIds = merchantIds;
    }

    public TestCompanyWebhookRequest notification(CustomNotification notification) {
        this.notification = notification;
        return this;
    }

    @ApiModelProperty(value="")
    public CustomNotification getNotification() {
        return this.notification;
    }

    public void setNotification(CustomNotification notification) {
        this.notification = notification;
    }

    public TestCompanyWebhookRequest types(List<String> types) {
        this.types = types;
        return this;
    }

    public TestCompanyWebhookRequest addTypesItem(String typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<String>();
        }
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(value="List of event codes for which to send test notifications. Only the webhook types below are supported.   Possible values if webhook `type`: **standard**:  * **AUTHORISATION** * **CHARGEBACK_REVERSED** * **ORDER_CLOSED** * **ORDER_OPENED** * **PAIDOUT_REVERSED** * **PAYOUT_THIRDPARTY** * **REFUNDED_REVERSED** * **REFUND_WITH_DATA** * **REPORT_AVAILABLE** * **CUSTOM** - set your custom notification fields in the [`notification`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/companies/{companyId}/webhooks/{webhookId}/test__reqParam_notification) object.  Possible values if webhook `type`: **banktransfer-notification**:  * **PENDING**  Possible values if webhook `type`: **report-notification**:  * **REPORT_AVAILABLE**  Possible values if webhook `type`: **ideal-notification**:  * **AUTHORISATION**  Possible values if webhook `type`: **pending-notification**:  * **PENDING** ")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCompanyWebhookRequest testCompanyWebhookRequest = (TestCompanyWebhookRequest)o;
        return Objects.equals(this.merchantIds, testCompanyWebhookRequest.merchantIds) && Objects.equals(this.notification, testCompanyWebhookRequest.notification) && Objects.equals(this.types, testCompanyWebhookRequest.types);
    }

    public int hashCode() {
        return Objects.hash(this.merchantIds, this.notification, this.types);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestCompanyWebhookRequest {\n");
        sb.append("    merchantIds: ").append(this.toIndentedString(this.merchantIds)).append("\n");
        sb.append("    notification: ").append(this.toIndentedString(this.notification)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TestCompanyWebhookRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TestCompanyWebhookRequest` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_IDS) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_IDS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_IDS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NOTIFICATION) != null) {
            CustomNotification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NOTIFICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_TYPES).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `types` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPES).toString()));
        }
    }

    public static TestCompanyWebhookRequest fromJson(String jsonString) throws IOException {
        return (TestCompanyWebhookRequest)JSON.getGson().fromJson(jsonString, TestCompanyWebhookRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MERCHANT_IDS);
        openapiFields.add(SERIALIZED_NAME_NOTIFICATION);
        openapiFields.add(SERIALIZED_NAME_TYPES);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TestCompanyWebhookRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TestCompanyWebhookRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TestCompanyWebhookRequest.class));
            return new TypeAdapter<TestCompanyWebhookRequest>(){

                public void write(JsonWriter out, TestCompanyWebhookRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TestCompanyWebhookRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TestCompanyWebhookRequest.validateJsonObject(jsonObj);
                    return (TestCompanyWebhookRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

