/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.NameLocation;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MerchantData {
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
    @SerializedName(value="merchantId")
    private String merchantId;
    public static final String SERIALIZED_NAME_NAME_LOCATION = "nameLocation";
    @SerializedName(value="nameLocation")
    private NameLocation nameLocation;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postalCode";
    @SerializedName(value="postalCode")
    private String postalCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MerchantData mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The merchant category code.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public MerchantData merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The merchant identifier.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantData nameLocation(NameLocation nameLocation) {
        this.nameLocation = nameLocation;
        return this;
    }

    @ApiModelProperty(value="")
    public NameLocation getNameLocation() {
        return this.nameLocation;
    }

    public void setNameLocation(NameLocation nameLocation) {
        this.nameLocation = nameLocation;
    }

    public MerchantData postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The merchant postal code.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantData merchantData = (MerchantData)o;
        return Objects.equals(this.mcc, merchantData.mcc) && Objects.equals(this.merchantId, merchantData.merchantId) && Objects.equals(this.nameLocation, merchantData.nameLocation) && Objects.equals(this.postalCode, merchantData.postalCode);
    }

    public int hashCode() {
        return Objects.hash(this.mcc, this.merchantId, this.nameLocation, this.postalCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantData {\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    nameLocation: ").append(this.toIndentedString(this.nameLocation)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantData` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ID) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME_LOCATION) != null) {
            NameLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME_LOCATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `postalCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).toString()));
        }
    }

    public static MerchantData fromJson(String jsonString) throws IOException {
        return (MerchantData)JSON.getGson().fromJson(jsonString, MerchantData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiFields.add(SERIALIZED_NAME_NAME_LOCATION);
        openapiFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(MerchantData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantData.class));
            return new TypeAdapter<MerchantData>(){

                public void write(JsonWriter out, MerchantData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantData.validateJsonObject(jsonObj);
                    return (MerchantData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

