/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PayoutSettingsRequest {
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_ENABLED_FROM_DATE = "enabledFromDate";
    @SerializedName(value="enabledFromDate")
    private String enabledFromDate;
    public static final String SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    @SerializedName(value="transferInstrumentId")
    private String transferInstrumentId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PayoutSettingsRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates if payouts to this bank account are enabled. Default: **true**.  To receive payouts into this bank account, both `enabled` and `allowed` must be **true**.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PayoutSettingsRequest enabledFromDate(String enabledFromDate) {
        this.enabledFromDate = enabledFromDate;
        return this;
    }

    @ApiModelProperty(value="The date when Adyen starts paying out to this bank account.  Format: [ISO 8601](https://www.w3.org/TR/NOTE-datetime), for example, **2019-11-23T12:25:28Z** or **2020-05-27T20:25:28+08:00**.  If not specified, the `enabled` field indicates if payouts are enabled for this bank account.  If a date is specified and:  * `enabled`: **true**, payouts are enabled starting the specified date. * `enabled`: **false**, payouts are disabled until the specified date. On the specified date, `enabled` changes to **true** and this field is reset to **null**.")
    public String getEnabledFromDate() {
        return this.enabledFromDate;
    }

    public void setEnabledFromDate(String enabledFromDate) {
        this.enabledFromDate = enabledFromDate;
    }

    public PayoutSettingsRequest transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments) that contains the details of the bank account.")
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutSettingsRequest payoutSettingsRequest = (PayoutSettingsRequest)o;
        return Objects.equals(this.enabled, payoutSettingsRequest.enabled) && Objects.equals(this.enabledFromDate, payoutSettingsRequest.enabledFromDate) && Objects.equals(this.transferInstrumentId, payoutSettingsRequest.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.enabledFromDate, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutSettingsRequest {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    enabledFromDate: ").append(this.toIndentedString(this.enabledFromDate)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PayoutSettingsRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PayoutSettingsRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLED_FROM_DATE) != null && !jsonObj.get(SERIALIZED_NAME_ENABLED_FROM_DATE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `enabledFromDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLED_FROM_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `transferInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).toString()));
        }
    }

    public static PayoutSettingsRequest fromJson(String jsonString) throws IOException {
        return (PayoutSettingsRequest)JSON.getGson().fromJson(jsonString, PayoutSettingsRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_ENABLED_FROM_DATE);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID);
        log = Logger.getLogger(PayoutSettingsRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PayoutSettingsRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PayoutSettingsRequest.class));
            return new TypeAdapter<PayoutSettingsRequest>(){

                public void write(JsonWriter out, PayoutSettingsRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PayoutSettingsRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PayoutSettingsRequest.validateJsonObject(jsonObj);
                    return (PayoutSettingsRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

