/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MerchantDetails {
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_ENROLLED_IN3_D_SECURE = "enrolledIn3DSecure";
    @SerializedName(value="enrolledIn3DSecure")
    private Boolean enrolledIn3DSecure;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MerchantDetails countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="2-letter ISO 3166 country code of the card acceptor location. > This parameter is required for the merchants who don't use Adyen as the payment authorisation gateway.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public MerchantDetails enrolledIn3DSecure(Boolean enrolledIn3DSecure) {
        this.enrolledIn3DSecure = enrolledIn3DSecure;
        return this;
    }

    @ApiModelProperty(value="If true, indicates that the merchant is enrolled in 3D Secure for the card network.")
    public Boolean getEnrolledIn3DSecure() {
        return this.enrolledIn3DSecure;
    }

    public void setEnrolledIn3DSecure(Boolean enrolledIn3DSecure) {
        this.enrolledIn3DSecure = enrolledIn3DSecure;
    }

    public MerchantDetails mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The merchant category code (MCC) is a four-digit number which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.  The list of MCCs can be found [here](https://en.wikipedia.org/wiki/Merchant_category_code).")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantDetails merchantDetails = (MerchantDetails)o;
        return Objects.equals(this.countryCode, merchantDetails.countryCode) && Objects.equals(this.enrolledIn3DSecure, merchantDetails.enrolledIn3DSecure) && Objects.equals(this.mcc, merchantDetails.mcc);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.enrolledIn3DSecure, this.mcc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantDetails {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    enrolledIn3DSecure: ").append(this.toIndentedString(this.enrolledIn3DSecure)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantDetails` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
    }

    public static MerchantDetails fromJson(String jsonString) throws IOException {
        return (MerchantDetails)JSON.getGson().fromJson(jsonString, MerchantDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_ENROLLED_IN3_D_SECURE);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(MerchantDetails.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantDetails.class));
            return new TypeAdapter<MerchantDetails>(){

                public void write(JsonWriter out, MerchantDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantDetails.validateJsonObject(jsonObj);
                    return (MerchantDetails)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

