/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.reportwebhooks;

import com.adyen.model.reportwebhooks.JSON;
import com.adyen.model.reportwebhooks.ResourceReference;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportNotificationData {
    public static final String SERIALIZED_NAME_ACCOUNT_HOLDER = "accountHolder";
    @SerializedName(value="accountHolder")
    private ResourceReference accountHolder;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT = "balanceAccount";
    @SerializedName(value="balanceAccount")
    private ResourceReference balanceAccount;
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_DOWNLOAD_URL = "downloadUrl";
    @SerializedName(value="downloadUrl")
    private String downloadUrl;
    public static final String SERIALIZED_NAME_FILE_NAME = "fileName";
    @SerializedName(value="fileName")
    private String fileName;
    public static final String SERIALIZED_NAME_REPORT_TYPE = "reportType";
    @SerializedName(value="reportType")
    private String reportType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ReportNotificationData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public ReportNotificationData balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    public ReportNotificationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public ReportNotificationData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public ReportNotificationData downloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL at which you can download the report. To download, you must authenticate your GET request with your [API credentials](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/overview).")
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public ReportNotificationData fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(required=true, value="The filename of the report.")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ReportNotificationData reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of report.")
    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportNotificationData reportNotificationData = (ReportNotificationData)o;
        return Objects.equals(this.accountHolder, reportNotificationData.accountHolder) && Objects.equals(this.balanceAccount, reportNotificationData.balanceAccount) && Objects.equals(this.balancePlatform, reportNotificationData.balancePlatform) && Objects.equals(this.creationDate, reportNotificationData.creationDate) && Objects.equals(this.downloadUrl, reportNotificationData.downloadUrl) && Objects.equals(this.fileName, reportNotificationData.fileName) && Objects.equals(this.reportType, reportNotificationData.reportType);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolder, this.balanceAccount, this.balancePlatform, this.creationDate, this.downloadUrl, this.fileName, this.reportType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportNotificationData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    downloadUrl: ").append(this.toIndentedString(this.downloadUrl)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString(this.reportType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ReportNotificationData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ReportNotificationData` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_HOLDER) != null) {
            ResourceReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_HOLDER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE_ACCOUNT) != null) {
            ResourceReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE_ACCOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL) != null && !jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `downloadUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOWNLOAD_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FILE_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `fileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPORT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_REPORT_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reportType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPORT_TYPE).toString()));
        }
    }

    public static ReportNotificationData fromJson(String jsonString) throws IOException {
        return (ReportNotificationData)JSON.getGson().fromJson(jsonString, ReportNotificationData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_DOWNLOAD_URL);
        openapiFields.add(SERIALIZED_NAME_FILE_NAME);
        openapiFields.add(SERIALIZED_NAME_REPORT_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DOWNLOAD_URL);
        openapiRequiredFields.add(SERIALIZED_NAME_FILE_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_REPORT_TYPE);
        log = Logger.getLogger(ReportNotificationData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ReportNotificationData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ReportNotificationData.class));
            return new TypeAdapter<ReportNotificationData>(){

                public void write(JsonWriter out, ReportNotificationData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ReportNotificationData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ReportNotificationData.validateJsonObject(jsonObj);
                    return (ReportNotificationData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

