/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssignTerminalsRequest {
    public static final String SERIALIZED_NAME_COMPANY_ACCOUNT = "companyAccount";
    @SerializedName(value="companyAccount")
    private String companyAccount;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_INVENTORY = "merchantInventory";
    @SerializedName(value="merchantInventory")
    private Boolean merchantInventory;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_TERMINALS = "terminals";
    @SerializedName(value="terminals")
    private List<String> terminals = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public AssignTerminalsRequest companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your company account. To return terminals to the company inventory, specify only this parameter and the `terminals`.")
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public AssignTerminalsRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="Name of the merchant account. Specify this parameter to assign terminals to this merchant account or to a store under this merchant account.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public AssignTerminalsRequest merchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
        return this;
    }

    @ApiModelProperty(value="Boolean that indicates if you are assigning the terminals to the merchant inventory. Do not use when assigning terminals to a store. Required when assigning the terminal to a merchant account.  - Set this to **true** to assign the terminals to the merchant inventory. This also means that the terminals cannot be boarded.  - Set this to **false** to assign the terminals to the merchant account as in-store terminals. This makes the terminals ready to be boarded and to process payments through the specified merchant account.")
    public Boolean getMerchantInventory() {
        return this.merchantInventory;
    }

    public void setMerchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
    }

    public AssignTerminalsRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store that you want to assign the terminals to.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public AssignTerminalsRequest terminals(List<String> terminals) {
        this.terminals = terminals;
        return this;
    }

    public AssignTerminalsRequest addTerminalsItem(String terminalsItem) {
        this.terminals.add(terminalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array containing a list of terminal IDs that you want to assign or reassign to the merchant account or store, or that you want to return to the company inventory.  For example, `[\"V400m-324689776\",\"P400Plus-329127412\"]`.")
    public List<String> getTerminals() {
        return this.terminals;
    }

    public void setTerminals(List<String> terminals) {
        this.terminals = terminals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignTerminalsRequest assignTerminalsRequest = (AssignTerminalsRequest)o;
        return Objects.equals(this.companyAccount, assignTerminalsRequest.companyAccount) && Objects.equals(this.merchantAccount, assignTerminalsRequest.merchantAccount) && Objects.equals(this.merchantInventory, assignTerminalsRequest.merchantInventory) && Objects.equals(this.store, assignTerminalsRequest.store) && Objects.equals(this.terminals, assignTerminalsRequest.terminals);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.merchantAccount, this.merchantInventory, this.store, this.terminals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssignTerminalsRequest {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantInventory: ").append(this.toIndentedString(this.merchantInventory)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    terminals: ").append(this.toIndentedString(this.terminals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AssignTerminalsRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AssignTerminalsRequest` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `companyAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINALS) != null && !jsonObj.get(SERIALIZED_NAME_TERMINALS).isJsonArray()) {
            log.log(Level.WARNING, String.format("Expected the field `terminals` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINALS).toString()));
        }
    }

    public static AssignTerminalsRequest fromJson(String jsonString) throws IOException {
        return (AssignTerminalsRequest)JSON.getGson().fromJson(jsonString, AssignTerminalsRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_INVENTORY);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_TERMINALS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_TERMINALS);
        log = Logger.getLogger(AssignTerminalsRequest.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AssignTerminalsRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AssignTerminalsRequest.class));
            return new TypeAdapter<AssignTerminalsRequest>(){

                public void write(JsonWriter out, AssignTerminalsRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AssignTerminalsRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AssignTerminalsRequest.validateJsonObject(jsonObj);
                    return (AssignTerminalsRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

