/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mandate {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_AMOUNT_RULE = "amountRule";
    @SerializedName(value="amountRule")
    private AmountRuleEnum amountRule;
    public static final String SERIALIZED_NAME_BILLING_ATTEMPTS_RULE = "billingAttemptsRule";
    @SerializedName(value="billingAttemptsRule")
    private BillingAttemptsRuleEnum billingAttemptsRule;
    public static final String SERIALIZED_NAME_BILLING_DAY = "billingDay";
    @SerializedName(value="billingDay")
    private String billingDay;
    public static final String SERIALIZED_NAME_ENDS_AT = "endsAt";
    @SerializedName(value="endsAt")
    private String endsAt;
    public static final String SERIALIZED_NAME_FREQUENCY = "frequency";
    @SerializedName(value="frequency")
    private FrequencyEnum frequency;
    public static final String SERIALIZED_NAME_REMARKS = "remarks";
    @SerializedName(value="remarks")
    private String remarks;
    public static final String SERIALIZED_NAME_STARTS_AT = "startsAt";
    @SerializedName(value="startsAt")
    private String startsAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Mandate amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The billing amount (in minor units) of the recurring transactions.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public Mandate amountRule(AmountRuleEnum amountRule) {
        this.amountRule = amountRule;
        return this;
    }

    @ApiModelProperty(value="The limitation rule of the billing amount.  Possible values:  * **max**: The transaction amount can not exceed the `amount`.   * **exact**: The transaction amount should be the same as the `amount`.  ")
    public AmountRuleEnum getAmountRule() {
        return this.amountRule;
    }

    public void setAmountRule(AmountRuleEnum amountRule) {
        this.amountRule = amountRule;
    }

    public Mandate billingAttemptsRule(BillingAttemptsRuleEnum billingAttemptsRule) {
        this.billingAttemptsRule = billingAttemptsRule;
        return this;
    }

    @ApiModelProperty(value="The rule to specify the period, within which the recurring debit can happen, relative to the mandate recurring date.  Possible values:   * **on**: On a specific date.   * **before**:  Before and on a specific date.   * **after**: On and after a specific date.  ")
    public BillingAttemptsRuleEnum getBillingAttemptsRule() {
        return this.billingAttemptsRule;
    }

    public void setBillingAttemptsRule(BillingAttemptsRuleEnum billingAttemptsRule) {
        this.billingAttemptsRule = billingAttemptsRule;
    }

    public Mandate billingDay(String billingDay) {
        this.billingDay = billingDay;
        return this;
    }

    @ApiModelProperty(value="The number of the day, on which the recurring debit can happen. Should be within the same calendar month as the mandate recurring date.  Possible values: 1-31 based on the `frequency`.")
    public String getBillingDay() {
        return this.billingDay;
    }

    public void setBillingDay(String billingDay) {
        this.billingDay = billingDay;
    }

    public Mandate endsAt(String endsAt) {
        this.endsAt = endsAt;
        return this;
    }

    @ApiModelProperty(required=true, value="End date of the billing plan, in YYYY-MM-DD format.")
    public String getEndsAt() {
        return this.endsAt;
    }

    public void setEndsAt(String endsAt) {
        this.endsAt = endsAt;
    }

    public Mandate frequency(FrequencyEnum frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="The frequency with which a shopper should be charged.  Possible values: **daily**, **weekly**, **biWeekly**, **monthly**, **quarterly**, **halfYearly**, **yearly**.")
    public FrequencyEnum getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyEnum frequency) {
        this.frequency = frequency;
    }

    public Mandate remarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    @ApiModelProperty(value="The message shown by UPI to the shopper on the approval screen.")
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Mandate startsAt(String startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    @ApiModelProperty(value="Start date of the billing plan, in YYYY-MM-DD format. By default, the transaction date.")
    public String getStartsAt() {
        return this.startsAt;
    }

    public void setStartsAt(String startsAt) {
        this.startsAt = startsAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mandate mandate = (Mandate)o;
        return Objects.equals(this.amount, mandate.amount) && Objects.equals((Object)this.amountRule, (Object)mandate.amountRule) && Objects.equals((Object)this.billingAttemptsRule, (Object)mandate.billingAttemptsRule) && Objects.equals(this.billingDay, mandate.billingDay) && Objects.equals(this.endsAt, mandate.endsAt) && Objects.equals((Object)this.frequency, (Object)mandate.frequency) && Objects.equals(this.remarks, mandate.remarks) && Objects.equals(this.startsAt, mandate.startsAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountRule, this.billingAttemptsRule, this.billingDay, this.endsAt, this.frequency, this.remarks, this.startsAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Mandate {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountRule: ").append(this.toIndentedString((Object)this.amountRule)).append("\n");
        sb.append("    billingAttemptsRule: ").append(this.toIndentedString((Object)this.billingAttemptsRule)).append("\n");
        sb.append("    billingDay: ").append(this.toIndentedString(this.billingDay)).append("\n");
        sb.append("    endsAt: ").append(this.toIndentedString(this.endsAt)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    remarks: ").append(this.toIndentedString(this.remarks)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Mandate is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Mandate` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT_RULE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AMOUNT_RULE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `amountRule` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT_RULE).toString()));
            }
            AmountRuleEnum.fromValue(jsonObj.get(SERIALIZED_NAME_AMOUNT_RULE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_ATTEMPTS_RULE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BILLING_ATTEMPTS_RULE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `billingAttemptsRule` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BILLING_ATTEMPTS_RULE).toString()));
            }
            BillingAttemptsRuleEnum.fromValue(jsonObj.get(SERIALIZED_NAME_BILLING_ATTEMPTS_RULE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_DAY) != null && !jsonObj.get(SERIALIZED_NAME_BILLING_DAY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `billingDay` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BILLING_DAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENDS_AT) != null && !jsonObj.get(SERIALIZED_NAME_ENDS_AT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `endsAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDS_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FREQUENCY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FREQUENCY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `frequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FREQUENCY).toString()));
            }
            FrequencyEnum.fromValue(jsonObj.get(SERIALIZED_NAME_FREQUENCY).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REMARKS) != null && !jsonObj.get(SERIALIZED_NAME_REMARKS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `remarks` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REMARKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STARTS_AT) != null && !jsonObj.get(SERIALIZED_NAME_STARTS_AT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `startsAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STARTS_AT).toString()));
        }
    }

    public static Mandate fromJson(String jsonString) throws IOException {
        return (Mandate)JSON.getGson().fromJson(jsonString, Mandate.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_AMOUNT_RULE);
        openapiFields.add(SERIALIZED_NAME_BILLING_ATTEMPTS_RULE);
        openapiFields.add(SERIALIZED_NAME_BILLING_DAY);
        openapiFields.add(SERIALIZED_NAME_ENDS_AT);
        openapiFields.add(SERIALIZED_NAME_FREQUENCY);
        openapiFields.add(SERIALIZED_NAME_REMARKS);
        openapiFields.add(SERIALIZED_NAME_STARTS_AT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ENDS_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_FREQUENCY);
        log = Logger.getLogger(Mandate.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Mandate.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Mandate.class));
            return new TypeAdapter<Mandate>(){

                public void write(JsonWriter out, Mandate value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Mandate read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Mandate.validateJsonObject(jsonObj);
                    return (Mandate)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FrequencyEnum {
        ADHOC("adhoc"),
        DAILY("daily"),
        WEEKLY("weekly"),
        BIWEEKLY("biWeekly"),
        MONTHLY("monthly"),
        QUARTERLY("quarterly"),
        HALFYEARLY("halfYearly"),
        YEARLY("yearly");

        private String value;

        private FrequencyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FrequencyEnum fromValue(String value) {
            for (FrequencyEnum b : FrequencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FrequencyEnum> {
            public void write(JsonWriter jsonWriter, FrequencyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FrequencyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FrequencyEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingAttemptsRuleEnum {
        ON("on"),
        BEFORE("before"),
        AFTER("after");

        private String value;

        private BillingAttemptsRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingAttemptsRuleEnum fromValue(String value) {
            for (BillingAttemptsRuleEnum b : BillingAttemptsRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingAttemptsRuleEnum> {
            public void write(JsonWriter jsonWriter, BillingAttemptsRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingAttemptsRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingAttemptsRuleEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AmountRuleEnum {
        MAX("max"),
        EXACT("exact");

        private String value;

        private AmountRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AmountRuleEnum fromValue(String value) {
            for (AmountRuleEnum b : AmountRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AmountRuleEnum> {
            public void write(JsonWriter jsonWriter, AmountRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AmountRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AmountRuleEnum.fromValue(value);
            }
        }
    }
}

