/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckoutBalanceCheckResponse {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private Amount balance;
    public static final String SERIALIZED_NAME_FRAUD_RESULT = "fraudResult";
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_REFUSAL_REASON = "refusalReason";
    @SerializedName(value="refusalReason")
    private String refusalReason;
    public static final String SERIALIZED_NAME_RESULT_CODE = "resultCode";
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode;
    public static final String SERIALIZED_NAME_TRANSACTION_LIMIT = "transactionLimit";
    @SerializedName(value="transactionLimit")
    private Amount transactionLimit;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CheckoutBalanceCheckResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CheckoutBalanceCheckResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CheckoutBalanceCheckResponse balance(Amount balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getBalance() {
        return this.balance;
    }

    public void setBalance(Amount balance) {
        this.balance = balance;
    }

    public CheckoutBalanceCheckResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public CheckoutBalanceCheckResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public CheckoutBalanceCheckResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public CheckoutBalanceCheckResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The result of the cancellation request.  Possible values:  * **Success** \u2013 Indicates that the balance check was successful. * **NotEnoughBalance** \u2013 Commonly indicates that the card did not have enough balance to pay the amount in the request, or that the currency of the balance on the card did not match the currency of the requested amount. * **Failed** \u2013 Indicates that the balance check failed.")
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public CheckoutBalanceCheckResponse transactionLimit(Amount transactionLimit) {
        this.transactionLimit = transactionLimit;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTransactionLimit() {
        return this.transactionLimit;
    }

    public void setTransactionLimit(Amount transactionLimit) {
        this.transactionLimit = transactionLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutBalanceCheckResponse checkoutBalanceCheckResponse = (CheckoutBalanceCheckResponse)o;
        return Objects.equals(this.additionalData, checkoutBalanceCheckResponse.additionalData) && Objects.equals(this.balance, checkoutBalanceCheckResponse.balance) && Objects.equals(this.fraudResult, checkoutBalanceCheckResponse.fraudResult) && Objects.equals(this.pspReference, checkoutBalanceCheckResponse.pspReference) && Objects.equals(this.refusalReason, checkoutBalanceCheckResponse.refusalReason) && Objects.equals((Object)this.resultCode, (Object)checkoutBalanceCheckResponse.resultCode) && Objects.equals(this.transactionLimit, checkoutBalanceCheckResponse.transactionLimit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.balance, this.fraudResult, this.pspReference, this.refusalReason, this.resultCode, this.transactionLimit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutBalanceCheckResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    transactionLimit: ").append(this.toIndentedString(this.transactionLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutBalanceCheckResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CheckoutBalanceCheckResponse` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT) != null) {
            FraudResult.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `refusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT_CODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULT_CODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `resultCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT_CODE).toString()));
            }
            ResultCodeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RESULT_CODE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TRANSACTION_LIMIT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TRANSACTION_LIMIT));
        }
    }

    public static CheckoutBalanceCheckResponse fromJson(String jsonString) throws IOException {
        return (CheckoutBalanceCheckResponse)JSON.getGson().fromJson(jsonString, CheckoutBalanceCheckResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_BALANCE);
        openapiFields.add(SERIALIZED_NAME_FRAUD_RESULT);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFUSAL_REASON);
        openapiFields.add(SERIALIZED_NAME_RESULT_CODE);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_LIMIT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BALANCE);
        openapiRequiredFields.add(SERIALIZED_NAME_RESULT_CODE);
        log = Logger.getLogger(CheckoutBalanceCheckResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CheckoutBalanceCheckResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CheckoutBalanceCheckResponse.class));
            return new TypeAdapter<CheckoutBalanceCheckResponse>(){

                public void write(JsonWriter out, CheckoutBalanceCheckResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CheckoutBalanceCheckResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CheckoutBalanceCheckResponse.validateJsonObject(jsonObj);
                    return (CheckoutBalanceCheckResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultCodeEnum {
        SUCCESS("Success"),
        NOTENOUGHBALANCE("NotEnoughBalance"),
        FAILED("Failed");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResultCodeEnum> {
            public void write(JsonWriter jsonWriter, ResultCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultCodeEnum.fromValue(value);
            }
        }
    }
}

