/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeOfDay {
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private String endTime;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private String startTime;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TimeOfDay endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time in a time-only ISO-8601 extended offset format. For example: **08:00:00+02:00**, **22:30:00-03:00**.  ")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public TimeOfDay startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time in a time-only ISO-8601 extended offset format. For example: **08:00:00+02:00**, **22:30:00-03:00**.  ")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOfDay timeOfDay = (TimeOfDay)o;
        return Objects.equals(this.endTime, timeOfDay.endTime) && Objects.equals(this.startTime, timeOfDay.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.endTime, this.startTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOfDay {\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TimeOfDay is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TimeOfDay` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_END_TIME) != null && !jsonObj.get(SERIALIZED_NAME_END_TIME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `endTime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_END_TIME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_START_TIME) != null && !jsonObj.get(SERIALIZED_NAME_START_TIME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `startTime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_START_TIME).toString()));
        }
    }

    public static TimeOfDay fromJson(String jsonString) throws IOException {
        return (TimeOfDay)JSON.getGson().fromJson(jsonString, TimeOfDay.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_END_TIME);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(TimeOfDay.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TimeOfDay.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TimeOfDay.class));
            return new TypeAdapter<TimeOfDay>(){

                public void write(JsonWriter out, TimeOfDay value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TimeOfDay read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TimeOfDay.validateJsonObject(jsonObj);
                    return (TimeOfDay)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

