/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MerchantAcquirerPair {
    public static final String SERIALIZED_NAME_ACQUIRER_ID = "acquirerId";
    @SerializedName(value="acquirerId")
    private String acquirerId;
    public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
    @SerializedName(value="merchantId")
    private String merchantId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public MerchantAcquirerPair acquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
        return this;
    }

    @ApiModelProperty(value="The acquirer ID.")
    public String getAcquirerId() {
        return this.acquirerId;
    }

    public void setAcquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
    }

    public MerchantAcquirerPair merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The merchant identification number (MID).")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantAcquirerPair merchantAcquirerPair = (MerchantAcquirerPair)o;
        return Objects.equals(this.acquirerId, merchantAcquirerPair.acquirerId) && Objects.equals(this.merchantId, merchantAcquirerPair.merchantId);
    }

    public int hashCode() {
        return Objects.hash(this.acquirerId, this.merchantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantAcquirerPair {\n");
        sb.append("    acquirerId: ").append(this.toIndentedString(this.acquirerId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantAcquirerPair is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `MerchantAcquirerPair` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACQUIRER_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACQUIRER_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `acquirerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACQUIRER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ID) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).toString()));
        }
    }

    public static MerchantAcquirerPair fromJson(String jsonString) throws IOException {
        return (MerchantAcquirerPair)JSON.getGson().fromJson(jsonString, MerchantAcquirerPair.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACQUIRER_ID);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(MerchantAcquirerPair.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantAcquirerPair.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantAcquirerPair.class));
            return new TypeAdapter<MerchantAcquirerPair>(){

                public void write(JsonWriter out, MerchantAcquirerPair value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantAcquirerPair read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantAcquirerPair.validateJsonObject(jsonObj);
                    return (MerchantAcquirerPair)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

