/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import com.adyen.Config;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.RequestOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.codec.binary.Base64;

public class HttpURLConnectionClient
implements ClientInterface {
    private static final String CHARSET = "UTF-8";
    private Proxy proxy;

    @Override
    public String request(String requestUrl, String requestBody, Config config) throws IOException, HTTPClientException {
        return this.request(requestUrl, requestBody, config, false);
    }

    @Override
    public String request(String endpoint, String json, Config config, boolean isApiKeyRequired) throws IOException, HTTPClientException {
        return this.request(endpoint, json, config, isApiKeyRequired, null);
    }

    @Override
    public String request(String requestUrl, String requestBody, Config config, boolean isApiKeyRequired, RequestOptions requestOptions) throws IOException, HTTPClientException {
        HttpURLConnection httpConnection = this.createRequest(requestUrl, config.getApplicationName(), requestOptions);
        String apiKey = config.getApiKey();
        if (isApiKeyRequired || apiKey != null && !apiKey.isEmpty()) {
            this.setApiKey(httpConnection, apiKey);
        } else {
            this.setBasicAuthentication(httpConnection, config.getUsername(), config.getPassword());
        }
        httpConnection.setConnectTimeout(config.getConnectionTimeoutMillis());
        httpConnection.setReadTimeout(config.getReadTimeoutMillis());
        this.setContentType(httpConnection, "application/json");
        return this.doPostRequest(httpConnection, requestBody);
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET);
        String rBody = scanner.useDelimiter("\\A").next();
        scanner.close();
        responseStream.close();
        return rBody;
    }

    @Override
    public String post(String requestUrl, Map<String, String> params, Config config) throws IOException, HTTPClientException {
        String postQuery = this.getQuery(params);
        HttpURLConnection httpConnection = this.createRequest(requestUrl, config.getApplicationName());
        String response = this.doPostRequest(httpConnection, postQuery);
        return response;
    }

    private String getQuery(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> pair : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(pair.getKey(), CHARSET));
            result.append("=");
            result.append(URLEncoder.encode(pair.getValue(), CHARSET));
        }
        return result.toString();
    }

    private HttpURLConnection createRequest(String requestUrl, String applicationName) throws IOException {
        return this.createRequest(requestUrl, applicationName, null);
    }

    private HttpURLConnection createRequest(String requestUrl, String applicationName, RequestOptions requestOptions) throws IOException {
        URL targetUrl = new URL(requestUrl);
        HttpURLConnection httpConnection = this.proxy != null ? (HttpURLConnection)targetUrl.openConnection(this.proxy) : (HttpURLConnection)targetUrl.openConnection();
        httpConnection.setUseCaches(false);
        httpConnection.setDoOutput(true);
        httpConnection.setRequestMethod("POST");
        httpConnection.setRequestProperty("Accept-Charset", CHARSET);
        httpConnection.setRequestProperty("User-Agent", String.format("%s %s/%s", applicationName, "adyen-java-api-library", "2.0.1"));
        if (requestOptions != null && requestOptions.getIdempotencyKey() != null) {
            httpConnection.setRequestProperty("Idempotency-Key", requestOptions.getIdempotencyKey());
        }
        return httpConnection;
    }

    private HttpURLConnection setBasicAuthentication(HttpURLConnection httpConnection, String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        httpConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
        return httpConnection;
    }

    private HttpURLConnection setContentType(HttpURLConnection httpConnection, String contentType) {
        httpConnection.setRequestProperty("Content-Type", contentType);
        return httpConnection;
    }

    private HttpURLConnection setApiKey(HttpURLConnection httpConnection, String apiKey) {
        if (apiKey != null && !apiKey.isEmpty()) {
            httpConnection.setRequestProperty("x-api-key", apiKey);
        }
        return httpConnection;
    }

    private String doPostRequest(HttpURLConnection httpConnection, String requestBody) throws IOException, HTTPClientException {
        String response = null;
        OutputStream outputStream = httpConnection.getOutputStream();
        outputStream.write(requestBody.getBytes());
        outputStream.flush();
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            if (httpConnection.getErrorStream() != null) {
                response = HttpURLConnectionClient.getResponseBody(httpConnection.getErrorStream());
            }
            HTTPClientException httpClientException = new HTTPClientException(responseCode, "HTTP Exception", httpConnection.getHeaderFields(), response);
            throw httpClientException;
        }
        response = HttpURLConnectionClient.getResponseBody(httpConnection.getInputStream());
        httpConnection.disconnect();
        return response;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

