/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payments;

import com.adyen.model.payments.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ThreeDS2Result {
    public static final String SERIALIZED_NAME_AUTHENTICATION_VALUE = "authenticationValue";
    @SerializedName(value="authenticationValue")
    private String authenticationValue;
    public static final String SERIALIZED_NAME_CAVV_ALGORITHM = "cavvAlgorithm";
    @SerializedName(value="cavvAlgorithm")
    private String cavvAlgorithm;
    public static final String SERIALIZED_NAME_CHALLENGE_CANCEL = "challengeCancel";
    @SerializedName(value="challengeCancel")
    private ChallengeCancelEnum challengeCancel;
    public static final String SERIALIZED_NAME_CHALLENGE_INDICATOR = "challengeIndicator";
    @SerializedName(value="challengeIndicator")
    private ChallengeIndicatorEnum challengeIndicator;
    public static final String SERIALIZED_NAME_DS_TRANS_I_D = "dsTransID";
    @SerializedName(value="dsTransID")
    private String dsTransID;
    public static final String SERIALIZED_NAME_ECI = "eci";
    @SerializedName(value="eci")
    private String eci;
    public static final String SERIALIZED_NAME_EXEMPTION_INDICATOR = "exemptionIndicator";
    @SerializedName(value="exemptionIndicator")
    private ExemptionIndicatorEnum exemptionIndicator;
    public static final String SERIALIZED_NAME_MESSAGE_VERSION = "messageVersion";
    @SerializedName(value="messageVersion")
    private String messageVersion;
    public static final String SERIALIZED_NAME_RISK_SCORE = "riskScore";
    @SerializedName(value="riskScore")
    private String riskScore;
    public static final String SERIALIZED_NAME_THREE_D_S_SERVER_TRANS_I_D = "threeDSServerTransID";
    @SerializedName(value="threeDSServerTransID")
    private String threeDSServerTransID;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private String timestamp;
    public static final String SERIALIZED_NAME_TRANS_STATUS = "transStatus";
    @SerializedName(value="transStatus")
    private String transStatus;
    public static final String SERIALIZED_NAME_TRANS_STATUS_REASON = "transStatusReason";
    @SerializedName(value="transStatusReason")
    private String transStatusReason;
    public static final String SERIALIZED_NAME_WHITE_LIST_STATUS = "whiteListStatus";
    @SerializedName(value="whiteListStatus")
    private String whiteListStatus;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ThreeDS2Result authenticationValue(String authenticationValue) {
        this.authenticationValue = authenticationValue;
        return this;
    }

    @ApiModelProperty(value="The `authenticationValue` value as defined in the 3D Secure 2 specification.")
    public String getAuthenticationValue() {
        return this.authenticationValue;
    }

    public void setAuthenticationValue(String authenticationValue) {
        this.authenticationValue = authenticationValue;
    }

    public ThreeDS2Result cavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
        return this;
    }

    @ApiModelProperty(value="The algorithm used by the ACS to calculate the authentication value, only for Cartes Bancaires integrations.")
    public String getCavvAlgorithm() {
        return this.cavvAlgorithm;
    }

    public void setCavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
    }

    public ThreeDS2Result challengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
        return this;
    }

    @ApiModelProperty(value="Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).")
    public ChallengeCancelEnum getChallengeCancel() {
        return this.challengeCancel;
    }

    public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
    }

    public ThreeDS2Result challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
        return this;
    }

    @ApiModelProperty(value="Specifies a preference for receiving a challenge from the issuer. Allowed values: * `noPreference` * `requestNoChallenge` * `requestChallenge` * `requestChallengeAsMandate` ")
    public ChallengeIndicatorEnum getChallengeIndicator() {
        return this.challengeIndicator;
    }

    public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
    }

    public ThreeDS2Result dsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
        return this;
    }

    @ApiModelProperty(value="The `dsTransID` value as defined in the 3D Secure 2 specification.")
    public String getDsTransID() {
        return this.dsTransID;
    }

    public void setDsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
    }

    public ThreeDS2Result eci(String eci) {
        this.eci = eci;
        return this;
    }

    @ApiModelProperty(value="The `eci` value as defined in the 3D Secure 2 specification.")
    public String getEci() {
        return this.eci;
    }

    public void setEci(String eci) {
        this.eci = eci;
    }

    public ThreeDS2Result exemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
        this.exemptionIndicator = exemptionIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates the exemption type that was applied by the issuer to the authentication, if exemption applied. Allowed values: * `lowValue` * `secureCorporate` * `trustedBeneficiary` * `transactionRiskAnalysis` ")
    public ExemptionIndicatorEnum getExemptionIndicator() {
        return this.exemptionIndicator;
    }

    public void setExemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
        this.exemptionIndicator = exemptionIndicator;
    }

    public ThreeDS2Result messageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
        return this;
    }

    @ApiModelProperty(value="The `messageVersion` value as defined in the 3D Secure 2 specification.")
    public String getMessageVersion() {
        return this.messageVersion;
    }

    public void setMessageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
    }

    public ThreeDS2Result riskScore(String riskScore) {
        this.riskScore = riskScore;
        return this;
    }

    @ApiModelProperty(value="Risk score calculated by Cartes Bancaires Directory Server (DS).")
    public String getRiskScore() {
        return this.riskScore;
    }

    public void setRiskScore(String riskScore) {
        this.riskScore = riskScore;
    }

    public ThreeDS2Result threeDSServerTransID(String threeDSServerTransID) {
        this.threeDSServerTransID = threeDSServerTransID;
        return this;
    }

    @ApiModelProperty(value="The `threeDSServerTransID` value as defined in the 3D Secure 2 specification.")
    public String getThreeDSServerTransID() {
        return this.threeDSServerTransID;
    }

    public void setThreeDSServerTransID(String threeDSServerTransID) {
        this.threeDSServerTransID = threeDSServerTransID;
    }

    public ThreeDS2Result timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="The `timestamp` value of the 3D Secure 2 authentication.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public ThreeDS2Result transStatus(String transStatus) {
        this.transStatus = transStatus;
        return this;
    }

    @ApiModelProperty(value="The `transStatus` value as defined in the 3D Secure 2 specification.")
    public String getTransStatus() {
        return this.transStatus;
    }

    public void setTransStatus(String transStatus) {
        this.transStatus = transStatus;
    }

    public ThreeDS2Result transStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
        return this;
    }

    @ApiModelProperty(value="Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")
    public String getTransStatusReason() {
        return this.transStatusReason;
    }

    public void setTransStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
    }

    public ThreeDS2Result whiteListStatus(String whiteListStatus) {
        this.whiteListStatus = whiteListStatus;
        return this;
    }

    @ApiModelProperty(value="The `whiteListStatus` value as defined in the 3D Secure 2 specification.")
    public String getWhiteListStatus() {
        return this.whiteListStatus;
    }

    public void setWhiteListStatus(String whiteListStatus) {
        this.whiteListStatus = whiteListStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDS2Result threeDS2Result = (ThreeDS2Result)o;
        return Objects.equals(this.authenticationValue, threeDS2Result.authenticationValue) && Objects.equals(this.cavvAlgorithm, threeDS2Result.cavvAlgorithm) && Objects.equals((Object)this.challengeCancel, (Object)threeDS2Result.challengeCancel) && Objects.equals((Object)this.challengeIndicator, (Object)threeDS2Result.challengeIndicator) && Objects.equals(this.dsTransID, threeDS2Result.dsTransID) && Objects.equals(this.eci, threeDS2Result.eci) && Objects.equals((Object)this.exemptionIndicator, (Object)threeDS2Result.exemptionIndicator) && Objects.equals(this.messageVersion, threeDS2Result.messageVersion) && Objects.equals(this.riskScore, threeDS2Result.riskScore) && Objects.equals(this.threeDSServerTransID, threeDS2Result.threeDSServerTransID) && Objects.equals(this.timestamp, threeDS2Result.timestamp) && Objects.equals(this.transStatus, threeDS2Result.transStatus) && Objects.equals(this.transStatusReason, threeDS2Result.transStatusReason) && Objects.equals(this.whiteListStatus, threeDS2Result.whiteListStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationValue, this.cavvAlgorithm, this.challengeCancel, this.challengeIndicator, this.dsTransID, this.eci, this.exemptionIndicator, this.messageVersion, this.riskScore, this.threeDSServerTransID, this.timestamp, this.transStatus, this.transStatusReason, this.whiteListStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDS2Result {\n");
        sb.append("    authenticationValue: ").append(this.toIndentedString(this.authenticationValue)).append("\n");
        sb.append("    cavvAlgorithm: ").append(this.toIndentedString(this.cavvAlgorithm)).append("\n");
        sb.append("    challengeCancel: ").append(this.toIndentedString((Object)this.challengeCancel)).append("\n");
        sb.append("    challengeIndicator: ").append(this.toIndentedString((Object)this.challengeIndicator)).append("\n");
        sb.append("    dsTransID: ").append(this.toIndentedString(this.dsTransID)).append("\n");
        sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        sb.append("    exemptionIndicator: ").append(this.toIndentedString((Object)this.exemptionIndicator)).append("\n");
        sb.append("    messageVersion: ").append(this.toIndentedString(this.messageVersion)).append("\n");
        sb.append("    riskScore: ").append(this.toIndentedString(this.riskScore)).append("\n");
        sb.append("    threeDSServerTransID: ").append(this.toIndentedString(this.threeDSServerTransID)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transStatus: ").append(this.toIndentedString(this.transStatus)).append("\n");
        sb.append("    transStatusReason: ").append(this.toIndentedString(this.transStatusReason)).append("\n");
        sb.append("    whiteListStatus: ").append(this.toIndentedString(this.whiteListStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDS2Result is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ThreeDS2Result` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `authenticationValue` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHENTICATION_VALUE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM) != null && !jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cavvAlgorithm` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAVV_ALGORITHM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `challengeCancel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL).toString()));
            }
            ChallengeCancelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHALLENGE_CANCEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `challengeIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR).toString()));
            }
            ChallengeIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CHALLENGE_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DS_TRANS_I_D) != null && !jsonObj.get(SERIALIZED_NAME_DS_TRANS_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `dsTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DS_TRANS_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ECI) != null && !jsonObj.get(SERIALIZED_NAME_ECI).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `eci` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ECI).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXEMPTION_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EXEMPTION_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `exemptionIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXEMPTION_INDICATOR).toString()));
            }
            ExemptionIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_EXEMPTION_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `messageVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RISK_SCORE) != null && !jsonObj.get(SERIALIZED_NAME_RISK_SCORE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `riskScore` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RISK_SCORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_SERVER_TRANS_I_D) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_SERVER_TRANS_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDSServerTransID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_SERVER_TRANS_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMESTAMP) != null && !jsonObj.get(SERIALIZED_NAME_TIMESTAMP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timestamp` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMESTAMP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANS_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_TRANS_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANS_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANS_STATUS_REASON) != null && !jsonObj.get(SERIALIZED_NAME_TRANS_STATUS_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transStatusReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANS_STATUS_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WHITE_LIST_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_WHITE_LIST_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `whiteListStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WHITE_LIST_STATUS).toString()));
        }
    }

    public static ThreeDS2Result fromJson(String jsonString) throws IOException {
        return (ThreeDS2Result)JSON.getGson().fromJson(jsonString, ThreeDS2Result.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTHENTICATION_VALUE);
        openapiFields.add(SERIALIZED_NAME_CAVV_ALGORITHM);
        openapiFields.add(SERIALIZED_NAME_CHALLENGE_CANCEL);
        openapiFields.add(SERIALIZED_NAME_CHALLENGE_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_DS_TRANS_I_D);
        openapiFields.add(SERIALIZED_NAME_ECI);
        openapiFields.add(SERIALIZED_NAME_EXEMPTION_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_MESSAGE_VERSION);
        openapiFields.add(SERIALIZED_NAME_RISK_SCORE);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_SERVER_TRANS_I_D);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_TRANS_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRANS_STATUS_REASON);
        openapiFields.add(SERIALIZED_NAME_WHITE_LIST_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ThreeDS2Result.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ThreeDS2Result.class));
            return new TypeAdapter<ThreeDS2Result>(){

                public void write(JsonWriter out, ThreeDS2Result value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ThreeDS2Result read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ThreeDS2Result.validateJsonObject(jsonObj);
                    return (ThreeDS2Result)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExemptionIndicatorEnum {
        LOWVALUE("lowValue"),
        SECURECORPORATE("secureCorporate"),
        TRUSTEDBENEFICIARY("trustedBeneficiary"),
        TRANSACTIONRISKANALYSIS("transactionRiskAnalysis");

        private String value;

        private ExemptionIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExemptionIndicatorEnum fromValue(String value) {
            for (ExemptionIndicatorEnum b : ExemptionIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ExemptionIndicatorEnum> {
            public void write(JsonWriter jsonWriter, ExemptionIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExemptionIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExemptionIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChallengeIndicatorEnum {
        NOPREFERENCE("noPreference"),
        REQUESTNOCHALLENGE("requestNoChallenge"),
        REQUESTCHALLENGE("requestChallenge"),
        REQUESTCHALLENGEASMANDATE("requestChallengeAsMandate");

        private String value;

        private ChallengeIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChallengeIndicatorEnum fromValue(String value) {
            for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChallengeIndicatorEnum> {
            public void write(JsonWriter jsonWriter, ChallengeIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChallengeIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChallengeIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChallengeCancelEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06"),
        _07("07");

        private String value;

        private ChallengeCancelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChallengeCancelEnum fromValue(String value) {
            for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ChallengeCancelEnum> {
            public void write(JsonWriter jsonWriter, ChallengeCancelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ChallengeCancelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChallengeCancelEnum.fromValue(value);
            }
        }
    }
}

