/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payments;

import com.adyen.model.payments.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ModificationResult {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_RESPONSE = "response";
    @SerializedName(value="response")
    private ResponseEnum response;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ModificationResult additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public ModificationResult putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be returned in a particular modification response.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public ModificationResult pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="Adyen's 16-character string reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public ModificationResult response(ResponseEnum response) {
        this.response = response;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the modification request has been received for processing.")
    public ResponseEnum getResponse() {
        return this.response;
    }

    public void setResponse(ResponseEnum response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModificationResult modificationResult = (ModificationResult)o;
        return Objects.equals(this.additionalData, modificationResult.additionalData) && Objects.equals(this.pspReference, modificationResult.pspReference) && Objects.equals((Object)this.response, (Object)modificationResult.response);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.pspReference, this.response});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModificationResult {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    response: ").append(this.toIndentedString((Object)this.response)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ModificationResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ModificationResult` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESPONSE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESPONSE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `response` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESPONSE).toString()));
            }
            ResponseEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RESPONSE).getAsString());
        }
    }

    public static ModificationResult fromJson(String jsonString) throws IOException {
        return (ModificationResult)JSON.getGson().fromJson(jsonString, ModificationResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_RESPONSE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_RESPONSE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ModificationResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ModificationResult.class));
            return new TypeAdapter<ModificationResult>(){

                public void write(JsonWriter out, ModificationResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ModificationResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ModificationResult.validateJsonObject(jsonObj);
                    return (ModificationResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResponseEnum {
        CAPTURE_RECEIVED_("[capture-received]"),
        CANCEL_RECEIVED_("[cancel-received]"),
        REFUND_RECEIVED_("[refund-received]"),
        CANCELORREFUND_RECEIVED_("[cancelOrRefund-received]"),
        ADJUSTAUTHORISATION_RECEIVED_("[adjustAuthorisation-received]"),
        DONATION_RECEIVED_("[donation-received]"),
        TECHNICAL_CANCEL_RECEIVED_("[technical-cancel-received]"),
        VOIDPENDINGREFUND_RECEIVED_("[voidPendingRefund-received]");

        private String value;

        private ResponseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResponseEnum fromValue(String value) {
            for (ResponseEnum b : ResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResponseEnum> {
            public void write(JsonWriter jsonWriter, ResponseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResponseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResponseEnum.fromValue(value);
            }
        }
    }
}

