/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StoreLocation {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_LINE1 = "line1";
    @SerializedName(value="line1")
    private String line1;
    public static final String SERIALIZED_NAME_LINE2 = "line2";
    @SerializedName(value="line2")
    private String line2;
    public static final String SERIALIZED_NAME_LINE3 = "line3";
    @SerializedName(value="line3")
    private String line3;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postalCode";
    @SerializedName(value="postalCode")
    private String postalCode;
    public static final String SERIALIZED_NAME_STATE_OR_PROVINCE = "stateOrProvince";
    @SerializedName(value="stateOrProvince")
    private String stateOrProvince;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StoreLocation city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The name of the city.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public StoreLocation country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-letter country code in [ISO_3166-1_alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public StoreLocation line1(String line1) {
        this.line1 = line1;
        return this;
    }

    @ApiModelProperty(value="The street address.")
    public String getLine1() {
        return this.line1;
    }

    public void setLine1(String line1) {
        this.line1 = line1;
    }

    public StoreLocation line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @ApiModelProperty(value="Second address line.")
    public String getLine2() {
        return this.line2;
    }

    public void setLine2(String line2) {
        this.line2 = line2;
    }

    public StoreLocation line3(String line3) {
        this.line3 = line3;
        return this;
    }

    @ApiModelProperty(value="Third address line.")
    public String getLine3() {
        return this.line3;
    }

    public void setLine3(String line3) {
        this.line3 = line3;
    }

    public StoreLocation postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The postal code.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public StoreLocation stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The state or province code as defined in [ISO 3166-2](https://www.iso.org/standard/72483.html). For example, **ON** for Ontario, Canada.  Required for the following countries:  - Australia - Brazil - Canada - India - Mexico - New Zealand - United States")
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreLocation storeLocation = (StoreLocation)o;
        return Objects.equals(this.city, storeLocation.city) && Objects.equals(this.country, storeLocation.country) && Objects.equals(this.line1, storeLocation.line1) && Objects.equals(this.line2, storeLocation.line2) && Objects.equals(this.line3, storeLocation.line3) && Objects.equals(this.postalCode, storeLocation.postalCode) && Objects.equals(this.stateOrProvince, storeLocation.stateOrProvince);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.line1, this.line2, this.line3, this.postalCode, this.stateOrProvince);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreLocation {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    line1: ").append(this.toIndentedString(this.line1)).append("\n");
        sb.append("    line2: ").append(this.toIndentedString(this.line2)).append("\n");
        sb.append("    line3: ").append(this.toIndentedString(this.line3)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoreLocation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StoreLocation` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINE1) != null && !jsonObj.get(SERIALIZED_NAME_LINE1).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `line1` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE1).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINE2) != null && !jsonObj.get(SERIALIZED_NAME_LINE2).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `line2` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE2).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINE3) != null && !jsonObj.get(SERIALIZED_NAME_LINE3).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `line3` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE3).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `postalCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE) != null && !jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stateOrProvince` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE).toString()));
        }
    }

    public static StoreLocation fromJson(String jsonString) throws IOException {
        return (StoreLocation)JSON.getGson().fromJson(jsonString, StoreLocation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_LINE1);
        openapiFields.add(SERIALIZED_NAME_LINE2);
        openapiFields.add(SERIALIZED_NAME_LINE3);
        openapiFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiFields.add(SERIALIZED_NAME_STATE_OR_PROVINCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoreLocation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoreLocation.class));
            return new TypeAdapter<StoreLocation>(){

                public void write(JsonWriter out, StoreLocation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoreLocation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoreLocation.validateJsonObject(jsonObj);
                    return (StoreLocation)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

