/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AndroidApp {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;
    public static final String SERIALIZED_NAME_PACKAGE_NAME = "packageName";
    @SerializedName(value="packageName")
    private String packageName;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_VERSION_CODE = "versionCode";
    @SerializedName(value="versionCode")
    private Integer versionCode;
    public static final String SERIALIZED_NAME_VERSION_NAME = "versionName";
    @SerializedName(value="versionName")
    private String versionName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AndroidApp description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description that was provided when uploading the app. The description is not shown on the terminal.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AndroidApp id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the app.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AndroidApp label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="The app name that is shown on the terminal.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AndroidApp packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    @ApiModelProperty(value="The package name of the app.")
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public AndroidApp status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the app. Possible values:  * `processing`: The app is being signed and converted to a format that the terminal can handle. * `error`: Something went wrong. Check that the app matches the [requirements](https://docs.adyen.com/point-of-sale/android-terminals/app-requirements). * `invalid`: There is something wrong with the APK file of the app. * `ready`: The app has been signed and converted. * `archived`: The app is no longer available.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AndroidApp versionCode(Integer versionCode) {
        this.versionCode = versionCode;
        return this;
    }

    @ApiModelProperty(value="The internal version number of the app.")
    public Integer getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(Integer versionCode) {
        this.versionCode = versionCode;
    }

    public AndroidApp versionName(String versionName) {
        this.versionName = versionName;
        return this;
    }

    @ApiModelProperty(value="The app version number that is shown on the terminal.")
    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidApp androidApp = (AndroidApp)o;
        return Objects.equals(this.description, androidApp.description) && Objects.equals(this.id, androidApp.id) && Objects.equals(this.label, androidApp.label) && Objects.equals(this.packageName, androidApp.packageName) && Objects.equals(this.status, androidApp.status) && Objects.equals(this.versionCode, androidApp.versionCode) && Objects.equals(this.versionName, androidApp.versionName);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.id, this.label, this.packageName, this.status, this.versionCode, this.versionName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AndroidApp {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    packageName: ").append(this.toIndentedString(this.packageName)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    versionCode: ").append(this.toIndentedString(this.versionCode)).append("\n");
        sb.append("    versionName: ").append(this.toIndentedString(this.versionName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AndroidApp is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AndroidApp` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LABEL) != null && !jsonObj.get(SERIALIZED_NAME_LABEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `label` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LABEL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PACKAGE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_PACKAGE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `packageName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PACKAGE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VERSION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `versionName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION_NAME).toString()));
        }
    }

    public static AndroidApp fromJson(String jsonString) throws IOException {
        return (AndroidApp)JSON.getGson().fromJson(jsonString, AndroidApp.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LABEL);
        openapiFields.add(SERIALIZED_NAME_PACKAGE_NAME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_VERSION_CODE);
        openapiFields.add(SERIALIZED_NAME_VERSION_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AndroidApp.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AndroidApp.class));
            return new TypeAdapter<AndroidApp>(){

                public void write(JsonWriter out, AndroidApp value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AndroidApp read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AndroidApp.validateJsonObject(jsonObj);
                    return (AndroidApp)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

