/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.checkout.CreatePaymentLinkRequest;
import com.adyen.model.checkout.PaymentLinkResource;
import com.adyen.model.checkout.UpdatePaymentLinkRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.checkout.PaymentLink;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class PaymentLinks
extends ApiKeyAuthenticatedService {
    private static final String LINK_ID = "linkId";
    private final com.adyen.service.resource.checkout.PaymentLinks paymentLinks = new com.adyen.service.resource.checkout.PaymentLinks(this);
    private final PaymentLink paymentLink = new PaymentLink(this);

    public PaymentLinks(Client client) {
        super(client);
    }

    public PaymentLinkResource create(CreatePaymentLinkRequest createPaymentLinkRequest) throws ApiException, IOException {
        String jsonRequest = GSON.toJson((Object)createPaymentLinkRequest);
        String jsonResult = this.paymentLinks.request(jsonRequest);
        return (PaymentLinkResource)GSON.fromJson(jsonResult, new TypeToken<PaymentLinkResource>(){}.getType());
    }

    public PaymentLinkResource retrieve(String linkId) throws ApiException, IOException {
        Map<String, String> params = Collections.singletonMap(LINK_ID, linkId);
        String jsonResult = this.paymentLink.request(null, null, ApiConstants.HttpMethod.GET, params);
        return (PaymentLinkResource)GSON.fromJson(jsonResult, new TypeToken<PaymentLinkResource>(){}.getType());
    }

    public PaymentLinkResource update(String linkId, UpdatePaymentLinkRequest updatePaymentLinkRequest) throws ApiException, IOException {
        Map<String, String> params = Collections.singletonMap(LINK_ID, linkId);
        String jsonRequest = GSON.toJson((Object)updatePaymentLinkRequest);
        String jsonResult = this.paymentLink.request(jsonRequest, null, ApiConstants.HttpMethod.PATCH, params);
        return (PaymentLinkResource)GSON.fromJson(jsonResult, new TypeToken<PaymentLinkResource>(){}.getType());
    }
}

