/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay.notification;

import com.adyen.model.marketpay.notification.NotificationEventConfiguration;
import com.adyen.model.marketpay.notification.NotificationEventConfigurationContainer;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class NotificationConfigurationDetails {
    @SerializedName(value="settings")
    private Map<String, String> settings = new HashMap<String, String>();
    @SerializedName(value="apiVersion")
    private Integer apiVersion = null;
    @SerializedName(value="eventConfigs")
    @JsonProperty(value="eventConfigs")
    private List<NotificationEventConfigurationContainer> eventConfigsContainer = null;
    private transient List<NotificationEventConfiguration> eventConfigs = null;
    @SerializedName(value="messageFormat")
    private MessageFormatEnum messageFormat = null;
    @SerializedName(value="notifyUsername")
    private String notifyUsername = null;
    @SerializedName(value="sslProtocol")
    private SslProtocolEnum sslProtocol = null;
    @SerializedName(value="notifyURL")
    private String notifyURL = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="notificationId")
    private Long notificationId = null;
    @SerializedName(value="sendActionHeader")
    private Boolean sendActionHeader = null;
    @SerializedName(value="notifyPassword")
    private String notifyPassword = null;

    public NotificationConfigurationDetails settings(Map<String, String> settings) {
        this.settings = settings;
        return this;
    }

    public NotificationConfigurationDetails putSettingsItem(String key, String settingsItem) {
        this.settings.put(key, settingsItem);
        return this;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public NotificationConfigurationDetails apiVersion(Integer apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Integer getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(Integer apiVersion) {
        this.apiVersion = apiVersion;
    }

    public NotificationConfigurationDetails addEventConfigsItem(NotificationEventConfiguration eventConfigsItem) {
        NotificationEventConfigurationContainer notificationEventConfigurationContainer = this.createEventConfigsContainerForEventConfig(eventConfigsItem);
        if (this.eventConfigsContainer == null) {
            this.eventConfigsContainer = new ArrayList<NotificationEventConfigurationContainer>();
        }
        this.eventConfigsContainer.add(notificationEventConfigurationContainer);
        if (this.eventConfigs == null) {
            this.eventConfigs = new ArrayList<NotificationEventConfiguration>();
        }
        this.eventConfigs.add(eventConfigsItem);
        return this;
    }

    public List<NotificationEventConfiguration> getEventConfigs() {
        if (this.eventConfigs == null && this.eventConfigsContainer != null && !this.eventConfigsContainer.isEmpty()) {
            this.eventConfigs = this.eventConfigsContainer.stream().map(s -> s.getNotificationEventConfiguration()).collect(Collectors.toList());
        }
        return this.eventConfigs;
    }

    public void setEventConfigs(List<NotificationEventConfiguration> eventConfigs) {
        this.eventConfigs = eventConfigs;
        this.eventConfigsContainer = eventConfigs.stream().map(s -> this.createEventConfigsContainerForEventConfig((NotificationEventConfiguration)s)).collect(Collectors.toList());
    }

    private NotificationEventConfigurationContainer createEventConfigsContainerForEventConfig(NotificationEventConfiguration notificationConfigurationDetails) {
        NotificationEventConfigurationContainer notificationEventConfigurationContainer = new NotificationEventConfigurationContainer();
        notificationEventConfigurationContainer.setNotificationEventConfiguration(notificationConfigurationDetails);
        return notificationEventConfigurationContainer;
    }

    public NotificationConfigurationDetails messageFormat(MessageFormatEnum messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public MessageFormatEnum getMessageFormat() {
        return this.messageFormat;
    }

    public void setMessageFormat(MessageFormatEnum messageFormat) {
        this.messageFormat = messageFormat;
    }

    public NotificationConfigurationDetails notifyUsername(String notifyUsername) {
        this.notifyUsername = notifyUsername;
        return this;
    }

    public String getNotifyUsername() {
        return this.notifyUsername;
    }

    public void setNotifyUsername(String notifyUsername) {
        this.notifyUsername = notifyUsername;
    }

    public NotificationConfigurationDetails sslProtocol(SslProtocolEnum sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    public SslProtocolEnum getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(SslProtocolEnum sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public NotificationConfigurationDetails notifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
        return this;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    public NotificationConfigurationDetails description(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NotificationConfigurationDetails active(Boolean active) {
        this.active = active;
        return this;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public NotificationConfigurationDetails notificationId(Long notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    public Long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public NotificationConfigurationDetails sendActionHeader(Boolean sendActionHeader) {
        this.sendActionHeader = sendActionHeader;
        return this;
    }

    public Boolean getSendActionHeader() {
        return this.sendActionHeader;
    }

    public void setSendActionHeader(Boolean sendActionHeader) {
        this.sendActionHeader = sendActionHeader;
    }

    public NotificationConfigurationDetails notifyPassword(String notifyPassword) {
        this.notifyPassword = notifyPassword;
        return this;
    }

    public String getNotifyPassword() {
        return this.notifyPassword;
    }

    public void setNotifyPassword(String notifyPassword) {
        this.notifyPassword = notifyPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationConfigurationDetails notificationConfigurationDetails = (NotificationConfigurationDetails)o;
        return Objects.equals(this.settings, notificationConfigurationDetails.settings) && Objects.equals(this.apiVersion, notificationConfigurationDetails.apiVersion) && Objects.equals(this.eventConfigs, notificationConfigurationDetails.eventConfigs) && Objects.equals((Object)this.messageFormat, (Object)notificationConfigurationDetails.messageFormat) && Objects.equals(this.notifyUsername, notificationConfigurationDetails.notifyUsername) && Objects.equals((Object)this.sslProtocol, (Object)notificationConfigurationDetails.sslProtocol) && Objects.equals(this.notifyURL, notificationConfigurationDetails.notifyURL) && Objects.equals(this.description, notificationConfigurationDetails.description) && Objects.equals(this.active, notificationConfigurationDetails.active) && Objects.equals(this.notificationId, notificationConfigurationDetails.notificationId) && Objects.equals(this.sendActionHeader, notificationConfigurationDetails.sendActionHeader) && Objects.equals(this.notifyPassword, notificationConfigurationDetails.notifyPassword);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.settings, this.apiVersion, this.eventConfigs, this.messageFormat, this.notifyUsername, this.sslProtocol, this.notifyURL, this.description, this.active, this.notificationId, this.sendActionHeader, this.notifyPassword});
    }

    public String toString() {
        this.getEventConfigs();
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationConfigurationDetails {\n");
        sb.append("    settings: ").append(Util.toIndentedString(this.settings)).append("\n");
        sb.append("    apiVersion: ").append(Util.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    eventConfigs: ").append(Util.toIndentedString(this.eventConfigs)).append("\n");
        sb.append("    messageFormat: ").append(Util.toIndentedString((Object)this.messageFormat)).append("\n");
        sb.append("    notifyUsername: ").append(Util.toIndentedString(this.notifyUsername)).append("\n");
        sb.append("    sslProtocol: ").append(Util.toIndentedString((Object)this.sslProtocol)).append("\n");
        sb.append("    notifyURL: ").append(Util.toIndentedString(this.notifyURL)).append("\n");
        sb.append("    description: ").append(Util.toIndentedString(this.description)).append("\n");
        sb.append("    active: ").append(Util.toIndentedString(this.active)).append("\n");
        sb.append("    notificationId: ").append(Util.toIndentedString(this.notificationId)).append("\n");
        sb.append("    sendActionHeader: ").append(Util.toIndentedString(this.sendActionHeader)).append("\n");
        sb.append("    notifyPassword: ").append(Util.toIndentedString(this.notifyPassword)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum SslProtocolEnum {
        SSL("SSL"),
        SSLINSECURECIPHERS("SSLInsecureCiphers"),
        SSLV3("SSLv3"),
        TLS("TLS"),
        TLSV10("TLSv10"),
        TLSV10INSECURECIPHERS("TLSv10InsecureCiphers"),
        TLSV11("TLSv11"),
        TLSV12("TLSv12");

        @JsonValue
        private String value;

        private SslProtocolEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MessageFormatEnum {
        JSON("JSON"),
        SOAP("SOAP");

        private String value;

        private MessageFormatEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

