/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.marketpay.AccountHolderDetails;
import com.adyen.model.marketpay.AccountHolderStatus;
import com.adyen.model.marketpay.AccountStatus;
import com.adyen.model.marketpay.ErrorFieldType;
import com.adyen.model.marketpay.ErrorFieldTypeContainer;
import com.adyen.model.marketpay.KYCVerificationResult;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateAccountHolderResponse {
    @SerializedName(value="accountStatus")
    private AccountStatus accountStatus;
    @SerializedName(value="verification")
    private KYCVerificationResult verification;
    @SerializedName(value="submittedAsync")
    private Boolean submittedAsync;
    @SerializedName(value="accountHolderCode")
    private String accountHolderCode;
    @SerializedName(value="accountCode")
    private String accountCode;
    @SerializedName(value="invalidFields")
    public List<ErrorFieldTypeContainer> invalidFieldsContainers;
    private transient List<ErrorFieldType> invalidFields;
    @SerializedName(value="accountHolderDetails")
    private AccountHolderDetails accountHolderDetails;
    @SerializedName(value="accountHolderStatus")
    private AccountHolderStatus accountHolderStatus;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="pspReference")
    private String pspReference;
    @SerializedName(value="legalEntity")
    private LegalEntityEnum legalEntity = null;

    public CreateAccountHolderResponse accountStatus(AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
        return this;
    }

    public AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public void setAccountStatus(AccountStatus accountStatus) {
        this.accountStatus = accountStatus;
    }

    public CreateAccountHolderResponse submittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
        return this;
    }

    public Boolean getSubmittedAsync() {
        return this.submittedAsync;
    }

    public void setSubmittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
    }

    public CreateAccountHolderResponse accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public CreateAccountHolderResponse accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public List<ErrorFieldType> getInvalidFields() {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
            if (this.invalidFieldsContainers != null && !this.invalidFieldsContainers.isEmpty()) {
                for (ErrorFieldTypeContainer invalidFieldsContainer : this.invalidFieldsContainers) {
                    this.invalidFields.add(invalidFieldsContainer.getErrorFieldType());
                }
            }
        }
        return this.invalidFields;
    }

    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        this.invalidFieldsContainers = new ArrayList<ErrorFieldTypeContainer>();
        for (ErrorFieldType invalidField : invalidFields) {
            ErrorFieldTypeContainer invalidFieldContainer = new ErrorFieldTypeContainer(invalidField);
            this.invalidFieldsContainers.add(invalidFieldContainer);
        }
    }

    public CreateAccountHolderResponse addInvalidField(ErrorFieldType invalidField) {
        ErrorFieldTypeContainer invalidFieldContainer = new ErrorFieldTypeContainer(invalidField);
        if (this.invalidFieldsContainers == null) {
            this.invalidFieldsContainers = new ArrayList<ErrorFieldTypeContainer>();
        }
        this.invalidFieldsContainers.add(invalidFieldContainer);
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidField);
        return this;
    }

    public CreateAccountHolderResponse accountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
        return this;
    }

    public AccountHolderDetails getAccountHolderDetails() {
        return this.accountHolderDetails;
    }

    public void setAccountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
    }

    public CreateAccountHolderResponse accountHolderStatus(AccountHolderStatus accountHolderStatus) {
        this.accountHolderStatus = accountHolderStatus;
        return this;
    }

    public AccountHolderStatus getAccountHolderStatus() {
        return this.accountHolderStatus;
    }

    public void setAccountHolderStatus(AccountHolderStatus accountHolderStatus) {
        this.accountHolderStatus = accountHolderStatus;
    }

    public CreateAccountHolderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public KYCVerificationResult getVerification() {
        return this.verification;
    }

    public void setVerification(KYCVerificationResult verification) {
        this.verification = verification;
    }

    public List<ErrorFieldTypeContainer> getInvalidFieldsContainers() {
        return this.invalidFieldsContainers;
    }

    public void setInvalidFieldsContainers(List<ErrorFieldTypeContainer> invalidFieldsContainers) {
        this.invalidFieldsContainers = invalidFieldsContainers;
    }

    public LegalEntityEnum getLegalEntity() {
        return this.legalEntity;
    }

    public void setLegalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAccountHolderResponse createAccountHolderResponse = (CreateAccountHolderResponse)o;
        return Objects.equals(this.accountStatus, createAccountHolderResponse.accountStatus) && Objects.equals(this.verification, createAccountHolderResponse.verification) && Objects.equals(this.submittedAsync, createAccountHolderResponse.submittedAsync) && Objects.equals(this.accountHolderCode, createAccountHolderResponse.accountHolderCode) && Objects.equals(this.accountCode, createAccountHolderResponse.accountCode) && Objects.equals(this.invalidFieldsContainers, createAccountHolderResponse.invalidFieldsContainers) && Objects.equals(this.accountHolderDetails, createAccountHolderResponse.accountHolderDetails) && Objects.equals(this.accountHolderStatus, createAccountHolderResponse.accountHolderStatus) && Objects.equals(this.description, createAccountHolderResponse.description) && Objects.equals(this.pspReference, createAccountHolderResponse.pspReference) && Objects.equals((Object)this.legalEntity, (Object)createAccountHolderResponse.legalEntity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountStatus, this.verification, this.submittedAsync, this.accountHolderCode, this.accountCode, this.invalidFieldsContainers, this.accountHolderDetails, this.accountHolderStatus, this.description, this.pspReference, this.legalEntity});
    }

    public String toString() {
        this.getInvalidFields();
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAccountHolderResponse {\n");
        sb.append("    accountStatus: ").append(this.toIndentedString(this.accountStatus)).append("\n");
        sb.append("    verification: ").append(this.toIndentedString(this.verification)).append("\n");
        sb.append("    submittedAsync: ").append(this.toIndentedString(this.submittedAsync)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    accountHolderDetails: ").append(this.toIndentedString(this.accountHolderDetails)).append("\n");
        sb.append("    accountHolderStatus: ").append(this.toIndentedString(this.accountHolderStatus)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    legalEntity: ").append(this.toIndentedString((Object)this.legalEntity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LegalEntityEnum {
        BUSINESS("Business"),
        INDIVIDUAL("Individual"),
        NONPROFIT("NonProfit");

        private String value;

        private LegalEntityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LegalEntityEnum fromValue(String text) {
            for (LegalEntityEnum b : LegalEntityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LegalEntityEnum> {
            public void write(JsonWriter jsonWriter, LegalEntityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LegalEntityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LegalEntityEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

