/*
 * Decompiled with CFR 0.152.
 */
package com.adups.iot_libs.receiver;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.adups.iot_libs.info.DeviceInfo;
import com.adups.iot_libs.info.UpgradeParamInfo;
import com.adups.iot_libs.report.ReportManager;
import com.adups.iot_libs.service.JobSchedulerService;
import com.adups.iot_libs.service.OtaService;
import com.adups.iot_libs.utils.SPFTool;
import com.adups.trace.Trace;
import java.io.File;

public class UpgradeReceiver
extends BroadcastReceiver {
    private Context a;

    public void onReceive(Context context, Intent intent) {
        this.a = context;
        String string = intent.getAction();
        Trace.d((String)"UpgradeReceiver", (String)("action: " + string));
        this.a(string);
    }

    private void a(String string) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            this.c();
        } else if ("android.intent.action.BOOT_COMPLETED".equals(string)) {
            this.a();
        }
    }

    private void a() {
        SPFTool.putBoolean(this.a, "key_should_report", true);
        String string = SPFTool.getString(this.a, "key_version_name", "");
        String string2 = SPFTool.getString(this.a, "KEY_DELTAID", "");
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            Object object;
            SPFTool.putString(this.a, "key_version_name", "");
            SPFTool.putString(this.a, "KEY_DELTAID", "");
            Trace.i((String)"UpgradeReceiver", (String)("mobile version:" + DeviceInfo.getInstance().version + " update version " + string));
            boolean bl = string.equals(DeviceInfo.getInstance().version);
            Intent intent = new Intent("action_fota_update_result");
            intent.putExtra("key_fota_update_result", bl);
            LocalBroadcastManager.getInstance((Context)this.a).sendBroadcast(intent);
            if (bl) {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() update success!");
                object = SPFTool.getString(this.a, "key_update_file_path", "");
                if (!TextUtils.isEmpty((CharSequence)object)) {
                    new File((String)object).delete();
                }
            } else {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() update failed!");
            }
            object = new UpgradeParamInfo(DeviceInfo.getInstance().mid, string2, String.valueOf(bl ? 1 : 99));
            ReportManager.getInstance(this.a).saveReportData(object);
            if (this.a(this.a)) {
                Trace.d((String)"UpgradeReceiver", (String)"boot_process() boot complete upgrade report");
                this.d();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.b();
            }
        }
    }

    @RequiresApi(api=21)
    private void b() {
        Intent intent = new Intent(this.a, JobSchedulerService.class);
        this.a.startService(intent);
        ComponentName componentName = new ComponentName(this.a, JobSchedulerService.class);
        JobInfo.Builder builder = new JobInfo.Builder(0, componentName);
        builder.setMinimumLatency(1000L);
        builder.setRequiredNetworkType(1);
        JobScheduler jobScheduler = (JobScheduler)this.a.getSystemService("jobscheduler");
        jobScheduler.schedule(builder.build());
    }

    private void c() {
        if (this.a(this.a)) {
            Trace.d((String)"UpgradeReceiver", (String)("network_process() should_report = " + SPFTool.getBoolean(this.a, "key_should_report", false)));
            if (SPFTool.getBoolean(this.a, "key_should_report", false)) {
                this.d();
            }
        }
    }

    private void d() {
        if (ReportManager.getInstance(this.a).queryReport() == 0) {
            SPFTool.putBoolean(this.a, "key_should_report", false);
            Trace.d((String)"UpgradeReceiver", (String)"report() do not have data to be reported!");
            return;
        }
        OtaService.startByAction("action_report");
    }

    private boolean a(Context context) {
        boolean bl = false;
        if (context == null) {
            return bl;
        }
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return bl;
            }
            NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
            if (networkInfoArray == null) {
                return bl;
            }
            for (int j = 0; j < networkInfoArray.length && networkInfoArray[j] != null; ++j) {
                if (!networkInfoArray[j].isConnected() || !networkInfoArray[j].isAvailable()) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            Trace.d((String)"UpgradeReceiver", (String)"==Util:isNetWorkAvailable Exception");
        }
        return bl;
    }
}

