/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.TargetOrder;
import com.adobe.marketing.mobile.target.TargetProduct;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetParameters {
    private static final String CLASS_NAME = "TargetParameters";
    private final Map<String, String> parameters;
    private final Map<String, String> profileParameters;
    private final TargetProduct product;
    private final TargetOrder order;

    private TargetParameters(Builder builder) {
        this.parameters = builder.parameters == null ? new HashMap() : builder.parameters;
        this.profileParameters = builder.profileParameters == null ? new HashMap() : builder.profileParameters;
        this.product = builder.product;
        this.order = builder.order;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getProfileParameters() {
        return this.profileParameters;
    }

    public TargetProduct getProduct() {
        return this.product;
    }

    public TargetOrder getOrder() {
        return this.order;
    }

    static TargetParameters merge(List<TargetParameters> parametersList) {
        Builder builder = new Builder();
        HashMap<String, String> mergedParams = new HashMap<String, String>();
        HashMap<String, String> mergedProfileParams = new HashMap<String, String>();
        TargetProduct mergedProduct = null;
        TargetOrder mergedOrder = null;
        if (parametersList == null) {
            return builder.build();
        }
        for (TargetParameters targetParams : parametersList) {
            if (targetParams == null) continue;
            try {
                if (targetParams.parameters != null && targetParams.parameters.size() > 0) {
                    mergedParams.putAll(targetParams.parameters);
                    mergedParams.remove("");
                }
            }
            catch (Exception e) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"Failed to merge parameters, (%s)", (Object[])new Object[]{e});
            }
            try {
                if (targetParams.profileParameters != null && targetParams.profileParameters.size() > 0) {
                    mergedProfileParams.putAll(targetParams.profileParameters);
                    mergedProfileParams.remove("");
                }
            }
            catch (Exception e) {
                Log.warning((String)"Target", (String)CLASS_NAME, (String)"Failed to merge profile parameters, (%s)", (Object[])new Object[]{e});
            }
            if (targetParams.product != null) {
                mergedProduct = targetParams.product;
            }
            if (targetParams.order == null) continue;
            mergedOrder = targetParams.order;
        }
        return builder.parameters(mergedParams).profileParameters(mergedProfileParams).product(mergedProduct).order(mergedOrder).build();
    }

    public Map<String, Object> toEventData() {
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        parametersMap.put("parameters", this.parameters);
        parametersMap.put("profileParameters", this.profileParameters);
        if (this.order != null) {
            parametersMap.put("order", this.order.toEventData());
        }
        if (this.product != null) {
            parametersMap.put("product", this.product.toEventData());
        }
        return parametersMap;
    }

    static TargetParameters fromEventData(Map<String, Object> data) {
        if (TargetUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetParameters object, provided data Map is empty or null.", (Object[])new Object[0]);
            return null;
        }
        try {
            Map parameters = DataReader.getStringMap(data, (String)"parameters");
            Map profileParameters = DataReader.getStringMap(data, (String)"profileParameters");
            Map productParameters = DataReader.getStringMap(data, (String)"product");
            Map orderParameters = DataReader.getTypedMap(Object.class, data, (String)"order");
            return new Builder().parameters(parameters).profileParameters(profileParameters).order(TargetOrder.fromEventData(orderParameters)).product(TargetProduct.fromEventData(productParameters)).build();
        }
        catch (DataReaderException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetProduct object, provided data contains invalid fields.", (Object[])new Object[0]);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetParameters that = (TargetParameters)o;
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.profileParameters != null ? !this.profileParameters.equals(that.profileParameters) : that.profileParameters != null) {
            return false;
        }
        if (this.order != null ? !this.order.equals(that.order) : that.order != null) {
            return false;
        }
        return this.product != null ? this.product.equals(that.product) : that.product == null;
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.profileParameters, this.order, this.product);
    }

    public static class Builder {
        private Map<String, String> parameters;
        private Map<String, String> profileParameters;
        private TargetProduct product;
        private TargetOrder order;

        public Builder() {
        }

        public Builder(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder profileParameters(Map<String, String> profileParameters) {
            this.profileParameters = profileParameters;
            return this;
        }

        public Builder product(TargetProduct product) {
            this.product = product;
            return this;
        }

        public Builder order(TargetOrder order) {
            this.order = order;
            return this;
        }

        public TargetParameters build() {
            return new TargetParameters(this);
        }
    }
}

