/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.places.PlacesPOI;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlacesUtil {
    private static final double MAX_LAT = 90.0;
    private static final double MIN_LAT = -90.0;
    private static final double MAX_LON = 180.0;
    private static final double MIN_LON = -180.0;
    private static final String CLASS_NAME = "PlacesUtil";

    public static boolean isValidLat(double latitude) {
        return latitude >= -90.0 && latitude <= 90.0;
    }

    public static boolean isValidLon(double longitude) {
        return longitude >= -180.0 && longitude <= 180.0;
    }

    static List<Map<String, Object>> convertPOIListToMap(List<PlacesPOI> poiList) {
        ArrayList<Map<String, Object>> poiMapList = new ArrayList<Map<String, Object>>();
        for (PlacesPOI eachPOI : poiList) {
            poiMapList.add(eachPOI.toMap());
        }
        return poiMapList;
    }

    public static List<PlacesPOI> convertMapToPOIList(List<Map> poiMap) {
        ArrayList<PlacesPOI> poiMapList = new ArrayList<PlacesPOI>();
        for (Map eachMap : poiMap) {
            PlacesPOI poi = new PlacesPOI(DataReader.optString((Map)eachMap, (String)"regionid", null), DataReader.optString((Map)eachMap, (String)"regionname", null), DataReader.optDouble((Map)eachMap, (String)"latitude", (double)0.0), DataReader.optDouble((Map)eachMap, (String)"longitude", (double)0.0), DataReader.optInt((Map)eachMap, (String)"radius", (int)0), DataReader.optString((Map)eachMap, (String)"libraryid", null), DataReader.optInt((Map)eachMap, (String)"weight", (int)0), DataReader.optStringMap((Map)eachMap, (String)"regionmetadata", null));
            poi.setUserIsWithin(DataReader.optBoolean((Map)eachMap, (String)"useriswithin", (boolean)false));
            poiMapList.add(poi);
        }
        return poiMapList;
    }

    static Map<String, String> convertPOIMetadataToStringMap(@NonNull JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject || value instanceof JSONArray) {
                    Log.warning((String)"Places", (String)CLASS_NAME, (String)String.format("Ignoring POI metadata with key: %s which contains invalid datatype.", key), (Object[])new Object[0]);
                    continue;
                }
                map.put(key, value.toString());
            }
            catch (Exception e) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)"The value of [%s] is not supported: %s", (Object[])new Object[]{key, e});
            }
        }
        return map;
    }
}

