/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import android.location.Location;
import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.Places;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.places.PlacesAuthorizationStatus;
import com.adobe.marketing.mobile.places.PlacesConfiguration;
import com.adobe.marketing.mobile.places.PlacesDispatcher;
import com.adobe.marketing.mobile.places.PlacesPOI;
import com.adobe.marketing.mobile.places.PlacesQueryService;
import com.adobe.marketing.mobile.places.PlacesRegion;
import com.adobe.marketing.mobile.places.PlacesRequestError;
import com.adobe.marketing.mobile.places.PlacesState;
import com.adobe.marketing.mobile.places.PlacesUtil;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlacesExtension
extends Extension {
    private static final String CLASS_NAME = "PlacesExtension";
    ExtensionApi extensionApi;
    PlacesDispatcher placesDispatcher;
    PlacesQueryService queryService;
    PlacesState state;

    protected PlacesExtension(ExtensionApi extensionApi) {
        super(extensionApi);
        this.extensionApi = extensionApi;
        this.state = new PlacesState(ServiceProvider.getInstance().getDataStoreService());
        this.queryService = new PlacesQueryService(ServiceProvider.getInstance().getNetworkService());
        this.placesDispatcher = new PlacesDispatcher(extensionApi);
    }

    protected String getVersion() {
        return Places.extensionVersion();
    }

    @NonNull
    protected String getName() {
        return "com.adobe.module.places";
    }

    protected String getFriendlyName() {
        return "Places";
    }

    protected void onRegistered() {
        this.extensionApi.registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", this::handleConfigurationResponseEvent);
        this.extensionApi.registerEventListener("com.adobe.eventType.places", "com.adobe.eventSource.requestContent", this::handlePlacesRequestEvent);
        Map<String, Object> placesSharedState = this.state.getPlacesSharedState();
        if (placesSharedState != null && !placesSharedState.isEmpty()) {
            this.extensionApi.createSharedState(placesSharedState, null);
        }
    }

    public boolean readyForEvent(@NonNull Event event) {
        if (this.extensionApi.getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY).getStatus() == SharedStateStatus.SET) {
            return true;
        }
        Log.debug((String)"Places", (String)CLASS_NAME, (String)"readyForEvent - Waiting for configuration to process places events.", (Object[])new Object[0]);
        return false;
    }

    void handlePlacesRequestEvent(@NonNull Event event) {
        Map eventData = event.getEventData();
        if (eventData == null || eventData.isEmpty()) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handlePlacesRequestEvent - Ignoring Places Request event, eventData is empty.", (Object[])new Object[0]);
            return;
        }
        String requestType = DataReader.optString((Map)eventData, (String)"requesttype", null);
        if (StringUtils.isNullOrEmpty((String)requestType)) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handlePlacesRequestEvent - Ignoring Places Request event due to missing request type", (Object[])new Object[0]);
            return;
        }
        switch (requestType) {
            case "requestgetuserwithinplaces": {
                this.handleGetUserWithinPOIsEvent(event);
                break;
            }
            case "requestgetlastknownlocation": {
                this.handleGetLastKnownLocation(event);
                break;
            }
            case "requestreset": {
                this.reset();
                break;
            }
            case "requestgetnearbyplaces": {
                Map<String, Object> configData = this.retrieveConfigurationEventState(event);
                this.saveLastKnownLocation(event);
                this.handleGetNearByPlaceEvent(event, configData);
                break;
            }
            case "requestprocessregionevent": {
                Map<String, Object> configData = this.retrieveConfigurationEventState(event);
                this.handleGeofenceEvent(event, configData);
                break;
            }
            case "requestsetauthorizationstatus": {
                this.handleSetAuthorizationStatusEvent(event);
                break;
            }
            default: {
                Log.debug((String)"Places", (String)CLASS_NAME, (String)String.format("handlePlacesRequestEvent - Ignoring Places Request event due to a unrecognized request type - %s.", requestType), (Object[])new Object[0]);
            }
        }
    }

    void handleConfigurationResponseEvent(@NonNull Event event) {
        Map<String, Object> configData = this.retrieveConfigurationEventState(event);
        if (this.getMobilePrivacyStatus(configData) == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handleConfigurationResponseEvent - Stopping Places processing due to privacy opt-out.", (Object[])new Object[0]);
            this.extensionApi.stopEvents();
            this.reset();
        }
    }

    private void handleGetUserWithinPOIsEvent(@NonNull Event event) {
        Log.trace((String)"Places", (String)CLASS_NAME, (String)"handleGetUserWithinPOIsEvent - Handling get user-within points of interest event.", (Object[])new Object[0]);
        List<PlacesPOI> userWithinPOIs = this.state.getUserWithInPOIs();
        this.placesDispatcher.dispatchUserWithinPOIs(userWithinPOIs, event);
        this.placesDispatcher.dispatchUserWithinPOIs(userWithinPOIs, null);
    }

    private void handleGetLastKnownLocation(@NonNull Event event) {
        Log.trace((String)"Places", (String)CLASS_NAME, (String)"handleGetLastKnownLocation - Handling get last known location event", (Object[])new Object[0]);
        Location location = this.state.loadLastKnownLocation();
        if (location == null) {
            this.placesDispatcher.dispatchLastKnownLocation(999.999, 999.999, event);
            return;
        }
        this.placesDispatcher.dispatchLastKnownLocation(location.getLatitude(), location.getLongitude(), event);
        this.placesDispatcher.dispatchLastKnownLocation(location.getLatitude(), location.getLongitude(), null);
    }

    private void saveLastKnownLocation(@NonNull Event event) {
        Map<String, Object> configData = this.retrieveConfigurationEventState(event);
        if (this.getMobilePrivacyStatus(configData) == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"saveLastKnownLocation - Ignoring to save the last known location, Privacy opted out", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        double latitude = DataReader.optDouble((Map)eventData, (String)"latitude", (double)999.999);
        double longitude = DataReader.optDouble((Map)eventData, (String)"longitude", (double)999.999);
        if (!PlacesUtil.isValidLat(latitude) || !PlacesUtil.isValidLon(longitude)) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"saveLastKnownLocation - Unable to save location, invalid latitude/longitude", (Object[])new Object[0]);
            return;
        }
        this.state.saveLastKnownLocation(latitude, longitude);
    }

    private void handleSetAuthorizationStatusEvent(@NonNull Event event) {
        Map data = event.getEventData();
        String authStatusString = DataReader.optString((Map)data, (String)"authstatus", null);
        if (!PlacesAuthorizationStatus.isValidStatus(authStatusString)) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handleSetAuthorizationStatusEvent - Invalid Authorization status value is set to Places Extension. Please check PlacesAuthorizationStatus class.", (Object[])new Object[0]);
            return;
        }
        this.state.setAuthorizationStatus(authStatusString);
        this.extensionApi.createSharedState(this.state.getPlacesSharedState(), event);
    }

    private void reset() {
        Log.debug((String)"Places", (String)CLASS_NAME, (String)"reset - Places shared state and persisted data has been reset.", (Object[])new Object[0]);
        this.state.clearData();
        this.extensionApi.createSharedState(new HashMap(), null);
    }

    private void handleGetNearByPlaceEvent(@NonNull Event event, Map<String, Object> configData) {
        Log.trace((String)"Places", (String)CLASS_NAME, (String)"handleGetNearByPlaceEvent - Handling get near by place event.", (Object[])new Object[0]);
        PlacesConfiguration placesConfig = new PlacesConfiguration(configData);
        if (!placesConfig.isValid()) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handleGetNearByPlaceEvent - Ignoring the get nearby places event, Invalid Configuration", (Object[])new Object[0]);
            this.placesDispatcher.dispatchNearbyPlaces(new ArrayList<PlacesPOI>(), PlacesRequestError.CONFIGURATION_ERROR, event);
            return;
        }
        if (this.getMobilePrivacyStatus(configData) == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handleGetNearByPlaceEvent - Ignoring the get nearby places event, Privacy opted out.", (Object[])new Object[0]);
            this.placesDispatcher.dispatchNearbyPlaces(new ArrayList<PlacesPOI>(), PlacesRequestError.PRIVACY_OPTED_OUT, event);
            return;
        }
        this.queryService.getNearbyPlaces(event.getEventData(), placesConfig, response -> {
            if (!response.isSuccess) {
                Log.debug((String)"Places", (String)CLASS_NAME, (String)response.errorMessage, (Object[])new Object[0]);
                this.placesDispatcher.dispatchNearbyPlaces(new ArrayList<PlacesPOI>(), response.resultStatus, event);
                return;
            }
            this.state.setMembershiptTtl(placesConfig.getMembershipTtl());
            this.state.processNetworkResponse(response);
            this.extensionApi.createSharedState(this.state.getPlacesSharedState(), event);
            this.placesDispatcher.dispatchNearbyPlaces(response.getAllPOIs(), PlacesRequestError.OK, event);
            this.placesDispatcher.dispatchNearbyPlaces(response.getAllPOIs(), PlacesRequestError.OK, null);
        });
    }

    private void handleGeofenceEvent(@NonNull Event event, Map<String, Object> configData) {
        Log.trace((String)"Places", (String)CLASS_NAME, (String)"handleGeofenceEvent - Handling get geofence place event.", (Object[])new Object[0]);
        PlacesConfiguration placesConfig = new PlacesConfiguration(configData);
        if (this.getMobilePrivacyStatus(configData) == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"handleGeofenceEvent - Ignoring the geofence event, Privacy opted out.", (Object[])new Object[0]);
            return;
        }
        this.state.setMembershiptTtl(placesConfig.getMembershipTtl());
        PlacesRegion regionEvent = this.state.processRegionEvent(event);
        this.extensionApi.createSharedState(this.state.getPlacesSharedState(), event);
        this.placesDispatcher.dispatchRegionEvent(regionEvent);
        this.placesDispatcher.dispatchExperienceEventToEdge(regionEvent);
    }

    private Map<String, Object> retrieveConfigurationEventState(Event event) {
        return this.extensionApi.getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY).getValue();
    }

    private MobilePrivacyStatus getMobilePrivacyStatus(Map<String, Object> configData) {
        if (configData != null && configData.containsKey("global.privacy")) {
            String privacyString = DataReader.optString(configData, (String)"global.privacy", (String)"unknown");
            return MobilePrivacyStatus.fromString((String)privacyString);
        }
        return MobilePrivacyStatus.UNKNOWN;
    }
}

