/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.places.PlacesPOI;
import com.adobe.marketing.mobile.places.PlacesRegion;
import com.adobe.marketing.mobile.places.PlacesRequestError;
import com.adobe.marketing.mobile.places.PlacesUtil;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PlacesDispatcher {
    private static final String CLASS_NAME = "PlacesDispatcher";
    private final ExtensionApi extensionApi;

    PlacesDispatcher(ExtensionApi extensionApi) {
        this.extensionApi = extensionApi;
    }

    void dispatchNearbyPlaces(List<PlacesPOI> poiList, PlacesRequestError resultStatus, Event event) {
        HashMap<String, Object> responseEventData = new HashMap<String, Object>();
        responseEventData.put("nearbypois", PlacesUtil.convertPOIListToMap(poiList));
        responseEventData.put("status", resultStatus.getValue());
        if (event != null) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchNearbyPlaces - Dispatching nearby places response event for `getNearbyPointsOfInterest` API callback with %d POIs", (Object[])new Object[]{poiList.size()});
            Event responseEvent = new Event.Builder("responsegetnearbyplaces", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(responseEventData).inResponseToEvent(event).build();
            this.extensionApi.dispatch(responseEvent);
        } else {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchNearbyPlaces - Dispatching nearby places response event for all other listeners with %d POIs", (Object[])new Object[]{poiList.size()});
            Event responseEvent = new Event.Builder("responsegetnearbyplaces", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(responseEventData).build();
            this.extensionApi.dispatch(responseEvent);
        }
    }

    void dispatchRegionEvent(PlacesRegion region) {
        if (region == null) {
            return;
        }
        Map<String, Object> regionData = region.getRegionEventData();
        Event regionEvent = new Event.Builder("responseprocessregionevent", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(regionData).build();
        Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchRegionEvent - Dispatching Places Region Event for %s with eventType %s", (Object[])new Object[]{region.getName(), region.getPlaceEventType()});
        this.extensionApi.dispatch(regionEvent);
    }

    void dispatchUserWithinPOIs(List<PlacesPOI> poiList, Event event) {
        HashMap<String, List<Map<String, Object>>> responseEventData = new HashMap<String, List<Map<String, Object>>>();
        responseEventData.put("userwithinpois", PlacesUtil.convertPOIListToMap(poiList));
        if (event != null) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchUserWithinPOIs - Dispatching user within POIs event for `getCurrentPointsOfInterest` API callback with %d POIs", (Object[])new Object[]{poiList.size()});
            Event responseEvent = new Event.Builder("responsegetuserwithinplaces", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(responseEventData).inResponseToEvent(event).build();
            this.extensionApi.dispatch(responseEvent);
        } else {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchUserWithinPOIs - Dispatching user within POIs event for other listeners with %d POIs", (Object[])new Object[]{poiList.size()});
            Event responseEvent = new Event.Builder("responsegetuserwithinplaces", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(responseEventData).build();
            this.extensionApi.dispatch(responseEvent);
        }
    }

    void dispatchLastKnownLocation(double latitude, double longitude, Event event) {
        HashMap<String, Double> responseEventData = new HashMap<String, Double>();
        responseEventData.put("lastknownlatitude", latitude);
        responseEventData.put("lastknownlongitude", longitude);
        if (event != null) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchLastKnownLocation - Dispatching last known location event for `getLastKnownLocation` API callback with latitude: %s and longitude: %s", (Object[])new Object[]{latitude, longitude});
            Event responseEvent = new Event.Builder("responsegetlastknownlocation", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(responseEventData).inResponseToEvent(event).build();
            this.extensionApi.dispatch(responseEvent);
        } else {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"dispatchLastKnownLocation - Dispatching last known location event for other listeners with latitude: %s and longitude: %s", (Object[])new Object[]{latitude, longitude});
            Event responseEvent = new Event.Builder("responsegetlastknownlocation", "com.adobe.eventType.places", "com.adobe.eventSource.responseContent").setEventData(responseEventData).build();
            this.extensionApi.dispatch(responseEvent);
        }
    }

    void dispatchExperienceEventToEdge(@NonNull PlacesRegion regionEvent) {
        final String experienceEventType = regionEvent.getExperienceEventType();
        if (StringUtils.isNullOrEmpty((String)experienceEventType)) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Invalid region type : %s, Ignoring to send places experience edge event.", (Object[])new Object[]{regionEvent.getPlaceEventType()});
            return;
        }
        final PlacesPOI poi = regionEvent.getPoi();
        final HashMap<String, Object> poiInteraction = new HashMap<String, Object>(){
            {
                this.put("poiDetail", PlacesDispatcher.this.createXDMPOIDetail(poi));
            }
        };
        final HashMap<String, Object> xdmMap = new HashMap<String, Object>(){
            {
                this.put("eventType", experienceEventType);
                this.put("placeContext", new HashMap<String, Object>(){
                    {
                        this.put("POIinteraction", poiInteraction);
                    }
                });
            }
        };
        HashMap<String, Object> xdmEventData = new HashMap<String, Object>(){
            {
                this.put("xdm", xdmMap);
            }
        };
        String[] mask = new String[]{"xdm.eventType", "xdm.placeContext.POIinteraction.poiDetail.poiID"};
        Event experienceEvent = new Event.Builder("Location Tracking Event", "com.adobe.eventType.edge", "com.adobe.eventSource.requestContent", mask).setEventData((Map)xdmEventData).build();
        this.extensionApi.dispatch(experienceEvent);
    }

    private Map<String, Object> createXDMPOIDetail(final PlacesPOI poi) {
        return new HashMap<String, Object>(){
            {
                this.put("poiID", poi.getIdentifier());
                this.put("name", poi.getName());
                this.put("metadata", PlacesDispatcher.this.createPOIMetadata(poi));
            }
        };
    }

    private Map<String, Object> createPOIMetadata(PlacesPOI poi) {
        final ArrayList<5> metadataList = new ArrayList<5>();
        for (final Map.Entry<String, String> entry : poi.getMetadata().entrySet()) {
            HashMap<String, Object> metadataMap = new HashMap<String, Object>(){
                {
                    this.put("key", entry.getKey());
                    this.put("value", entry.getValue());
                }
            };
            metadataList.add(metadataMap);
        }
        return new HashMap<String, Object>(){
            {
                this.put("list", metadataList);
            }
        };
    }
}

