/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import java.util.HashMap;
import java.util.Map;

public enum PlacesAuthorizationStatus {
    DENIED("denied"),
    ALWAYS("always"),
    UNKNOWN("unknown"),
    RESTRICTED("restricted"),
    WHEN_IN_USE("wheninuse");

    private final String authStatus;
    static String DEFAULT_VALUE;
    private static final Map<String, PlacesAuthorizationStatus> lookup;

    private PlacesAuthorizationStatus(String authStatus) {
        this.authStatus = authStatus;
    }

    public String stringValue() {
        return this.authStatus;
    }

    static PlacesAuthorizationStatus get(String statusString) {
        return lookup.get(statusString);
    }

    static boolean isValidStatus(String statusString) {
        return lookup.containsKey(statusString);
    }

    static {
        DEFAULT_VALUE = UNKNOWN.stringValue();
        lookup = new HashMap<String, PlacesAuthorizationStatus>();
        for (PlacesAuthorizationStatus env : PlacesAuthorizationStatus.values()) {
            lookup.put(env.stringValue(), env);
        }
    }
}

