/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.templates;

import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import com.adobe.marketing.mobile.notificationbuilder.internal.util.NotificationData;
import com.adobe.marketing.mobile.services.Log;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductRatingPushTemplate;", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "data", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;", "(Lcom/adobe/marketing/mobile/notificationbuilder/internal/util/NotificationData;)V", "SELF_TAG", "", "ratingActionList", "", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductRatingPushTemplate$RatingAction;", "getRatingActionList$notificationbuilder_phoneRelease", "()Ljava/util/List;", "ratingActionString", "getRatingActionString$notificationbuilder_phoneRelease", "()Ljava/lang/String;", "ratingSelected", "", "getRatingSelected$notificationbuilder_phoneRelease", "()I", "ratingSelectedIcon", "getRatingSelectedIcon$notificationbuilder_phoneRelease", "ratingUnselectedIcon", "getRatingUnselectedIcon$notificationbuilder_phoneRelease", "getRatingActionsFromString", "ratingActionJsonString", "RatingAction", "notificationbuilder_phoneRelease"})
public final class ProductRatingPushTemplate
extends AEPPushTemplate {
    @NotNull
    private final String SELF_TAG;
    @NotNull
    private final String ratingUnselectedIcon;
    @NotNull
    private final String ratingSelectedIcon;
    @NotNull
    private final String ratingActionString;
    @NotNull
    private final List<RatingAction> ratingActionList;
    private final int ratingSelected;

    public ProductRatingPushTemplate(@NotNull NotificationData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data, null);
        this.SELF_TAG = "ProductRatingPushTemplate";
        this.ratingUnselectedIcon = data.getRequiredString("adb_rate_unselected_icon");
        this.ratingSelectedIcon = data.getRequiredString("adb_rate_selected_icon");
        this.ratingActionString = data.getRequiredString("adb_rate_act");
        List<RatingAction> list = this.getRatingActionsFromString(this.ratingActionString);
        if (list == null) {
            throw new IllegalArgumentException("Required field \"adb_rate_act\" is invalid.");
        }
        this.ratingActionList = list;
        if (this.ratingActionList.size() < 3 || this.ratingActionList.size() > 5) {
            throw new IllegalArgumentException("\"adb_rate_act\" field must have 3 to 5 rating actions");
        }
        Integer n = data.getInteger("ratingSelected");
        this.ratingSelected = n != null ? n : -1;
    }

    @NotNull
    public final String getRatingUnselectedIcon$notificationbuilder_phoneRelease() {
        return this.ratingUnselectedIcon;
    }

    @NotNull
    public final String getRatingSelectedIcon$notificationbuilder_phoneRelease() {
        return this.ratingSelectedIcon;
    }

    @NotNull
    public final String getRatingActionString$notificationbuilder_phoneRelease() {
        return this.ratingActionString;
    }

    @NotNull
    public final List<RatingAction> getRatingActionList$notificationbuilder_phoneRelease() {
        return this.ratingActionList;
    }

    public final int getRatingSelected$notificationbuilder_phoneRelease() {
        return this.ratingSelected;
    }

    private final List<RatingAction> getRatingActionsFromString(String ratingActionJsonString) {
        CharSequence charSequence = ratingActionJsonString;
        if (charSequence == null || charSequence.length() == 0) {
            Log.debug((String)"PushTemplates", (String)this.SELF_TAG, (String)"Exception in converting rating uri json string to json array, Error : rating uris is null", (Object[])new Object[0]);
            return null;
        }
        List ratingActionList = new ArrayList();
        try {
            JSONArray jsonArray = new JSONArray(ratingActionJsonString);
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                RatingAction ratingAction;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonObject");
                if (RatingAction.Companion.from(jsonObject) == null) {
                    return null;
                }
                ratingActionList.add(ratingAction);
            }
        }
        catch (Exception e) {
            Log.debug((String)"PushTemplates", (String)this.SELF_TAG, (String)("Exception in converting rating uri json string to json array, Error : " + e.getLocalizedMessage()), (Object[])new Object[0]);
            return null;
        }
        return ratingActionList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductRatingPushTemplate$RatingAction;", "", "type", "Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "link", "", "(Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;Ljava/lang/String;)V", "getLink", "()Ljava/lang/String;", "getType", "()Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "Companion", "notificationbuilder_phoneRelease"})
    public static final class RatingAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final PushTemplateConstants.ActionType type;
        @Nullable
        private final String link;
        @NotNull
        private static final String SELF_TAG = "RatingAction";

        public RatingAction(@NotNull PushTemplateConstants.ActionType type, @Nullable String link) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.link = link;
        }

        @NotNull
        public final PushTemplateConstants.ActionType getType() {
            return this.type;
        }

        @Nullable
        public final String getLink() {
            return this.link;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductRatingPushTemplate$RatingAction$Companion;", "", "()V", "SELF_TAG", "", "from", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/ProductRatingPushTemplate$RatingAction;", "jsonObject", "Lorg/json/JSONObject;", "notificationbuilder_phoneRelease"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final RatingAction from(@NotNull JSONObject jsonObject) {
                RatingAction ratingAction;
                Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
                try {
                    String uri = null;
                    String string = jsonObject.getString("type");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(Pus\u2026stants.RatingAction.TYPE)");
                    PushTemplateConstants.ActionType type = PushTemplateConstants.ActionType.valueOf(string);
                    if (type == PushTemplateConstants.ActionType.WEBURL || type == PushTemplateConstants.ActionType.DEEPLINK) {
                        uri = jsonObject.getString("uri");
                    }
                    Log.trace((String)"PushTemplates", (String)RatingAction.SELF_TAG, (String)("Creating a rating action with uri (" + uri + "), and type (" + (Object)((Object)type) + ")."), (Object[])new Object[0]);
                    ratingAction = new RatingAction(type, uri);
                }
                catch (Exception e) {
                    Log.warning((String)"PushTemplates", (String)RatingAction.SELF_TAG, (String)("Exception in converting rating action json string to json object, Error : " + e.getLocalizedMessage() + '.'), (Object[])new Object[0]);
                    ratingAction = null;
                }
                return ratingAction;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

