/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationCompatBuilderExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.BasicPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/LegacyNotificationBuilder;", "", "()V", "SELF_TAG", "", "construct", "Landroidx/core/app/NotificationCompat$Builder;", "context", "Landroid/content/Context;", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/BasicPushTemplate;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "notificationbuilder_phoneRelease"})
public final class LegacyNotificationBuilder {
    @NotNull
    public static final LegacyNotificationBuilder INSTANCE = new LegacyNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "LegacyNotificationBuilder";

    private LegacyNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull BasicPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building a legacy style push notification.", (Object[])new Object[0]);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelId = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId).setTicker((CharSequence)pushTemplate.getTicker$notificationbuilder_phoneRelease()).setContentTitle((CharSequence)pushTemplate.getTitle$notificationbuilder_phoneRelease()).setContentText((CharSequence)pushTemplate.getBody$notificationbuilder_phoneRelease()).setNumber(pushTemplate.getBadgeCount$notificationbuilder_phoneRelease());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, channel\u2026(pushTemplate.badgeCount)");
        NotificationCompat.Builder builder2 = NotificationCompatBuilderExtensionsKt.setSmallIcon(NotificationCompatBuilderExtensionsKt.setLargeIcon(builder, pushTemplate.getImageUrl$notificationbuilder_phoneRelease(), pushTemplate.getTitle$notificationbuilder_phoneRelease(), pushTemplate.getExpandedBodyText$notificationbuilder_phoneRelease()), context, pushTemplate.getSmallIcon$notificationbuilder_phoneRelease(), pushTemplate.getSmallIconColor$notificationbuilder_phoneRelease()).setVisibility(pushTemplate.getVisibility$notificationbuilder_phoneRelease().getValue());
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder(context, channel\u2026emplate.visibility.value)");
        NotificationCompat.Builder builder3 = NotificationCompatBuilderExtensionsKt.setNotificationDeleteAction(NotificationCompatBuilderExtensionsKt.setNotificationClickAction(NotificationCompatBuilderExtensionsKt.setSound(NotificationCompatBuilderExtensionsKt.addActionButtons(builder2, context, trackerActivityClass, pushTemplate.getActionButtonsList$notificationbuilder_phoneRelease(), pushTemplate.getData().getBundle()), context, pushTemplate.getSound$notificationbuilder_phoneRelease()), context, trackerActivityClass, pushTemplate.getActionUri$notificationbuilder_phoneRelease(), pushTemplate.getActionType$notificationbuilder_phoneRelease(), pushTemplate.getData().getBundle()), context, trackerActivityClass);
        if (Build.VERSION.SDK_INT < 26) {
            builder3.setPriority(1).setVibrate(new long[0]);
        }
        return builder3;
    }
}

