/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.lifecycle.XDMLanguage;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleCloseTypeEnum;
import com.adobe.marketing.mobile.services.Log;
import java.util.HashMap;
import java.util.Map;

class XDMLifecycleApplication {
    private final String LOG_SOURCE = "XDMLifecycleApplication";
    private XDMLifecycleCloseTypeEnum closeType;
    private String id;
    private boolean isClose;
    private boolean isInstall;
    private boolean isLaunch;
    private boolean isUpgrade;
    private XDMLanguage language;
    private String name;
    private int sessionLength;
    private String version;

    XDMLifecycleApplication() {
    }

    Map<String, Object> serializeToXdm() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.id != null) {
            map.put("id", this.id);
        }
        if (this.name != null) {
            map.put("name", this.name);
        }
        if (this.version != null) {
            map.put("version", this.version);
        }
        if (this.isClose) {
            map.put("isClose", this.isClose);
        }
        if (this.isInstall) {
            map.put("isInstall", this.isInstall);
        }
        if (this.isLaunch) {
            map.put("isLaunch", this.isLaunch);
        }
        if (this.isUpgrade) {
            map.put("isUpgrade", this.isUpgrade);
        }
        if (this.closeType != null) {
            map.put("closeType", this.closeType.toString());
        }
        if (this.sessionLength > 0) {
            map.put("sessionLength", this.sessionLength);
        }
        if (this.language != null) {
            map.put("_dc", this.language.serializeToXdm());
        }
        return map;
    }

    XDMLifecycleCloseTypeEnum getCloseType() {
        return this.closeType;
    }

    void setCloseType(XDMLifecycleCloseTypeEnum newValue) {
        this.closeType = newValue;
    }

    String getId() {
        return this.id;
    }

    void setId(String newValue) {
        this.id = newValue;
    }

    boolean getIsClose() {
        return this.isClose;
    }

    void setIsClose(boolean newValue) {
        this.isClose = newValue;
    }

    boolean getIsInstall() {
        return this.isInstall;
    }

    void setIsInstall(boolean newValue) {
        this.isInstall = newValue;
    }

    boolean getIsLaunch() {
        return this.isLaunch;
    }

    void setIsLaunch(boolean newValue) {
        this.isLaunch = newValue;
    }

    boolean getIsUpgrade() {
        return this.isUpgrade;
    }

    void setIsUpgrade(boolean newValue) {
        this.isUpgrade = newValue;
    }

    String getLanguage() {
        return this.language != null ? this.language.getLanguage() : null;
    }

    void setLanguage(String newValue) {
        try {
            this.language = new XDMLanguage(newValue);
        }
        catch (IllegalArgumentException ex) {
            Log.warning((String)"Lifecycle", (String)"XDMLifecycleApplication", (String)"Language tag '%s' failed validation and will be dropped. Values for XDM field 'application._dc.language' must conform to BCP 47.", (Object[])new Object[]{newValue});
        }
    }

    String getName() {
        return this.name;
    }

    void setName(String newValue) {
        this.name = newValue;
    }

    int getSessionLength() {
        return this.sessionLength;
    }

    void setSessionLength(int newValue) {
        this.sessionLength = newValue;
    }

    String getVersion() {
        return this.version;
    }

    void setVersion(String newValue) {
        this.version = newValue;
    }
}

