/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import java.util.concurrent.TimeUnit;

class LifecycleV2DataStoreCache {
    private static final String SELF_LOG_TAG = "LifecycleV2DataStoreCache";
    private final NamedCollection dataStore;
    private final long closeTimestampMillis;
    private long lastClosePersistedValue;

    LifecycleV2DataStoreCache(NamedCollection dataStore) {
        this.dataStore = dataStore;
        if (this.dataStore == null) {
            Log.warning((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s DataStore was provided, the functionality is limited", (Object[])new Object[]{"Unexpected Empty Value"});
            this.closeTimestampMillis = 0L;
            return;
        }
        this.migrateTimestampsSecToMillis();
        long tempTs = this.dataStore.getLong("v2AppCloseTimestampMillis", 0L);
        this.closeTimestampMillis = tempTs > 0L ? tempTs + 2000L : tempTs;
    }

    void setLastKnownTimestamp(long timestampMillis) {
        if (this.dataStore != null && timestampMillis - this.lastClosePersistedValue >= 2000L) {
            this.dataStore.setLong("v2AppCloseTimestampMillis", timestampMillis);
            this.lastClosePersistedValue = timestampMillis;
        }
    }

    long getCloseTimestampMillis() {
        return this.closeTimestampMillis;
    }

    void setAppStartTimestamp(long timestampMillis) {
        if (this.dataStore != null) {
            this.dataStore.setLong("v2AppStartTimestampMillis", timestampMillis);
        }
    }

    long getAppStartTimestampMillis() {
        return this.dataStore != null ? this.dataStore.getLong("v2AppStartTimestampMillis", 0L) : 0L;
    }

    void setAppPauseTimestamp(long timestampMillis) {
        if (this.dataStore != null) {
            this.dataStore.setLong("v2AppPauseTimestampMillis", timestampMillis);
        }
    }

    long getAppPauseTimestampMillis() {
        return this.dataStore != null ? this.dataStore.getLong("v2AppPauseTimestampMillis", 0L) : 0L;
    }

    private void migrateTimestampsSecToMillis() {
        this.migrateDataStoreKey("v2AppStartTimestamp", "v2AppStartTimestampMillis");
        this.migrateDataStoreKey("v2AppPauseTimestamp", "v2AppPauseTimestampMillis");
        this.migrateDataStoreKey("v2AppCloseTimestamp", "v2AppCloseTimestampMillis");
    }

    private void migrateDataStoreKey(String keySeconds, String keyMilliseconds) {
        if (this.dataStore == null) {
            return;
        }
        if (this.dataStore.contains(keySeconds)) {
            long value = this.dataStore.getLong(keySeconds, 0L);
            if (value > 0L) {
                this.dataStore.setLong(keyMilliseconds, TimeUnit.SECONDS.toMillis(value));
                Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Migrated persisted '%s' to '%s'.", (Object[])new Object[]{keySeconds, keyMilliseconds});
            }
            this.dataStore.remove(keySeconds);
        }
    }
}

