/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.services.Log;
import java.util.Timer;
import java.util.TimerTask;

class LifecycleTimerState {
    private static final String SELF_LOG_TAG = "LifecycleTimerState";
    private boolean isTimerRunning = false;
    private long timeout = 0L;
    private TimerTask timerTask;
    private Timer timer;
    private AdobeCallback<Boolean> callback;
    private final String debugName;
    private final Object timerMutex;

    LifecycleTimerState(String debugName) {
        this.debugName = debugName;
        this.timerMutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTimerRunning() {
        Object object = this.timerMutex;
        synchronized (object) {
            return this.timerTask != null && this.isTimerRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimer(long timeout, AdobeCallback<Boolean> callback) {
        Object object = this.timerMutex;
        synchronized (object) {
            if (this.timerTask != null) {
                Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Timer has already started.", (Object[])new Object[0]);
                return;
            }
            this.timeout = timeout;
            this.isTimerRunning = true;
            this.callback = callback;
            try {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        LifecycleTimerState.this.isTimerRunning = false;
                        if (LifecycleTimerState.this.callback != null) {
                            LifecycleTimerState.this.callback.call((Object)true);
                        }
                    }
                };
                this.timer = new Timer(this.debugName);
                this.timer.schedule(this.timerTask, timeout);
                Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s timer scheduled having timeout %s ms", (Object[])new Object[]{this.debugName, this.timeout});
            }
            catch (Exception e) {
                Log.warning((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Error creating %s timer, failed with error: (%s)", (Object[])new Object[]{this.debugName, e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = this.timerMutex;
        synchronized (object) {
            if (this.timer != null) {
                try {
                    this.timer.cancel();
                    Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s timer was canceled", (Object[])new Object[]{this.debugName});
                }
                catch (Exception e) {
                    Log.warning((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Error cancelling %s timer, failed with error: (%s)", (Object[])new Object[]{this.debugName, e});
                }
                this.timerTask = null;
            }
            this.isTimerRunning = false;
        }
    }
}

