/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.identity;

import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class NetworkConnectionUtil {
    static final String HTTP_HEADER_KEY_CONTENT_TYPE = "Content-Type";
    static final String HTTP_HEADER_CONTENT_TYPE_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    static ArrayList<Integer> recoverableNetworkErrorCodes = new ArrayList<Integer>(Arrays.asList(408, 504, 503));

    private NetworkConnectionUtil() {
    }

    static Map<String, String> getHeaders(boolean ssl) {
        return NetworkConnectionUtil.getHeaders(ssl, null);
    }

    static Map<String, String> getHeaders(boolean ssl, String contentType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!ssl) {
            headers.put("connection", "close");
        }
        headers.put(HTTP_HEADER_KEY_CONTENT_TYPE, StringUtils.isNullOrEmpty((String)contentType) ? HTTP_HEADER_CONTENT_TYPE_WWW_FORM_URLENCODED : contentType);
        return headers;
    }
}

