/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.EventCoder;
import com.adobe.marketing.mobile.services.DataEntity;
import org.json.JSONException;
import org.json.JSONObject;

final class IdentityHit {
    private static final String URL = "URL";
    private static final String EVENT = "EVENT";
    private final String url;
    private final Event event;

    IdentityHit(@NonNull String url, @NonNull Event event) {
        this.url = url;
        this.event = event;
    }

    String getUrl() {
        return this.url;
    }

    Event getEvent() {
        return this.event;
    }

    @Nullable
    DataEntity toDataEntity() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(URL, (Object)this.url);
            jsonObject.put(EVENT, (Object)EventCoder.encode((Event)this.event));
            return new DataEntity(jsonObject.toString());
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Nullable
    static IdentityHit fromDataEntity(DataEntity dataEntity) {
        if (dataEntity == null) {
            return null;
        }
        try {
            String json = dataEntity.getData();
            JSONObject jsonObject = new JSONObject(json);
            String url = jsonObject.getString(URL);
            Event event = EventCoder.decode((String)jsonObject.getString(EVENT));
            return new IdentityHit(url, event);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

