/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.campaign.CampaignHit;
import com.adobe.marketing.mobile.internal.util.StringEncoder;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.caching.CacheResult;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.MapUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

class Utils {
    private Utils() {
    }

    static CampaignHit campaignHitFromDataEntity(DataEntity dataEntity) {
        try {
            JSONObject jsonData = new JSONObject(dataEntity.getData());
            return new CampaignHit(jsonData.getString("url"), jsonData.getString("payload"), jsonData.getInt("timeout"));
        }
        catch (JSONException jsonException) {
            Log.warning((String)"Campaign", (String)"campaignHitFromDataEntity", (String)"JSON exception occurred converting data entity to campaign hit: %s", (Object[])new Object[]{jsonException.getMessage()});
            return null;
        }
    }

    static void clearCachedAssetsNotInList(File cacheAsset, List<String> assetsToRetain) {
        File[] filesList = cacheAsset.listFiles();
        if (cacheAsset.isDirectory() && filesList != null) {
            for (File child : filesList) {
                Utils.clearCachedAssetsNotInList(child, assetsToRetain);
            }
        } else {
            for (String asset : assetsToRetain) {
                if (cacheAsset.getName().equals(StringEncoder.sha2hash((String)asset)) || !cacheAsset.exists()) continue;
                cacheAsset.delete();
            }
        }
    }

    static void cleanDirectory(File file) {
        File[] filesList = file.listFiles();
        if (file.isDirectory() && filesList != null) {
            for (File child : filesList) {
                Utils.cleanDirectory(child);
            }
        }
        file.delete();
    }

    static HashMap<String, String> extractMetadataFromResponse(HttpConnecting response) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        String lastModifiedProp = response.getResponsePropertyValue("Last-Modified");
        Date lastModifiedDate = TimeUtils.parseRFC2822Date((String)lastModifiedProp, (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);
        String lastModifiedMetadata = lastModifiedDate == null ? String.valueOf(new Date(0L).getTime()) : String.valueOf(lastModifiedDate.getTime());
        metadata.put("Last-Modified", lastModifiedMetadata);
        String eTagProp = response.getResponsePropertyValue("Etag");
        metadata.put("Etag", eTagProp == null ? "" : eTagProp);
        return metadata;
    }

    static Map<String, String> extractHeadersFromCache(CacheResult cacheResult) {
        long lastModifiedEpoch;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (cacheResult == null) {
            return headers;
        }
        Map metadata = cacheResult.getMetadata();
        String eTag = metadata == null ? "" : (String)metadata.get("Etag");
        headers.put("If-None-Match", eTag != null ? eTag : "");
        String lastModified = metadata == null ? null : (String)metadata.get("Last-Modified");
        try {
            lastModifiedEpoch = lastModified != null ? Long.parseLong(lastModified) : 0L;
        }
        catch (NumberFormatException e) {
            lastModifiedEpoch = 0L;
        }
        String ifModifiedSince = TimeUtils.getRFC2822Date((long)lastModifiedEpoch, (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);
        headers.put("If-Modified-Since", ifModifiedSince);
        return headers;
    }

    static Map<String, String> extractQueryParameters(String queryString) {
        String[] paramArray;
        if (StringUtils.isNullOrEmpty((String)queryString)) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String currentParam : paramArray = queryString.split("&")) {
            String[] currentParamArray;
            if (StringUtils.isNullOrEmpty((String)currentParam) || (currentParamArray = currentParam.split("=", 2)).length != 2 || currentParamArray[0].isEmpty() || currentParamArray[1].isEmpty()) continue;
            String key = currentParamArray[0];
            String value = currentParamArray[1];
            parameters.put(key, value);
        }
        return parameters;
    }

    static boolean isInAppMessageEvent(Event event) {
        Map consequenceMap = DataReader.optTypedMap(Object.class, (Map)event.getEventData(), (String)"triggeredconsequence", null);
        if (MapUtils.isNullOrEmpty((Map)consequenceMap)) {
            return false;
        }
        return "iam".equals(consequenceMap.get("type"));
    }
}

