/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.adobe.marketing.mobile.LocalNotificationHandler;
import com.adobe.marketing.mobile.campaign.NotificationSetting;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.MapUtils;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

class LocalNotificationService {
    private static final String LOG_TAG = "Campaign";
    private static final String SELF_TAG = "LocalNotificationService";
    private static final String NOTIFICATION_CONTENT_KEY = "NOTIFICATION_CONTENT";
    private static final String NOTIFICATION_USER_INFO_KEY = "NOTIFICATION_USER_INFO";
    private static final String NOTIFICATION_IDENTIFIER_KEY = "NOTIFICATION_IDENTIFIER";
    private static final String NOTIFICATION_DEEPLINK_KEY = "NOTIFICATION_DEEPLINK";
    private static final String NOTIFICATION_SOUND_KEY = "NOTIFICATION_SOUND";
    private static final String NOTIFICATION_SENDER_CODE_KEY = "NOTIFICATION_SENDER_CODE";
    private static final int NOTIFICATION_SENDER_CODE = 750183;
    private static final String NOTIFICATION_REQUEST_CODE_KEY = "NOTIFICATION_REQUEST_CODE";
    private static final String NOTIFICATION_TITLE = "NOTIFICATION_TITLE";

    LocalNotificationService() {
    }

    static void showLocalNotification(Context appContext, NotificationSetting notificationSetting) {
        HashMap<String, Object> userInfo;
        if (appContext == null) {
            Log.warning((String)LOG_TAG, (String)SELF_TAG, (String)"Application context is null, unable to show local notification", (Object[])new Object[0]);
            return;
        }
        int requestCode = new SecureRandom().nextInt();
        Calendar calendar = Calendar.getInstance();
        if (notificationSetting.getFireDate() > 0L) {
            int secondsUntilFireDate = (int)(notificationSetting.getFireDate() - calendar.getTimeInMillis() / 1000L);
            if (secondsUntilFireDate > 0) {
                calendar.add(13, secondsUntilFireDate);
            }
        } else {
            calendar.add(13, notificationSetting.getDelaySeconds());
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setClass(appContext, LocalNotificationHandler.class);
        intent.putExtra(NOTIFICATION_SENDER_CODE_KEY, 750183);
        intent.putExtra(NOTIFICATION_IDENTIFIER_KEY, notificationSetting.getIdentifier());
        intent.putExtra(NOTIFICATION_REQUEST_CODE_KEY, requestCode);
        intent.putExtra(NOTIFICATION_DEEPLINK_KEY, notificationSetting.getDeeplink());
        intent.putExtra(NOTIFICATION_CONTENT_KEY, notificationSetting.getContent());
        HashMap<String, Object> hashMap = userInfo = !MapUtils.isNullOrEmpty(notificationSetting.getUserInfo()) ? new HashMap<String, Object>(notificationSetting.getUserInfo()) : null;
        if (!MapUtils.isNullOrEmpty((Map)userInfo)) {
            intent.putExtra(NOTIFICATION_USER_INFO_KEY, userInfo);
        }
        intent.putExtra(NOTIFICATION_SOUND_KEY, notificationSetting.getSound());
        intent.putExtra(NOTIFICATION_TITLE, notificationSetting.getTitle());
        try {
            int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
            PendingIntent sender = PendingIntent.getBroadcast((Context)appContext, (int)requestCode, (Intent)intent, (int)flags);
            AlarmManager alarmManager = (AlarmManager)appContext.getSystemService("alarm");
            if (alarmManager != null) {
                alarmManager.set(0, calendar.getTimeInMillis(), sender);
            }
        }
        catch (Exception e) {
            Log.warning((String)LOG_TAG, (String)LOG_TAG, (String)String.format("Unable to create PendingIntent object, error: %s", e.getLocalizedMessage()), (Object[])new Object[0]);
        }
    }
}

