/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Map;

final class CampaignState {
    private final String SELF_TAG = "CampaignState";
    private String campaignServer;
    private String campaignPkey;
    private String campaignMcias;
    private MobilePrivacyStatus privacyStatus;
    private String propertyId;
    private int timeout;
    private int campaignRegistrationDelayDays;
    private boolean campaignRegistrationPaused = false;
    private String experienceCloudId;

    CampaignState() {
    }

    String getCampaignServer() {
        return this.campaignServer;
    }

    String getCampaignPkey() {
        return this.campaignPkey;
    }

    String getCampaignMcias() {
        return this.campaignMcias;
    }

    int getCampaignTimeout() {
        return this.timeout;
    }

    MobilePrivacyStatus getMobilePrivacyStatus() {
        return this.privacyStatus;
    }

    String getPropertyId() {
        return this.propertyId;
    }

    int getCampaignRegistrationDelay() {
        return this.campaignRegistrationDelayDays;
    }

    boolean getCampaignRegistrationPaused() {
        return this.campaignRegistrationPaused;
    }

    String getExperienceCloudId() {
        return this.experienceCloudId;
    }

    void setState(SharedStateResult configSharedStateResult, SharedStateResult identitySharedStateResult) {
        if (configSharedStateResult != null && configSharedStateResult.getValue() != null) {
            this.setConfiguration(configSharedStateResult.getValue());
        }
        if (identitySharedStateResult != null && identitySharedStateResult.getValue() != null) {
            this.setIdentity(identitySharedStateResult.getValue());
        }
    }

    boolean canDownloadRulesWithCurrentState() {
        if (this.privacyStatus != MobilePrivacyStatus.OPT_IN) {
            Log.trace((String)"Campaign", (String)"CampaignState", (String)"canDownloadRulesWithCurrentState -  Cannot download rules, since privacy status is not opted in.", (Object[])new Object[0]);
            return false;
        }
        return !StringUtils.isNullOrEmpty((String)this.experienceCloudId) && !StringUtils.isNullOrEmpty((String)this.campaignServer) && !StringUtils.isNullOrEmpty((String)this.campaignMcias) && !StringUtils.isNullOrEmpty((String)this.propertyId);
    }

    boolean canRegisterWithCurrentState() {
        if (this.privacyStatus != MobilePrivacyStatus.OPT_IN) {
            Log.trace((String)"Campaign", (String)"CampaignState", (String)"canRegisterWithCurrentState -  Cannot register with Campaign, since privacy status is not opted in.", (Object[])new Object[0]);
            return false;
        }
        return !StringUtils.isNullOrEmpty((String)this.experienceCloudId) && !StringUtils.isNullOrEmpty((String)this.campaignServer) && !StringUtils.isNullOrEmpty((String)this.campaignPkey);
    }

    boolean canSendTrackInfoWithCurrentState() {
        if (this.privacyStatus != MobilePrivacyStatus.OPT_IN) {
            Log.trace((String)"Campaign", (String)"CampaignState", (String)"canSendTrackInfoWithCurrentState -  Cannot send message track request to Campaign, since privacy status is not opted in.", (Object[])new Object[0]);
            return false;
        }
        return !StringUtils.isNullOrEmpty((String)this.experienceCloudId) && !StringUtils.isNullOrEmpty((String)this.campaignServer);
    }

    private void setConfiguration(Map<String, Object> configState) {
        this.campaignServer = DataReader.optString(configState, (String)"campaign.server", (String)"");
        this.campaignPkey = DataReader.optString(configState, (String)"campaign.pkey", (String)"");
        this.campaignMcias = DataReader.optString(configState, (String)"campaign.mcias", (String)"");
        this.propertyId = DataReader.optString(configState, (String)"property.id", (String)"");
        this.privacyStatus = MobilePrivacyStatus.fromString((String)DataReader.optString(configState, (String)"global.privacy", (String)""));
        this.timeout = DataReader.optInt(configState, (String)"campaign.timeout", (int)5);
        this.campaignRegistrationDelayDays = DataReader.optInt(configState, (String)"campaign.registrationDelay", (int)7);
        this.campaignRegistrationPaused = DataReader.optBoolean(configState, (String)"campaign.registrationPaused", (boolean)false);
    }

    private void setIdentity(Map<String, Object> identityState) {
        this.experienceCloudId = DataReader.optString(identityState, (String)"mid", (String)"");
    }
}

