/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.campaign.CampaignConstants;
import com.adobe.marketing.mobile.campaign.CampaignHit;
import com.adobe.marketing.mobile.campaign.Utils;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HitProcessingResult;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class CampaignHitProcessor
implements HitProcessing {
    private static final int RETRY_INTERVAL = 30;
    private final String SELF_TAG = "CampaignHitProcessor";

    CampaignHitProcessor() {
    }

    public int retryInterval(@NonNull DataEntity dataEntity) {
        return 30;
    }

    public void processHit(@NonNull DataEntity dataEntity, @NonNull HitProcessingResult hitProcessingResult) {
        if (dataEntity == null || StringUtils.isNullOrEmpty((String)dataEntity.getData())) {
            Log.trace((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - Data entity contained an empty payload. Hit will not be processed.", (Object[])new Object[0]);
            hitProcessingResult.complete(true);
            return;
        }
        CampaignHit campaignHit = Utils.campaignHitFromDataEntity(dataEntity);
        if (campaignHit == null) {
            Log.trace((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - error occurred when creating a Campaign Hit from the given data entity", (Object[])new Object[0]);
            hitProcessingResult.complete(true);
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>(){
            {
                this.put("connection", "close");
                this.put("Content-Type", "application/json");
                this.put("Accept", "*/*");
            }
        };
        Networking networkService = ServiceProvider.getInstance().getNetworkService();
        if (networkService == null) {
            Log.warning((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit -The network service is unavailable, the hit will be retried later.", (Object[])new Object[0]);
            hitProcessingResult.complete(false);
            return;
        }
        NetworkRequest networkRequest = new NetworkRequest(campaignHit.url, campaignHit.getHttpCommand(), campaignHit.payload.getBytes(StandardCharsets.UTF_8), (Map)headers, campaignHit.timeout, campaignHit.timeout);
        CountDownLatch latch = new CountDownLatch(1);
        networkService.connectAsync(networkRequest, connection -> {
            if (connection == null || connection.getResponseCode() == -1) {
                Log.debug((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - Could not process a Campaign network request because the connection was null or response code was invalid. Retrying the request.", (Object[])new Object[0]);
                hitProcessingResult.complete(false);
            } else if (connection.getResponseCode() == 200) {
                Log.debug((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - Request was sent to (%s)", (Object[])new Object[]{campaignHit.url});
                this.updateTimestampInNamedCollection(System.currentTimeMillis());
                hitProcessingResult.complete(true);
                connection.close();
            } else if (!CampaignConstants.recoverableNetworkErrorCodes.contains(connection.getResponseCode())) {
                Log.debug((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - Unrecoverable network error while processing requests. Discarding request.", (Object[])new Object[0]);
                hitProcessingResult.complete(true);
                connection.close();
            } else {
                Log.debug((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - Recoverable network error while processing requests, will retry.", (Object[])new Object[0]);
                hitProcessingResult.complete(false);
            }
            latch.countDown();
        });
        try {
            latch.await(6L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.warning((String)"Campaign", (String)"CampaignHitProcessor", (String)"processHit - exception occurred while waiting for connectAsync latch: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    protected void updateTimestampInNamedCollection(long timestamp) {
        NamedCollection campaignNamedCollection = ServiceProvider.getInstance().getDataStoreService().getNamedCollection("CampaignCollection");
        if (campaignNamedCollection == null) {
            Log.debug((String)"Campaign", (String)"CampaignHitProcessor", (String)"updateTimestampInNamedCollection -  Campaign Data store is not available to update.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Campaign", (String)"CampaignHitProcessor", (String)"updateTimestampInNamedCollection -  Persisting timestamp (%d) in Campaign Data Store.", (Object[])new Object[]{timestamp});
        campaignNamedCollection.setLong("CampaignRegistrationTimestamp", timestamp);
    }
}

