/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Campaign;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.campaign.CampaignHit;
import com.adobe.marketing.mobile.campaign.CampaignHitProcessor;
import com.adobe.marketing.mobile.campaign.CampaignMessage;
import com.adobe.marketing.mobile.campaign.CampaignMessageRequiredFieldMissingException;
import com.adobe.marketing.mobile.campaign.CampaignRulesDownloader;
import com.adobe.marketing.mobile.campaign.CampaignState;
import com.adobe.marketing.mobile.campaign.FileUtils;
import com.adobe.marketing.mobile.campaign.Utils;
import com.adobe.marketing.mobile.launch.rulesengine.LaunchRulesEngine;
import com.adobe.marketing.mobile.launch.rulesengine.RuleConsequence;
import com.adobe.marketing.mobile.launch.rulesengine.download.RulesLoadResult;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.DataQueue;
import com.adobe.marketing.mobile.services.DataQueuing;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.PersistentHitQueue;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.caching.CacheResult;
import com.adobe.marketing.mobile.services.caching.CacheService;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.MapUtils;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class CampaignExtension
extends Extension {
    private static final String DATA_FOR_MESSAGE_REQUEST_EVENT_NAME = "DataForMessageRequest";
    private static final String INTERNAL_GENERIC_DATA_EVENT_NAME = "InternalGenericDataEvent";
    private static final String CLICKED_STRING_VALUE = "2";
    private static final String VIEWED_STRING_VALUE = "1";
    private final String SELF_TAG = "CampaignExtension";
    private final ExtensionApi extensionApi;
    private final PersistentHitQueue campaignPersistentHitQueue;
    private final LaunchRulesEngine campaignRulesEngine;
    private final CacheService cacheService;
    private final CampaignRulesDownloader campaignRulesDownloader;
    private final CampaignState campaignState;
    private final DataStoring dataStoreService;
    private String linkageFields;
    private boolean hasCachedRulesLoaded = false;
    private boolean hasToDownloadRules = true;

    public CampaignExtension(ExtensionApi extensionApi) {
        super(extensionApi);
        this.extensionApi = extensionApi;
        this.dataStoreService = ServiceProvider.getInstance().getDataStoreService();
        this.migrateFromACPCampaign(this.getNamedCollection());
        this.campaignRulesEngine = new LaunchRulesEngine("com.adobe.module.campaign.rulesengine", extensionApi);
        this.cacheService = ServiceProvider.getInstance().getCacheService();
        this.campaignRulesDownloader = new CampaignRulesDownloader(extensionApi, this.campaignRulesEngine, this.getNamedCollection(), this.cacheService);
        DataQueuing campaignDataQueueService = ServiceProvider.getInstance().getDataQueueService();
        DataQueue campaignDataQueue = campaignDataQueueService.getDataQueue("com.adobe.module.campaign");
        this.campaignPersistentHitQueue = new PersistentHitQueue(campaignDataQueue, (HitProcessing)new CampaignHitProcessor());
        this.campaignState = new CampaignState();
    }

    @VisibleForTesting
    CampaignExtension(ExtensionApi extensionApi, PersistentHitQueue persistentHitQueue, DataStoring dataStoreService, LaunchRulesEngine launchRulesEngine, CampaignState campaignState, CacheService cacheService, CampaignRulesDownloader campaignRulesDownloader) {
        super(extensionApi);
        this.extensionApi = extensionApi;
        this.dataStoreService = dataStoreService;
        this.campaignRulesEngine = launchRulesEngine;
        this.cacheService = cacheService;
        this.campaignRulesDownloader = campaignRulesDownloader;
        this.campaignPersistentHitQueue = persistentHitQueue;
        this.campaignState = campaignState;
    }

    protected String getName() {
        return "com.adobe.module.campaign";
    }

    protected String getFriendlyName() {
        return "Campaign";
    }

    protected String getVersion() {
        return Campaign.extensionVersion();
    }

    protected void onRegistered() {
        Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"Registered Campaign extension - version %s", (Object[])new Object[]{this.getVersion()});
        this.getApi().registerEventListener("com.adobe.eventType.campaign", "com.adobe.eventSource.requestIdentity", this::handleLinkageFieldsEvent);
        this.getApi().registerEventListener("com.adobe.eventType.campaign", "com.adobe.eventSource.requestReset", this::handleLinkageFieldsEvent);
        this.getApi().registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", this::processConfigurationResponse);
        this.getApi().registerEventListener("com.adobe.eventType.generic.data", "com.adobe.eventSource.os", this::processMessageInformation);
        this.getApi().registerEventListener("com.adobe.eventType.lifecycle", "com.adobe.eventSource.responseContent", this::processLifecycleUpdate);
        this.getApi().registerEventListener("com.adobe.eventType._wildcard_", "com.adobe.eventSource._wildcard_", this::handleWildcardEvents);
        this.getApi().registerEventListener("com.adobe.eventType.rulesEngine", "com.adobe.eventSource.responseContent", this::handleRuleEngineResponseEvents);
        FileUtils.deleteDatabaseFromCacheDir("ADBMobileCampaign.sqlite");
    }

    public boolean readyForEvent(@NonNull Event event) {
        Map eventData = event.getEventData();
        String stateOwner = DataReader.optString((Map)eventData, (String)"stateowner", (String)"");
        if (stateOwner.equals("com.adobe.module.identity")) {
            this.setCampaignState(event);
            if (this.hasToDownloadRules && this.campaignState.canDownloadRulesWithCurrentState()) {
                this.hasToDownloadRules = false;
                this.triggerRulesDownload();
            }
        }
        SharedStateResult configurationSharedState = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY);
        SharedStateResult identitySharedState = this.getApi().getSharedState("com.adobe.module.identity", event, false, SharedStateResolution.ANY);
        return configurationSharedState != null && configurationSharedState.getStatus() == SharedStateStatus.SET && identitySharedState != null && identitySharedState.getStatus() == SharedStateStatus.SET;
    }

    void handleWildcardEvents(Event event) {
        this.campaignRulesEngine.processEvent(event);
    }

    void handleRuleEngineResponseEvents(Event event) {
        if (!Utils.isInAppMessageEvent(event)) {
            return;
        }
        Map consequenceMap = DataReader.optTypedMap(Object.class, (Map)event.getEventData(), (String)"triggeredconsequence", null);
        if (MapUtils.isNullOrEmpty((Map)consequenceMap)) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"handleRulesResponseEvents - null or empty consequences found. Will not handle rules response event.", (Object[])new Object[0]);
            return;
        }
        String id = DataReader.optString((Map)consequenceMap, (String)"id", (String)"");
        String type = DataReader.optString((Map)consequenceMap, (String)"type", (String)"");
        Map detail = DataReader.optTypedMap(Object.class, (Map)consequenceMap, (String)"detail", null);
        if (MapUtils.isNullOrEmpty((Map)detail)) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"handleRulesResponseEvents - null or empty consequence details found. Will not handle rules response event.", (Object[])new Object[0]);
            return;
        }
        try {
            CampaignMessage triggeredMessage = CampaignMessage.createMessageObject(this, new RuleConsequence(id, type, detail));
            if (triggeredMessage == null) {
                Log.error((String)"Campaign", (String)"CampaignExtension", (String)"handleRulesResponseEvents -  Campaign message creation failed.", (Object[])new Object[0]);
                return;
            }
            triggeredMessage.showMessage();
        }
        catch (CampaignMessageRequiredFieldMissingException ex) {
            Log.error((String)"Campaign", (String)"CampaignExtension", (String)"handleRulesResponseEvents -  Error reading message definition: \n %s", (Object[])new Object[]{ex});
        }
    }

    void setCampaignState(Event event) {
        SharedStateResult configSharedStateResult = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.LAST_SET);
        SharedStateResult identitySharedStateResult = this.getApi().getSharedState("com.adobe.module.identity", event, false, SharedStateResolution.LAST_SET);
        this.campaignState.setState(configSharedStateResult, identitySharedStateResult);
    }

    void processConfigurationResponse(Event event) {
        CacheResult cacheRulesJson;
        CacheResult cachedRulesZip;
        if (event == null) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processConfigurationResponse - Unable to process event, event received is null.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (eventData == null || eventData.isEmpty()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processConfigurationResponse - Configuration response event is null", (Object[])new Object[0]);
            return;
        }
        this.setCampaignState(event);
        if (!this.hasCachedRulesLoaded && (cachedRulesZip = this.cacheService.get("campaign" + File.separator + "campaignRules", "campaign_rules.zip")) != null && (cacheRulesJson = this.cacheService.get("campaign" + File.separator + "campaignRules", "rules.json")) != null) {
            RulesLoadResult cachedRules = new RulesLoadResult(StreamUtils.readAsString((InputStream)cacheRulesJson.getData()), RulesLoadResult.Reason.SUCCESS);
            this.campaignRulesDownloader.registerRules(cachedRules);
            this.hasCachedRulesLoaded = true;
        }
        MobilePrivacyStatus privacyStatus = this.campaignState.getMobilePrivacyStatus();
        this.campaignPersistentHitQueue.handlePrivacyChange(privacyStatus);
        if (privacyStatus.equals((Object)MobilePrivacyStatus.OPT_OUT)) {
            this.processPrivacyOptOut();
            return;
        }
        if (this.hasToDownloadRules && this.campaignState.canDownloadRulesWithCurrentState()) {
            this.hasToDownloadRules = false;
            this.triggerRulesDownload();
        } else {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processConfigurationResponse -  Campaign extension is not configured to download campaign rules.", (Object[])new Object[0]);
            this.hasToDownloadRules = true;
        }
    }

    void processPrivacyOptOut() {
        Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"processPrivacyOptOut -  Clearing out cached data.", (Object[])new Object[0]);
        this.linkageFields = "";
        this.campaignRulesEngine.replaceRules(null);
        this.clearRulesCacheDirectory();
        this.clearCampaignNamedCollection();
    }

    void processMessageInformation(Event event) {
        if (!this.campaignState.canSendTrackInfoWithCurrentState()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processMessageInformation -  Campaign extension is not configured to send message track request.", (Object[])new Object[0]);
            return;
        }
        if (event == null) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processMessageInformation - Unable to process event, event received is null.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (eventData == null || eventData.isEmpty()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processMessageInformation -  Cannot send message track request, eventData is null.", (Object[])new Object[0]);
            return;
        }
        String broadlogId = DataReader.optString((Map)eventData, (String)"broadlogId", (String)"");
        String deliveryId = DataReader.optString((Map)eventData, (String)"deliveryId", (String)"");
        String action = DataReader.optString((Map)eventData, (String)"action", (String)"");
        if (StringUtils.isNullOrEmpty((String)broadlogId) || StringUtils.isNullOrEmpty((String)deliveryId) || StringUtils.isNullOrEmpty((String)action)) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processMessageInformation -  Cannot send message track request, %s %s %s null or empty.", (Object[])new Object[]{StringUtils.isNullOrEmpty((String)broadlogId) ? "broadlogId" : "", StringUtils.isNullOrEmpty((String)deliveryId) ? "deliveryId" : "", StringUtils.isNullOrEmpty((String)action) ? "action" : ""});
            return;
        }
        this.dispatchMessageEvent(action, deliveryId);
        String url = this.buildTrackingUrl(this.campaignState.getCampaignServer(), broadlogId, deliveryId, action, this.campaignState.getExperienceCloudId());
        this.processRequest(url, "", this.campaignState, event);
    }

    void dispatchMessageEvent(String action, String deliveryId) {
        String actionKey = null;
        if (CLICKED_STRING_VALUE.equals(action)) {
            actionKey = "a.message.clicked";
        } else if (VIEWED_STRING_VALUE.equals(action)) {
            actionKey = "a.message.viewed";
        }
        if (actionKey == null) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"dispatchMessageEvent -  Action received is other than viewed or clicked, so cannot dispatch Campaign response. ", (Object[])new Object[0]);
            return;
        }
        int hashMapCapacity = 2;
        HashMap<String, Object> contextData = new HashMap<String, Object>(2);
        int hexBase = 16;
        contextData.put("a.message.id", String.valueOf(Integer.parseInt(deliveryId, 16)));
        contextData.put(actionKey, String.valueOf(1));
        this.dispatchMessageInteraction(contextData);
    }

    void processLifecycleUpdate(Event event) {
        if (event == null) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processLifecycleUpdate - Unable to process event, event received is null.", (Object[])new Object[0]);
            return;
        }
        if (!this.campaignState.canRegisterWithCurrentState()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processLifecycleUpdate -  Campaign extension is not configured to send registration request.", (Object[])new Object[0]);
            return;
        }
        String url = this.buildRegistrationUrl(this.campaignState.getCampaignServer(), this.campaignState.getCampaignPkey(), this.campaignState.getExperienceCloudId());
        String payload = this.buildRegistrationPayload("gcm", this.campaignState.getExperienceCloudId(), new HashMap<String, String>());
        this.processRequest(url, payload, this.campaignState, event);
    }

    void triggerRulesDownload() {
        String rulesUrl = String.format("https://%s/%s/%s/%s/rules.zip", this.campaignState.getCampaignMcias(), this.campaignState.getCampaignServer(), this.campaignState.getPropertyId(), this.campaignState.getExperienceCloudId());
        this.campaignRulesDownloader.loadRulesFromUrl(rulesUrl, this.getLinkageFields());
    }

    void handleLinkageFieldsEvent(Event event) {
        if (event == null) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent - Unable to process event, event received is null.", (Object[])new Object[0]);
            return;
        }
        if (event.getSource().equals("com.adobe.eventSource.requestReset")) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent - Resetting linkage fields.", (Object[])new Object[0]);
            this.handleResetLinkageFields();
            return;
        }
        Map eventData = event.getEventData();
        if (eventData == null || eventData.isEmpty()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent - Ignoring event with null or empty EventData.", (Object[])new Object[0]);
            return;
        }
        Map linkageFields = DataReader.optStringMap((Map)eventData, (String)"linkagefields", null);
        if (linkageFields == null || linkageFields.isEmpty()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent - Unable to set linkage fields, received linkage fields are null or empty.", (Object[])new Object[0]);
            return;
        }
        String linkageFieldsJsonString = new JSONObject(linkageFields).toString();
        if (StringUtils.isNullOrEmpty((String)linkageFieldsJsonString)) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent -  Cannot set linkage fields, linkageFields JSON string is null or empty.", (Object[])new Object[0]);
            return;
        }
        this.linkageFields = Base64.encodeToString((byte[])linkageFieldsJsonString.getBytes(), (int)2);
        if (StringUtils.isNullOrEmpty((String)this.linkageFields)) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent -  Cannot set linkage fields, base64 encoded linkage fields string is empty.", (Object[])new Object[0]);
            return;
        }
        if (!this.campaignState.canDownloadRulesWithCurrentState()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"handleLinkageFieldsEvent -  Campaign extension is not configured to download campaign rules.", (Object[])new Object[0]);
            return;
        }
        this.clearRulesCacheDirectory();
        this.triggerRulesDownload();
    }

    void clearRulesCacheDirectory() {
        File rulesCacheDir = new File(ServiceProvider.getInstance().getDeviceInfoService().getApplicationCacheDir() + File.separator + "aepsdkcache" + File.separator + "campaign" + File.separator + "campaignRules");
        Utils.cleanDirectory(rulesCacheDir);
    }

    void dispatchMessageInteraction(Map<String, Object> messageData) {
        if (messageData == null || messageData.isEmpty()) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"dispatchMessageInteraction -  Cannot dispatch Campaign response event, message interaction data is null or empty.", (Object[])new Object[0]);
            return;
        }
        Event messageEvent = new Event.Builder(DATA_FOR_MESSAGE_REQUEST_EVENT_NAME, "com.adobe.eventType.campaign", "com.adobe.eventSource.responseContent").setEventData(messageData).build();
        this.extensionApi.dispatch(messageEvent);
    }

    void dispatchMessageInfo(String broadlogId, String deliveryId, String action) {
        HashMap<String, String> eventData = new HashMap<String, String>();
        eventData.put("broadlogId", broadlogId);
        eventData.put("deliveryId", deliveryId);
        eventData.put("action", action);
        Event messageEvent = new Event.Builder(INTERNAL_GENERIC_DATA_EVENT_NAME, "com.adobe.eventType.generic.data", "com.adobe.eventSource.os").setEventData(eventData).build();
        this.extensionApi.dispatch(messageEvent);
    }

    String getLinkageFields() {
        return this.linkageFields;
    }

    private void handleResetLinkageFields() {
        this.linkageFields = "";
        this.campaignRulesEngine.replaceRules(new ArrayList());
        this.clearRulesCacheDirectory();
        this.triggerRulesDownload();
    }

    private NamedCollection getNamedCollection() {
        return this.dataStoreService.getNamedCollection("CampaignCollection");
    }

    private void migrateFromACPCampaign(NamedCollection aepDatastore) {
        if (aepDatastore == null) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"migrateFromACPCampaign - Will not perform migration, provided datastore is null.", (Object[])new Object[0]);
            return;
        }
        SharedPreferences sharedPreferences = null;
        Context appContext = MobileCore.getApplication().getApplicationContext();
        if (appContext != null) {
            sharedPreferences = appContext.getSharedPreferences("CampaignDataStore", 0);
        }
        if (sharedPreferences == null) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"migrateFromACPCampaign - Will not perform migration, shared preferences are null.", (Object[])new Object[0]);
            return;
        }
        if (sharedPreferences.getAll().isEmpty()) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"migrateFromACPCampaign - Will not perform migration, existing shared preferences not found.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"migrateFromACPCampaign - Campaign preferences found, migrating existing shared preferences.", (Object[])new Object[0]);
        aepDatastore.setString("ExperienceCloudId", sharedPreferences.getString("ExperienceCloudId", ""));
        aepDatastore.setString("CampaignRemoteUrl", sharedPreferences.getString("CampaignRemoteUrl", ""));
        aepDatastore.setLong("CampaignRegistrationTimestamp", sharedPreferences.getLong("CampaignRegistrationTimestamp", -1L));
        File applicationBaseDir = ServiceProvider.getInstance().getDeviceInfoService().getApplicationBaseDir();
        File acpDatastore = new File(applicationBaseDir.getPath() + File.separator + "shared_prefs" + File.separator + "CampaignDataStore" + ".xml");
        if (acpDatastore.exists()) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"migrateFromACPCampaign - Deleting migrated shared preferences file (%s).", (Object[])new Object[]{acpDatastore.getName()});
            FileUtils.deleteFile(acpDatastore, false);
        }
    }

    private void updateEcidInNamedCollection(String ecid) {
        NamedCollection campaignNamedCollection = this.getNamedCollection();
        if (campaignNamedCollection == null) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"updateEcidInNamedCollection - Campaign Named Collection is null, cannot store ecid.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)ecid)) {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"updateEcidInNamedCollection -  Removing experience cloud id key in Campaign Named Collection.", (Object[])new Object[0]);
            campaignNamedCollection.remove("ExperienceCloudId");
        } else {
            Log.trace((String)"Campaign", (String)"CampaignExtension", (String)"updateEcidInNamedCollection -  Persisting experience cloud id (%s) in Campaign Named Collection.", (Object[])new Object[]{ecid});
            campaignNamedCollection.setString("ExperienceCloudId", ecid);
        }
    }

    private void processRequest(String url, String payload, CampaignState campaignState, Event event) {
        if (!StringUtils.isNullOrEmpty((String)payload) && !this.shouldSendRegistrationRequest(campaignState, event.getTimestamp())) {
            return;
        }
        CampaignHit campaignHit = new CampaignHit(url, payload, campaignState.getCampaignTimeout());
        DataEntity dataEntity = new DataEntity(campaignHit.toString());
        Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"processRequest - Campaign Request Queued with url (%s) and body (%s)", (Object[])new Object[]{url, payload});
        this.campaignPersistentHitQueue.queue(dataEntity);
    }

    private void clearCampaignNamedCollection() {
        NamedCollection campaignNamedCollection = this.getNamedCollection();
        if (campaignNamedCollection == null) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"clearCampaignNamedCollection -  Campaign Named Collection is not available to be cleared.", (Object[])new Object[0]);
            return;
        }
        campaignNamedCollection.removeAll();
    }

    private String buildTrackingUrl(String server, String broadlogId, String deliveryId, String action, String experienceCloudId) {
        return String.format("https://%s/r/?id=%s,%s,%s&mcId=%s", server, broadlogId, deliveryId, action, experienceCloudId);
    }

    private String buildRegistrationUrl(String server, String pkey, String experienceCloudId) {
        return String.format("https://%s/rest/head/mobileAppV5/%s/subscriptions/%s", server, pkey, experienceCloudId);
    }

    private String buildRegistrationPayload(String platform, String experienceCloudId, Map<String, String> data) {
        HashMap<String, String> profileData = new HashMap<String, String>(data);
        profileData.put("pushPlatform", platform);
        profileData.put("marketingCloudId", experienceCloudId);
        JSONObject bodyJSON = new JSONObject(profileData);
        if (bodyJSON == null) {
            return "";
        }
        return bodyJSON.toString();
    }

    private boolean shouldSendRegistrationRequest(CampaignState campaignState, long eventTimestamp) {
        boolean shouldPauseRegistration = campaignState.getCampaignRegistrationPaused();
        if (shouldPauseRegistration) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"shouldSendRegistrationRequest -  Registration requests are paused.", (Object[])new Object[0]);
            return false;
        }
        NamedCollection campaignNamedCollection = this.getNamedCollection();
        String retrievedEcid = campaignNamedCollection.getString("ExperienceCloudId", "");
        String currentEcid = campaignState.getExperienceCloudId();
        long retrievedTimestamp = campaignNamedCollection.getLong("CampaignRegistrationTimestamp", -1L);
        int registrationDelay = campaignState.getCampaignRegistrationDelay();
        long registrationDelayInMilliseconds = TimeUnit.DAYS.toMillis(registrationDelay);
        if (!retrievedEcid.equals(currentEcid)) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"shouldSendRegistrationRequest - The current ecid (%s) is new, sending the registration request.", (Object[])new Object[]{currentEcid});
            this.updateEcidInNamedCollection(currentEcid);
            return true;
        }
        if (eventTimestamp - retrievedTimestamp >= registrationDelayInMilliseconds) {
            Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"shouldSendRegistrationRequest -  Registration delay of (%d) days has elapsed. Sending the Campaign registration request.", (Object[])new Object[]{registrationDelay});
            return true;
        }
        Log.debug((String)"Campaign", (String)"CampaignExtension", (String)"shouldSendRegistrationRequest - The registration request will not be sent because the registration delay of (%d) days has not elapsed.", (Object[])new Object[]{registrationDelay});
        return false;
    }
}

