/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.audience;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.audience.AudienceConstants;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

class AudienceState {
    private static final String LOG_SOURCE = "AudienceState";
    private final NamedCollection localStorage;
    private String uuid = null;
    private Map<String, String> visitorProfile = null;
    private MobilePrivacyStatus privacyStatus = AudienceConstants.DEFAULT_PRIVACY_STATUS;
    private long lastResetTimestampMillis;

    AudienceState() {
        this(null);
    }

    @VisibleForTesting
    AudienceState(NamedCollection namedCollection) {
        DataStoring dataStoreService;
        this.localStorage = namedCollection == null ? ((dataStoreService = ServiceProvider.getInstance().getDataStoreService()) != null ? dataStoreService.getNamedCollection("AAMDataStore") : null) : namedCollection;
    }

    void setUuid(String uuid) {
        if (StringUtils.isNullOrEmpty((String)uuid) || this.privacyStatus != MobilePrivacyStatus.OPT_OUT) {
            this.uuid = uuid;
        }
        if (this.localStorage == null) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unable to update uuid in persistence - persistence collection could not be retrieved.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)uuid)) {
            this.localStorage.remove("AAMUserId");
        } else if (this.privacyStatus != MobilePrivacyStatus.OPT_OUT) {
            this.localStorage.setString("AAMUserId", uuid);
        }
    }

    void setVisitorProfile(Map<String, String> visitorProfile) {
        if (visitorProfile == null || visitorProfile.isEmpty() || this.privacyStatus != MobilePrivacyStatus.OPT_OUT) {
            this.visitorProfile = visitorProfile;
        }
        if (this.localStorage == null) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unable to update visitor profile in persistence - persistence collection could not be retrieved.", (Object[])new Object[0]);
            return;
        }
        if (visitorProfile == null || visitorProfile.isEmpty()) {
            this.localStorage.remove("AAMUserProfile");
        } else if (this.privacyStatus != MobilePrivacyStatus.OPT_OUT) {
            this.localStorage.setMap("AAMUserProfile", visitorProfile);
        }
    }

    void setMobilePrivacyStatus(MobilePrivacyStatus privacyStatus) {
        this.privacyStatus = privacyStatus;
        if (privacyStatus == MobilePrivacyStatus.OPT_OUT) {
            this.clearIdentifiers();
        }
    }

    String getUuid() {
        if (StringUtils.isNullOrEmpty((String)this.uuid)) {
            if (this.localStorage == null) {
                Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unable to retrieve uuid from persistence - persistence could not be accessed.", (Object[])new Object[0]);
                return this.uuid;
            }
            this.uuid = this.localStorage.getString("AAMUserId", this.uuid);
        }
        return this.uuid;
    }

    Map<String, String> getVisitorProfile() {
        if (this.visitorProfile == null || this.visitorProfile.isEmpty()) {
            if (this.localStorage == null) {
                Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unable to retrieve visitor profile from persistence - persistence could not be accessed.", (Object[])new Object[0]);
                return this.visitorProfile;
            }
            if (this.localStorage.contains("AAMUserProfile")) {
                this.visitorProfile = this.localStorage.getMap("AAMUserProfile");
            }
        }
        return this.visitorProfile;
    }

    MobilePrivacyStatus getMobilePrivacyStatus() {
        return this.privacyStatus;
    }

    void setLastResetTimestamp(long timestampMillis) {
        if (timestampMillis >= 0L) {
            this.lastResetTimestampMillis = timestampMillis;
        }
    }

    long getLastResetTimestampMillis() {
        return this.lastResetTimestampMillis;
    }

    Map<String, Object> getStateData() {
        Map<String, String> profile;
        HashMap<String, Object> stateData = new HashMap<String, Object>();
        if (this.getMobilePrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            return stateData;
        }
        String uuid = this.getUuid();
        if (!StringUtils.isNullOrEmpty((String)uuid)) {
            stateData.put("uuid", uuid);
        }
        if ((profile = this.getVisitorProfile()) != null) {
            stateData.put("aamprofile", profile);
        }
        return stateData;
    }

    void clearIdentifiers() {
        this.setUuid(null);
        this.setVisitorProfile(null);
    }
}

