/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.audience;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Audience;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResolver;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.audience.AudienceConstants;
import com.adobe.marketing.mobile.audience.AudienceDataEntity;
import com.adobe.marketing.mobile.audience.AudienceHitProcessor;
import com.adobe.marketing.mobile.audience.AudienceNetworkResponseHandler;
import com.adobe.marketing.mobile.audience.AudienceState;
import com.adobe.marketing.mobile.services.DataQueue;
import com.adobe.marketing.mobile.services.DataQueuing;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.PersistentHitQueue;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.MapUtils;
import com.adobe.marketing.mobile.util.SQLiteUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.URLBuilder;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AudienceExtension
extends Extension {
    private static final String LOG_SOURCE = "AudienceExtension";
    private final AudienceState internalState;
    private PersistentHitQueue hitQueue;
    private ConcurrentMap<String, SharedStateResolver> pendingSharedStates = new ConcurrentHashMap<String, SharedStateResolver>();
    @VisibleForTesting
    final AudienceNetworkResponseHandler networkResponseHandler;

    AudienceExtension(ExtensionApi extensionApi) {
        this(extensionApi, null, null);
    }

    @VisibleForTesting
    AudienceExtension(ExtensionApi extensionApi, AudienceState audienceState, PersistentHitQueue hitQueue) {
        super(extensionApi);
        this.internalState = audienceState != null ? audienceState : new AudienceState();
        this.networkResponseHandler = new NetworkResponseHandler(this.internalState);
        if (hitQueue == null) {
            DataQueue dataQueue;
            DataQueuing dataQueueService = ServiceProvider.getInstance().getDataQueueService();
            if (dataQueueService != null && (dataQueue = dataQueueService.getDataQueue(this.getName())) != null) {
                this.hitQueue = new PersistentHitQueue(dataQueue, (HitProcessing)new AudienceHitProcessor(this.networkResponseHandler));
            }
        } else {
            this.hitQueue = hitQueue;
        }
    }

    @NonNull
    protected String getName() {
        return "com.adobe.module.audience";
    }

    @NonNull
    protected String getFriendlyName() {
        return "Audience";
    }

    @NonNull
    protected String getVersion() {
        return Audience.extensionVersion();
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.analytics", "com.adobe.eventSource.responseContent", this::handleAnalyticsResponse);
        this.getApi().registerEventListener("com.adobe.eventType.audienceManager", "com.adobe.eventSource.requestContent", this::handleAudienceRequestContent);
        this.getApi().registerEventListener("com.adobe.eventType.audienceManager", "com.adobe.eventSource.requestIdentity", this::handleAudienceRequestIdentity);
        this.getApi().registerEventListener("com.adobe.eventType.audienceManager", "com.adobe.eventSource.requestReset", this::handleResetIdentities);
        this.getApi().registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", this::handleConfigurationResponse);
        this.getApi().registerEventListener("com.adobe.eventType.generic.identity", "com.adobe.eventSource.requestReset", this::handleResetIdentities);
        this.getApi().registerEventListener("com.adobe.eventType.lifecycle", "com.adobe.eventSource.responseContent", this::handleLifecycleResponse);
        Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Setting bootup Audience shared state.", (Object[])new Object[0]);
        this.shareStateForEvent(null);
        this.deleteDeprecatedV1HitDatabase();
    }

    public boolean readyForEvent(@NonNull Event event) {
        SharedStateResult configSharedState = this.getSharedStateForExtension("com.adobe.module.configuration", event);
        if (event.getType().equals("com.adobe.eventType.audienceManager") && event.getSource().equals("com.adobe.eventSource.requestContent") || event.getType().equals("com.adobe.eventType.lifecycle") && event.getSource().equals("com.adobe.eventSource.responseContent")) {
            SharedStateResult identitySharedState = this.getSharedStateForExtension("com.adobe.module.identity", event);
            return configSharedState.getStatus() != SharedStateStatus.PENDING && identitySharedState.getStatus() != SharedStateStatus.PENDING;
        }
        return configSharedState.getStatus() == SharedStateStatus.SET;
    }

    @VisibleForTesting
    void handleConfigurationResponse(@NonNull Event event) {
        Map eventData = event.getEventData();
        MobilePrivacyStatus privacyStatus = MobilePrivacyStatus.fromString((String)DataReader.optString((Map)eventData, (String)"global.privacy", (String)""));
        if (privacyStatus.equals((Object)MobilePrivacyStatus.OPT_OUT)) {
            this.sendOptOutHit(eventData);
        }
        this.internalState.setMobilePrivacyStatus(privacyStatus);
        if (this.hitQueue != null) {
            this.hitQueue.handlePrivacyChange(privacyStatus);
        }
        this.shareStateForEvent(event);
    }

    @VisibleForTesting
    void handleResetIdentities(@NonNull Event event) {
        Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Resetting stored Audience Manager identities and visitor profile.", (Object[])new Object[0]);
        if ("com.adobe.eventType.generic.identity".equals(event.getType()) && this.hitQueue != null) {
            this.hitQueue.clear();
        }
        this.internalState.clearIdentifiers();
        this.internalState.setLastResetTimestamp(event.getTimestamp());
        this.shareStateForEvent(event);
    }

    @VisibleForTesting
    void handleAnalyticsResponse(@NonNull Event event) {
        if (!this.serverSideForwardingToAam(event)) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Not processing Analytics response event - AAM forwarding is disabled in configuration.", (Object[])new Object[0]);
            return;
        }
        String response = DataReader.optString((Map)event.getEventData(), (String)"analyticsserverresponse", (String)"");
        if (StringUtils.isNullOrEmpty((String)response)) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Ignoring Analytics response event - the response is null or empty.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"AAM forwarding is enabled, handling Analytics response: %s", (Object[])new Object[]{response});
        this.processResponse(response, event);
        this.shareStateForEvent(event);
    }

    @VisibleForTesting
    void handleAudienceRequestContent(@NonNull Event event) {
        this.submitSignal(event);
    }

    @VisibleForTesting
    void handleAudienceRequestIdentity(@NonNull Event event) {
        HashMap<String, Map<String, String>> responseEventData = new HashMap<String, Map<String, String>>();
        responseEventData.put("aamprofile", this.internalState.getVisitorProfile());
        Event responseEvent = new Event.Builder("Audience Manager Identities", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.responseIdentity").setEventData(responseEventData).inResponseToEvent(event).build();
        this.getApi().dispatch(responseEvent);
    }

    @VisibleForTesting
    void handleLifecycleResponse(@NonNull Event event) {
        if (this.serverSideForwardingToAam(event)) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Ignoring Lifecycle response event because AAM forwarding is enabled in configuration.", (Object[])new Object[0]);
            return;
        }
        Map eventData = event.getEventData();
        if (MapUtils.isNullOrEmpty((Map)eventData)) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Ignoring Lifecycle response event with absent or empty event data.", (Object[])new Object[0]);
            return;
        }
        this.submitSignal(event);
    }

    private Map<String, String> processResponse(String response, Event event) {
        JSONObject jsonResponse;
        if (StringUtils.isNullOrEmpty((String)response)) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Unable to process Audience Manager server response - response was null or empty.", (Object[])new Object[0]);
            return null;
        }
        SharedStateResult configSharedState = this.getSharedStateForExtension("com.adobe.module.configuration", event);
        if (configSharedState == null || configSharedState.getStatus() == SharedStateStatus.PENDING) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Unable to process Audience Manager server response - configuration shared state is pending.", (Object[])new Object[0]);
            return null;
        }
        int timeout = DataReader.optInt((Map)configSharedState.getValue(), (String)"audience.timeout", (int)2);
        try {
            jsonResponse = new JSONObject(response);
        }
        catch (JSONException ex) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Failed to parse response from Audience Manager server - %s", (Object[])new Object[]{ex.getLocalizedMessage()});
            return null;
        }
        this.processDestsArray(jsonResponse, timeout);
        try {
            this.internalState.setUuid(jsonResponse.getString("uuid"));
        }
        catch (JSONException ex) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Unable to retrieve UUID from Audience Manager response - %s", (Object[])new Object[]{ex.getLocalizedMessage()});
        }
        Map<String, String> returnedMap = this.processStuffArray(jsonResponse);
        if (returnedMap.size() > 0) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Response received from server: %s", (Object[])new Object[]{returnedMap});
        } else {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Response received from server was empty.", (Object[])new Object[0]);
        }
        this.internalState.setVisitorProfile(returnedMap);
        return returnedMap;
    }

    private SharedStateResult getSharedStateForExtension(String extensionName, Event event) {
        return this.getApi().getSharedState(extensionName, event, false, SharedStateResolution.LAST_SET);
    }

    private void shareStateForEvent(Event event) {
        this.getApi().createSharedState(this.internalState.getStateData(), event);
    }

    private void resolveSharedStateForEvent(Event event) {
        if (event == null) {
            return;
        }
        SharedStateResolver resolver = (SharedStateResolver)this.pendingSharedStates.get(event.getUniqueIdentifier());
        if (resolver == null) {
            return;
        }
        resolver.resolve(this.internalState.getStateData());
        this.pendingSharedStates.remove(event.getUniqueIdentifier());
    }

    private boolean serverSideForwardingToAam(Event event) {
        SharedStateResult configSharedState = this.getSharedStateForExtension("com.adobe.module.configuration", event);
        if (configSharedState == null || configSharedState.getStatus() != SharedStateStatus.SET) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Attempted to retrieve AAM configuration for server-side forwarding but shared state was not set.", (Object[])new Object[0]);
            return false;
        }
        return DataReader.optBoolean((Map)configSharedState.getValue(), (String)"analytics.aamForwardingEnabled", (boolean)false);
    }

    private void submitSignal(Event event) {
        HashMap<String, String> signalData;
        SharedStateResult configSharedState = this.getSharedStateForExtension("com.adobe.module.configuration", event);
        Map configData = configSharedState.getValue();
        String server = DataReader.optString((Map)configData, (String)"audience.server", null);
        int timeout = DataReader.optInt((Map)configData, (String)"audience.timeout", (int)2);
        MobilePrivacyStatus privacyStatus = MobilePrivacyStatus.fromString((String)DataReader.optString((Map)configData, (String)"global.privacy", (String)AudienceConstants.DEFAULT_PRIVACY_STATUS.getValue()));
        if (StringUtils.isNullOrEmpty((String)server) || privacyStatus == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Dropping Audience hit, AAM server configuration is unavailable or privacy status is opted-out. Dispatching an empty profile.", (Object[])new Object[0]);
            this.dispatchAudienceResponseContent(null, event);
            return;
        }
        if (event.getTimestamp() < this.internalState.getLastResetTimestampMillis()) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Dropping Audience hit, resetIdentities API was called after this request.", (Object[])new Object[0]);
            this.dispatchAudienceResponseContent(null, event);
            return;
        }
        if (privacyStatus == MobilePrivacyStatus.UNKNOWN) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Dispatching an empty profile - privacy status is unknown.", (Object[])new Object[0]);
            this.dispatchAudienceResponseContent(null, event);
        }
        if (this.hitQueue == null) {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"Unable to queue AAM request as Audience Database not initialized.", (Object[])new Object[0]);
            return;
        }
        SharedStateResolver ssResolver = this.getApi().createPendingSharedState(event);
        if (ssResolver != null) {
            this.pendingSharedStates.put(event.getUniqueIdentifier(), ssResolver);
        }
        if ("com.adobe.eventType.lifecycle".equals(event.getType())) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Lifecycle response event found, processing context data.", (Object[])new Object[0]);
            Map tempLifecycleData = DataReader.optStringMap((Map)event.getEventData(), (String)"lifecyclecontextdata", null);
            signalData = this.getLifecycleDataForAudience(tempLifecycleData);
        } else {
            Map customerEventData = event.getEventData();
            signalData = customerEventData == null ? null : DataReader.optStringMap((Map)customerEventData, (String)"aamtraits", null);
        }
        String requestUrl = this.buildSignalUrl(server, (Map<String, String>)signalData, event);
        Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"Queuing hit for url: %s", (Object[])new Object[]{requestUrl});
        if (requestUrl != null) {
            AudienceDataEntity entity = new AudienceDataEntity(event, requestUrl, timeout);
            this.hitQueue.queue(entity.toDataEntity());
        } else {
            Log.warning((String)"Audience", (String)LOG_SOURCE, (String)"submitSignal - Dropping request with event id '%s' because URL is invalid.", (Object[])new Object[]{event.getUniqueIdentifier()});
        }
    }

    private void dispatchAudienceResponseContent(final Map<String, String> profile, Event event) {
        HashMap<String, Object> eventData = new HashMap<String, Object>(){
            {
                this.put("aamprofile", profile);
            }
        };
        Event responseEvent = event != null ? new Event.Builder("Audience Manager Profile", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.responseContent").setEventData((Map)eventData).inResponseToEvent(event).build() : new Event.Builder("Audience Manager Profile", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.responseContent").setEventData((Map)eventData).build();
        this.getApi().dispatch(responseEvent);
    }

    private void sendOptOutHit(Map<String, Object> configuration) {
        boolean canSendOptOutHit;
        String aamServer = DataReader.optString(configuration, (String)"audience.server", null);
        String uuid = this.internalState.getUuid();
        boolean bl = canSendOptOutHit = !StringUtils.isNullOrEmpty((String)aamServer) && !StringUtils.isNullOrEmpty((String)uuid);
        if (canSendOptOutHit) {
            String optOutUrl = this.getOptOutUrlPrefix(aamServer) + this.getOptOutUrlSuffix(uuid);
            int timeout = DataReader.optInt(configuration, (String)"audience.timeout", (int)2);
            NetworkRequest networkRequest = new NetworkRequest(optOutUrl, HttpMethod.GET, null, null, timeout, timeout);
            ServiceProvider.getInstance().getNetworkService().connectAsync(networkRequest, connection -> {
                if (connection == null) {
                    Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"sendOptOutHit - Failed to send the opt-out hit because the connection is null (network is offline).", (Object[])new Object[0]);
                    return;
                }
                if (connection.getResponseCode() == 200) {
                    Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Successfully sent the optOut hit.", (Object[])new Object[0]);
                } else {
                    Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Failed to send the optOut hit with connection status (%s).", (Object[])new Object[]{connection.getResponseCode()});
                }
                connection.close();
            });
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>(){
            {
                this.put("optedouthitsent", canSendOptOutHit);
            }
        };
        Event optOutEvent = new Event.Builder("Audience Manager Opt Out Event", "com.adobe.eventType.audienceManager", "com.adobe.eventSource.responseContent").setEventData((Map)eventData).build();
        this.getApi().dispatch(optOutEvent);
    }

    private String getOptOutUrlPrefix(String server) {
        return String.format("https://%s/demoptout.jpg?", server);
    }

    private String getOptOutUrlSuffix(String uuid) {
        return String.format("d_uuid=%s", uuid);
    }

    private HashMap<String, String> getLifecycleDataForAudience(Map<String, String> lifecycleData) {
        HashMap<String, String> lifecycleContextData = new HashMap<String, String>();
        if (MapUtils.isNullOrEmpty(lifecycleData)) {
            return lifecycleContextData;
        }
        HashMap<String, String> tempLifecycleContextData = new HashMap<String, String>(lifecycleData);
        for (Map.Entry<String, String> kvp : AudienceConstants.MAP_TO_CONTEXT_DATA_KEYS.entrySet()) {
            String value = (String)tempLifecycleContextData.get(kvp.getKey());
            if (StringUtils.isNullOrEmpty((String)value)) continue;
            lifecycleContextData.put(kvp.getValue(), value);
            tempLifecycleContextData.remove(kvp.getKey());
        }
        lifecycleContextData.putAll(tempLifecycleContextData);
        return lifecycleContextData;
    }

    private String buildSignalUrl(String server, Map<String, String> signalData, Event event) {
        String urlString = new URLBuilder().enableSSL(true).setServer(server).addPath("event").addQuery(this.getCustomUrlVariables(signalData), URLBuilder.EncodeType.NONE).addQuery(this.getDataProviderUrlVariables(event), URLBuilder.EncodeType.NONE).addQuery(this.getPlatformSuffix(), URLBuilder.EncodeType.NONE).addQuery("d_dst=1", URLBuilder.EncodeType.NONE).addQuery("d_rtbd=json", URLBuilder.EncodeType.NONE).build();
        return urlString;
    }

    private String getCustomUrlVariables(Map<String, String> data) {
        if (MapUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Audience", (String)LOG_SOURCE, (String)"No data found converting customer data for URL parameters.", (Object[])new Object[0]);
            return "";
        }
        StringBuilder urlVars = new StringBuilder(1024);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isNullOrEmpty((String)key) || StringUtils.isNullOrEmpty((String)value)) continue;
            if (urlVars.length() != 0) {
                urlVars.append("&");
            }
            urlVars.append("c_").append(UrlUtils.urlEncode((String)key.replace(".", "_"))).append("=").append(UrlUtils.urlEncode((String)value));
        }
        return urlVars.toString();
    }

    private String getDataProviderUrlVariables(Event event) {
        String uuid;
        String marketingCloudOrgId;
        SharedStateResult identityResult = this.getSharedStateForExtension("com.adobe.module.identity", event);
        Map identitySharedState = identityResult != null ? identityResult.getValue() : null;
        SharedStateResult configResult = this.getSharedStateForExtension("com.adobe.module.configuration", event);
        Map configurationSharedState = configResult != null ? configResult.getValue() : null;
        StringBuilder urlVars = new StringBuilder(1024);
        if (identitySharedState != null) {
            List customerIds;
            String customerIdString;
            String marketingCloudId = DataReader.optString((Map)identitySharedState, (String)"mid", null);
            String blob = DataReader.optString((Map)identitySharedState, (String)"blob", null);
            String locationHint = DataReader.optString((Map)identitySharedState, (String)"locationhint", null);
            if (!StringUtils.isNullOrEmpty((String)marketingCloudId)) {
                urlVars.append(this.serializeKeyValuePair("d_mid", marketingCloudId));
            }
            if (!StringUtils.isNullOrEmpty((String)blob)) {
                urlVars.append(this.serializeKeyValuePair("d_blob", blob));
            }
            if (!StringUtils.isNullOrEmpty((String)locationHint)) {
                urlVars.append(this.serializeKeyValuePair("dcs_region", locationHint));
            }
            if (!StringUtils.isNullOrEmpty((String)(customerIdString = this.generateCustomerVisitorIdString(customerIds = DataReader.optTypedListOfMap(Object.class, (Map)identitySharedState, (String)"visitoridslist", null))))) {
                urlVars.append(customerIdString);
            }
        }
        if (configurationSharedState != null && !StringUtils.isNullOrEmpty((String)(marketingCloudOrgId = DataReader.optString((Map)configurationSharedState, (String)"experienceCloud.org", null)))) {
            urlVars.append(this.serializeKeyValuePair("d_orgid", marketingCloudOrgId));
        }
        if (this.internalState != null && !StringUtils.isNullOrEmpty((String)(uuid = this.internalState.getUuid()))) {
            urlVars.append(this.serializeKeyValuePair("d_uuid", uuid));
        }
        return urlVars.length() > 0 ? urlVars.substring(1) : "";
    }

    private String generateCustomerVisitorIdString(List<Map<String, Object>> customerIds) {
        if (customerIds == null) {
            return null;
        }
        StringBuilder customerIdString = new StringBuilder();
        for (Map<String, Object> visitorId : customerIds) {
            if (visitorId == null) continue;
            customerIdString.append(this.serializeKeyValuePair("d_cid_ic", DataReader.optString(visitorId, (String)"ID_TYPE", null)));
            String urlEncodedId = UrlUtils.urlEncode((String)DataReader.optString(visitorId, (String)"ID", null));
            if (!StringUtils.isNullOrEmpty((String)urlEncodedId)) {
                customerIdString.append("%01");
                customerIdString.append(urlEncodedId);
            }
            customerIdString.append("%01");
            customerIdString.append(DataReader.optInt(visitorId, (String)"STATE", (int)0));
        }
        return customerIdString.toString();
    }

    private String getPlatformSuffix() {
        String platform = "java";
        DeviceInforming deviceInfoService = ServiceProvider.getInstance().getDeviceInfoService();
        if (deviceInfoService == null) {
            return "d_ptfm=" + platform;
        }
        String canonicalPlatformName = deviceInfoService.getCanonicalPlatformName();
        if (!StringUtils.isNullOrEmpty((String)canonicalPlatformName)) {
            platform = canonicalPlatformName;
        }
        return "d_ptfm=" + platform;
    }

    private void processDestsArray(JSONObject jsonResponse, int timeout) {
        try {
            JSONArray dests = jsonResponse.getJSONArray("dests");
            for (int i = 0; i < dests.length(); ++i) {
                String url;
                JSONObject dest = dests.getJSONObject(i);
                if (dest.length() == 0 || StringUtils.isNullOrEmpty((String)(url = dest.optString("c", "")))) continue;
                NetworkRequest request = new NetworkRequest(url, HttpMethod.GET, null, null, timeout, timeout);
                ServiceProvider.getInstance().getNetworkService().connectAsync(request, connection -> {
                    if (connection == null) {
                        Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"processDestsArray - Failed to forward destinations because the connection is null (network is offline).", (Object[])new Object[0]);
                        return;
                    }
                    if (connection.getResponseCode() == 200) {
                        Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Successfully forwarded 'dest'.", (Object[])new Object[0]);
                    } else {
                        Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"Failed to process dest - connection status \"%s\".", (Object[])new Object[]{connection.getResponseCode()});
                    }
                    connection.close();
                });
            }
        }
        catch (JSONException ex) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"No destinations ('dests') in response.", (Object[])new Object[0]);
        }
    }

    @NonNull
    private Map<String, String> processStuffArray(JSONObject jsonResponse) {
        HashMap<String, String> returnedMap = new HashMap<String, String>();
        try {
            JSONArray stuffArray = jsonResponse.getJSONArray("stuff");
            for (int i = 0; i < stuffArray.length(); ++i) {
                JSONObject stuff = stuffArray.getJSONObject(i);
                if (stuff == null || stuff.length() == 0) continue;
                String cookieName = stuff.optString("cn", "");
                String cookieValue = stuff.optString("cv", "");
                if (cookieName.isEmpty()) continue;
                returnedMap.put(cookieName, cookieValue);
            }
        }
        catch (JSONException ex) {
            Log.trace((String)"Audience", (String)LOG_SOURCE, (String)"No 'stuff' array in response.", (Object[])new Object[0]);
        }
        return returnedMap;
    }

    private String serializeKeyValuePair(String key, String value) {
        if (StringUtils.isNullOrEmpty((String)key) || value == null) {
            return null;
        }
        return "&" + key + "=" + value;
    }

    private void deleteDeprecatedV1HitDatabase() {
        SQLiteUtils.deleteDBFromCacheDir((String)"ADBMobileAAM.sqlite");
    }

    private class NetworkResponseHandler
    implements AudienceNetworkResponseHandler {
        private AudienceState state;

        NetworkResponseHandler(AudienceState state) {
            this.state = state;
        }

        @Override
        public void complete(String responsePayload, Event requestEvent) {
            String LOG_SOURCE = "AudienceNetworkResponseHandler";
            if (requestEvent == null) {
                Log.warning((String)"Audience", (String)"AudienceNetworkResponseHandler", (String)"Unable to process network response, invalid request event.", (Object[])new Object[0]);
                return;
            }
            if (requestEvent.getTimestamp() < this.state.getLastResetTimestampMillis()) {
                Log.debug((String)"Audience", (String)"AudienceNetworkResponseHandler", (String)"Not dispatching Audience hit response since resetIdentities API was called after queuing this hit.", (Object[])new Object[0]);
                AudienceExtension.this.resolveSharedStateForEvent(requestEvent);
                return;
            }
            Map profile = new HashMap();
            if (StringUtils.isNullOrEmpty((String)responsePayload)) {
                Log.debug((String)"Audience", (String)"AudienceNetworkResponseHandler", (String)"Null/empty response from server, nothing to process.", (Object[])new Object[0]);
                AudienceExtension.this.resolveSharedStateForEvent(requestEvent);
                AudienceExtension.this.dispatchAudienceResponseContent(profile, requestEvent);
                return;
            }
            profile = AudienceExtension.this.processResponse(responsePayload, requestEvent);
            AudienceExtension.this.resolveSharedStateForEvent(requestEvent);
            if (profile != null && !profile.isEmpty()) {
                AudienceExtension.this.dispatchAudienceResponseContent(profile, null);
            }
            AudienceExtension.this.dispatchAudienceResponseContent(profile, requestEvent);
        }
    }
}

