/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.audience;

import com.adobe.marketing.mobile.MobilePrivacyStatus;
import java.util.HashMap;

class AudienceConstants {
    static final String EXTENSION_NAME = "com.adobe.module.audience";
    static final String FRIENDLY_EXTENSION_NAME = "Audience";
    static final String LOG_TAG = "Audience";
    static final String AUDIENCE_MANAGER_USER_ID_KEY = "d_uuid";
    static final String MARKETING_CLOUD_ORG_ID = "d_orgid";
    static final String VISITOR_ID_MID_KEY = "d_mid";
    static final String VISITOR_ID_BLOB_KEY = "d_blob";
    static final String VISITOR_ID_LOCATION_HINT_KEY = "dcs_region";
    static final String VISITOR_ID_PARAMETER_KEY_CUSTOMER = "d_cid_ic";
    static final String VISITOR_ID_CID_DELIMITER = "%01";
    static final String AUDIENCE_MANAGER_EVENT_PATH = "event";
    static final String AUDIENCE_MANAGER_CUSTOMER_DATA_PREFIX = "c_";
    static final String AUDIENCE_MANAGER_URL_PARAM_DST = "d_dst=1";
    static final String AUDIENCE_MANAGER_URL_PARAM_RTBD = "d_rtbd=json";
    static final String AUDIENCE_MANAGER_URL_PLATFORM_KEY = "d_ptfm=";
    static final String AUDIENCE_MANAGER_SHARED_PREFS_DATA_STORE = "AAMDataStore";
    static final String AUDIENCE_MANAGER_SHARED_PREFS_PROFILE_KEY = "AAMUserProfile";
    static final String AUDIENCE_MANAGER_SHARED_PREFS_USER_ID_KEY = "AAMUserId";
    static final String AUDIENCE_MANAGER_JSON_DESTS_KEY = "dests";
    static final String AUDIENCE_MANAGER_JSON_URL_KEY = "c";
    static final String AUDIENCE_MANAGER_JSON_STUFF_KEY = "stuff";
    static final String AUDIENCE_MANAGER_JSON_USER_ID_KEY = "uuid";
    static final String AUDIENCE_MANAGER_JSON_COOKIE_NAME_KEY = "cn";
    static final String AUDIENCE_MANAGER_JSON_COOKIE_VALUE_KEY = "cv";
    static final int DEFAULT_AAM_TIMEOUT = 2;
    static final MobilePrivacyStatus DEFAULT_PRIVACY_STATUS = MobilePrivacyStatus.UNKNOWN;
    static final String AUDIENCE_MANAGER_OPT_OUT_URL_BASE = "https://%s/demoptout.jpg?";
    static final String AUDIENCE_MANAGER_OPT_OUT_URL_AAM = "d_uuid=%s";
    static final String DEPRECATED_1X_HIT_DATABASE_FILENAME = "ADBMobileAAM.sqlite";
    static final HashMap<String, String> MAP_TO_CONTEXT_DATA_KEYS = AudienceConstants.createMap();

    static HashMap<String, String> createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("advertisingidentifier", "a.adid");
        map.put("appid", "a.AppID");
        map.put("carriername", "a.CarrierName");
        map.put("crashevent", "a.CrashEvent");
        map.put("dailyenguserevent", "a.DailyEngUserEvent");
        map.put("dayofweek", "a.DayOfWeek");
        map.put("dayssincefirstuse", "a.DaysSinceFirstUse");
        map.put("dayssincelastuse", "a.DaysSinceLastUse");
        map.put("dayssincelastupgrade", "a.DaysSinceLastUpgrade");
        map.put("devicename", "a.DeviceName");
        map.put("resolution", "a.Resolution");
        map.put("hourofday", "a.HourOfDay");
        map.put("ignoredsessionlength", "a.ignoredSessionLength");
        map.put("installdate", "a.InstallDate");
        map.put("installevent", "a.InstallEvent");
        map.put("launchevent", "a.LaunchEvent");
        map.put("launches", "a.Launches");
        map.put("launchessinceupgrade", "a.LaunchesSinceUpgrade");
        map.put("locale", "a.locale");
        map.put("monthlyenguserevent", "a.MonthlyEngUserEvent");
        map.put("osversion", "a.OSVersion");
        map.put("prevsessionlength", "a.PrevSessionLength");
        map.put("runmode", "a.RunMode");
        map.put("upgradeevent", "a.UpgradeEvent");
        return map;
    }

    AudienceConstants() {
    }

    static final class EventDataKeys {
        static final String STATE_OWNER = "stateowner";

        private EventDataKeys() {
        }

        static final class Lifecycle {
            static final String APP_ID = "appid";
            static final String CARRIER_NAME = "carriername";
            static final String CRASH_EVENT = "crashevent";
            static final String DAILY_ENGAGED_EVENT = "dailyenguserevent";
            static final String DAY_OF_WEEK = "dayofweek";
            static final String DAYS_SINCE_FIRST_LAUNCH = "dayssincefirstuse";
            static final String DAYS_SINCE_LAST_LAUNCH = "dayssincelastuse";
            static final String DAYS_SINCE_LAST_UPGRADE = "dayssincelastupgrade";
            static final String DEVICE_NAME = "devicename";
            static final String DEVICE_RESOLUTION = "resolution";
            static final String HOUR_OF_DAY = "hourofday";
            static final String IGNORED_SESSION_LENGTH = "ignoredsessionlength";
            static final String INSTALL_DATE = "installdate";
            static final String INSTALL_EVENT = "installevent";
            static final String LAUNCH_EVENT = "launchevent";
            static final String LAUNCHES = "launches";
            static final String LAUNCHES_SINCE_UPGRADE = "launchessinceupgrade";
            static final String LIFECYCLE_CONTEXT_DATA = "lifecyclecontextdata";
            static final String LOCALE = "locale";
            static final String MONTHLY_ENGAGED_EVENT = "monthlyenguserevent";
            static final String OPERATING_SYSTEM = "osversion";
            static final String PREVIOUS_SESSION_LENGTH = "prevsessionlength";
            static final String RUN_MODE = "runmode";
            static final String UPGRADE_EVENT = "upgradeevent";

            private Lifecycle() {
            }
        }

        static final class Identity {
            static final String MODULE_NAME = "com.adobe.module.identity";
            static final String VISITOR_ID_MID = "mid";
            static final String VISITOR_ID_BLOB = "blob";
            static final String VISITOR_ID_LOCATION_HINT = "locationhint";
            static final String VISITOR_IDS_LIST = "visitoridslist";
            static final String ADVERTISING_IDENTIFIER = "advertisingidentifier";

            private Identity() {
            }

            static final class VisitorID {
                static final String ID = "ID";
                static final String ID_TYPE = "ID_TYPE";
                static final String STATE = "STATE";

                private VisitorID() {
                }
            }
        }

        static final class Configuration {
            static final String MODULE_NAME = "com.adobe.module.configuration";
            static final String GLOBAL_CONFIG_PRIVACY = "global.privacy";
            static final String AAM_CONFIG_SERVER = "audience.server";
            static final String AAM_CONFIG_TIMEOUT = "audience.timeout";
            static final String EXPERIENCE_CLOUD_ORGID = "experienceCloud.org";
            static final String ANALYTICS_CONFIG_AAMFORWARDING = "analytics.aamForwardingEnabled";

            private Configuration() {
            }
        }

        static final class Audience {
            static final String VISITOR_TRAITS = "aamtraits";
            static final String VISITOR_PROFILE = "aamprofile";
            static final String UUID = "uuid";
            static final String OPTED_OUT_HIT_SENT = "optedouthitsent";

            private Audience() {
            }
        }

        static final class Analytics {
            static final String ANALYTICS_SERVER_RESPONSE_KEY = "analyticsserverresponse";

            private Analytics() {
            }
        }
    }

    static final class ContextDataKeys {
        static final String INSTALL_EVENT_KEY = "a.InstallEvent";
        static final String LAUNCH_EVENT_KEY = "a.LaunchEvent";
        static final String CRASH_EVENT_KEY = "a.CrashEvent";
        static final String UPGRADE_EVENT_KEY = "a.UpgradeEvent";
        static final String DAILY_ENGAGED_EVENT_KEY = "a.DailyEngUserEvent";
        static final String MONTHLY_ENGAGED_EVENT_KEY = "a.MonthlyEngUserEvent";
        static final String INSTALL_DATE = "a.InstallDate";
        static final String LAUNCHES = "a.Launches";
        static final String PREVIOUS_SESSION_LENGTH = "a.PrevSessionLength";
        static final String DAYS_SINCE_FIRST_LAUNCH = "a.DaysSinceFirstUse";
        static final String DAYS_SINCE_LAST_LAUNCH = "a.DaysSinceLastUse";
        static final String HOUR_OF_DAY = "a.HourOfDay";
        static final String DAY_OF_WEEK = "a.DayOfWeek";
        static final String OPERATING_SYSTEM = "a.OSVersion";
        static final String APPLICATION_IDENTIFIER = "a.AppID";
        static final String DAYS_SINCE_LAST_UPGRADE = "a.DaysSinceLastUpgrade";
        static final String LAUNCHES_SINCE_UPGRADE = "a.LaunchesSinceUpgrade";
        static final String ADVERTISING_IDENTIFIER = "a.adid";
        static final String DEVICE_NAME = "a.DeviceName";
        static final String DEVICE_RESOLUTION = "a.Resolution";
        static final String CARRIER_NAME = "a.CarrierName";
        static final String LOCALE = "a.locale";
        static final String RUN_MODE = "a.RunMode";
        static final String IGNORED_SESSION_LENGTH = "a.ignoredSessionLength";

        private ContextDataKeys() {
        }
    }
}

