/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.analytics.internal;

import com.adobe.marketing.mobile.analytics.internal.ContextData;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ContextDataUtil {
    private static final String LOG_TAG = ContextDataUtil.class.getSimpleName();
    private static final boolean[] contextDataMask = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final Map<String, String> contextDataKeyAllowList = new HashMap<String, String>(256);
    private static final int MAX_LIMIT = 250;
    private static int contextDataKeyAllowListCount = 0;

    private ContextDataUtil() {
    }

    public static ContextData translateContextData(Map<String, String> data) {
        ContextData tempContextData = new ContextData();
        for (Map.Entry<String, Object> entry : ContextDataUtil.cleanContextDataDictionary(data).entrySet()) {
            int end;
            String key = entry.getKey();
            ArrayList<String> list = new ArrayList<String>();
            int pos = 0;
            while ((end = key.indexOf(46, pos)) >= 0) {
                list.add(key.substring(pos, end));
                pos = end + 1;
            }
            list.add(key.substring(pos, key.length()));
            ContextDataUtil.addValueToHashMap(entry.getValue(), tempContextData, list, 0);
        }
        return tempContextData;
    }

    public static Map<String, Object> cleanContextDataDictionary(Map<String, String> data) {
        HashMap<String, Object> tempContextData = new HashMap<String, Object>();
        if (data == null) {
            return tempContextData;
        }
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String cleanedKey = ContextDataUtil.cleanContextDataKey(entry.getKey());
            if (cleanedKey == null) continue;
            tempContextData.put(cleanedKey, entry.getValue());
        }
        return tempContextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cleanContextDataKey(String key) {
        int startIndex;
        if (key == null) {
            return null;
        }
        Map<String, String> map = contextDataKeyAllowList;
        synchronized (map) {
            String preCleanedKey = contextDataKeyAllowList.get(key);
            if (preCleanedKey != null) {
                return preCleanedKey;
            }
        }
        byte[] utf8Key = key.getBytes(StandardCharsets.UTF_8);
        byte[] outPut = new byte[utf8Key.length];
        int periodChar = 46;
        int mask = 255;
        int lastByte = 0;
        int outIndex = 0;
        for (int n : utf8Key) {
            if (n == 46 && lastByte == 46 || !contextDataMask[n & 0xFF]) continue;
            outPut[outIndex++] = n;
            lastByte = n;
        }
        if (outIndex == 0) {
            return null;
        }
        int endTrim = outPut[outIndex - 1] == 46 ? 1 : 0;
        int totalLength = outIndex - endTrim - (startIndex = outPut[0] == 46 ? 1 : 0);
        if (totalLength <= 0) {
            return null;
        }
        String cleanKey = new String(outPut, startIndex, totalLength, StandardCharsets.UTF_8);
        Map<String, String> map2 = contextDataKeyAllowList;
        synchronized (map2) {
            if (contextDataKeyAllowListCount > 250) {
                contextDataKeyAllowList.clear();
                contextDataKeyAllowListCount = 0;
            }
            contextDataKeyAllowList.put(key, cleanKey);
            ++contextDataKeyAllowListCount;
        }
        return cleanKey;
    }

    public static void serializeToQueryString(Map<String, Object> parameters, StringBuilder builder) {
        if (parameters == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = UrlUtils.urlEncode((String)entry.getKey());
            if (key == null) continue;
            Object obj = entry.getValue();
            if (obj instanceof ContextData) {
                ContextData data = (ContextData)obj;
                if (data.value != null) {
                    ContextDataUtil.serializeKeyValuePair(key, data.value, builder);
                }
                if (data.data == null || data.data.size() <= 0) continue;
                builder.append("&");
                builder.append(key);
                builder.append(".");
                ContextDataUtil.serializeToQueryString(data.data, builder);
                builder.append("&.");
                builder.append(key);
                continue;
            }
            ContextDataUtil.serializeKeyValuePair(key, obj, builder);
        }
    }

    static String join(Iterable<?> elements, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = elements.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) break;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    static String appendContextData(Map<String, String> referrerData, String source) {
        if (StringUtils.isNullOrEmpty((String)source) || referrerData == null || referrerData.isEmpty()) {
            return source;
        }
        Pattern pattern = Pattern.compile(".*(&c\\.(.*)&\\.c).*");
        Matcher matcher = pattern.matcher(source);
        boolean contextDataNotMatched = false;
        try {
            contextDataNotMatched = !matcher.matches() || matcher.group(2) == null;
        }
        catch (IndexOutOfBoundsException exception) {
            Log.debug((String)"Analytics", (String)LOG_TAG, (String)"Context data matcher failed with %s", (Object[])new Object[]{exception});
        }
        catch (IllegalStateException exception) {
            Log.debug((String)"Analytics", (String)LOG_TAG, (String)"Context data matcher failed with %s", (Object[])new Object[]{exception});
        }
        if (contextDataNotMatched) {
            StringBuilder urlSb = new StringBuilder(source);
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("c", ContextDataUtil.translateContextData(referrerData));
            ContextDataUtil.serializeToQueryString(contextMap, urlSb);
            return urlSb.toString();
        }
        try {
            String contextDataString = matcher.group(2);
            Map<String, String> contextData = ContextDataUtil.deserializeContextDataKeyValuePairs(contextDataString);
            contextData.putAll(referrerData);
            StringBuilder urlSb = new StringBuilder(source.substring(0, matcher.start(1)));
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("c", ContextDataUtil.translateContextData(contextData));
            ContextDataUtil.serializeToQueryString(contextMap, urlSb);
            urlSb.append(source.substring(matcher.end(1)));
            return urlSb.toString();
        }
        catch (IndexOutOfBoundsException exception) {
            Log.debug((String)"Analytics", (String)LOG_TAG, (String)"Context data matcher failed with %s", (Object[])new Object[]{exception});
        }
        catch (IllegalStateException exception) {
            Log.debug((String)"Analytics", (String)LOG_TAG, (String)"Context data matcher failed with %s", (Object[])new Object[]{exception});
        }
        return source;
    }

    private static void addValueToHashMap(Object object, ContextData table, List<String> subKeyArray, int index) {
        String keyName;
        if (table == null || subKeyArray == null) {
            return;
        }
        int arrayCount = subKeyArray.size();
        String string = keyName = index < arrayCount ? subKeyArray.get(index) : null;
        if (keyName == null) {
            return;
        }
        ContextData data = new ContextData();
        if (table.containsKey(keyName)) {
            data = table.get(keyName);
        }
        if (arrayCount - 1 == index) {
            data.value = object;
            table.put(keyName, data);
        } else {
            table.put(keyName, data);
            ContextDataUtil.addValueToHashMap(object, data, subKeyArray, index + 1);
        }
    }

    private static void serializeKeyValuePair(String key, Object value, StringBuilder builder) {
        if (key == null || value == null || value instanceof ContextData || key.length() <= 0) {
            return;
        }
        if (value instanceof String && ((String)value).length() <= 0) {
            return;
        }
        builder.append("&");
        builder.append(key);
        builder.append("=");
        if (value instanceof List) {
            builder.append(UrlUtils.urlEncode((String)ContextDataUtil.join((List)value, ",")));
        } else {
            builder.append(UrlUtils.urlEncode((String)value.toString()));
        }
    }

    public static Map<String, String> deserializeContextDataKeyValuePairs(String contextDataString) {
        int mapCapacity = 64;
        int listCapacity = 16;
        HashMap<String, String> contextData = new HashMap<String, String>(64);
        ArrayList<String> keyPath = new ArrayList<String>(16);
        for (String param : contextDataString.split("&")) {
            if (param.endsWith(".") && !param.contains("=")) {
                keyPath.add(param);
                continue;
            }
            if (param.startsWith(".")) {
                if (keyPath.isEmpty()) continue;
                keyPath.remove(keyPath.size() - 1);
                continue;
            }
            String[] kvpair = param.split("=");
            if (kvpair.length != 2) continue;
            String contextDataKey = ContextDataUtil.contextDataStringPath(keyPath, kvpair[0]);
            try {
                contextData.put(contextDataKey, URLDecoder.decode(kvpair[1], String.valueOf(StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                Log.warning((String)"Analytics", (String)LOG_TAG, (String)"Appending the context data information failed with %s", (Object[])new Object[]{e});
            }
        }
        return contextData;
    }

    private static String contextDataStringPath(List<String> keyPath, String lastComponent) {
        StringBuilder sb = new StringBuilder();
        for (String pathComponent : keyPath) {
            sb.append(pathComponent);
        }
        sb.append(lastComponent);
        return sb.toString();
    }
}

