/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.analytics.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.ExtensionEventListener;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsConstants;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsDatabase;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsHitProcessor;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsProperties;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsRequestSerializer;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsState;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsTimer;
import com.adobe.marketing.mobile.analytics.internal.TimeZone;
import com.adobe.marketing.mobile.services.AppState;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.SQLiteUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 Q2\u00020\u0001:\u0001QB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J=\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0002J*\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160 2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J&\u0010$\u001a\u00020\u00142\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 H\u0002J\b\u0010)\u001a\u00020\u0016H\u0014J\b\u0010*\u001a\u00020\u0016H\u0014J\b\u0010+\u001a\u00020\u0016H\u0014J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010/\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0015\u00100\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b1J\u0010\u00102\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0015\u00103\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u00106\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0015\u00107\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b:J&\u0010;\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 H\u0002J\u001e\u0010<\u001a\u00020=2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 H\u0002J\b\u0010>\u001a\u00020\u0014H\u0014J2\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160@2\u0006\u0010A\u001a\u00020\u001c2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 H\u0002J2\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160@2\u0014\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 2\u0006\u0010E\u001a\u00020\u001cH\u0002J\u0010\u0010F\u001a\u00020=2\u0006\u0010&\u001a\u00020'H\u0016J6\u0010G\u001a\u00020\u00142\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"0 2\u0006\u0010A\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020=2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010I\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010J\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010K\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00160MH\u0002J\u0010\u0010N\u001a\u00020\u00142\u0006\u0010O\u001a\u00020\u001cH\u0002J\b\u0010P\u001a\u00020\u0014H\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsExtension;", "Lcom/adobe/marketing/mobile/Extension;", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/ExtensionApi;)V", "database", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase;", "(Lcom/adobe/marketing/mobile/ExtensionApi;Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsDatabase;)V", "analyticsDatabase", "analyticsProperties", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsProperties;", "analyticsState", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsState;", "analyticsTimer", "Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsTimer;", "dataStore", "Lcom/adobe/marketing/mobile/services/NamedCollection;", "eventHandler", "Lcom/adobe/marketing/mobile/ExtensionEventListener;", "backdateLifecycleCrash", "", "previousOSVersion", "", "previousAppIdVersion", "eventUniqueIdentifier", "backdateLifecycleSessionInfo", "previousSessionLength", "previousSessionPauseTimestamp", "", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "boot", "cleanContextData", "", "eventData", "", "deleteDeprecatedV5HitDatabase", "dispatchAnalyticsResponseIdentity", "data", "event", "Lcom/adobe/marketing/mobile/Event;", "getAnalyticsIds", "getFriendlyName", "getName", "getVersion", "handleAcquisitionEvent", "handleAnalyticsRequestContentEvent", "handleAnalyticsRequestIdentityEvent", "handleConfigurationResponseEvent", "handleGenericLifecycleEvents", "handleGenericLifecycleEvents$analytics_phoneRelease", "handleGenericTrackEvent", "handleIncomingEvent", "handleIncomingEvent$analytics_phoneRelease", "handleLifecycleEvents", "handleOptOut", "handleResetIdentitiesEvent", "handleResetIdentitiesEvent$analytics_phoneRelease", "handleRuleEngineResponse", "handleRuleEngineResponse$analytics_phoneRelease", "handleTrackRequest", "isTrackActionOrTrackStateEvent", "", "onRegistered", "processAnalyticsContextData", "", "timeStampInSeconds", "trackEventData", "processAnalyticsVars", "trackData", "timestamp", "readyForEvent", "track", "isBackdatedHit", "trackAcquisitionData", "trackLifecycle", "updateAnalyticsState", "dependencies", "", "waitForAcquisitionData", "timeout", "waitForLifecycleData", "Companion", "analytics_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nAnalyticsExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsExtension.kt\ncom/adobe/marketing/mobile/analytics/internal/AnalyticsExtension\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1198:1\n215#2,2:1199\n1271#3,2:1201\n1285#3,4:1203\n1238#3,4:1216\n483#4,7:1207\n442#4:1214\n392#4:1215\n*S KotlinDebug\n*F\n+ 1 AnalyticsExtension.kt\ncom/adobe/marketing/mobile/analytics/internal/AnalyticsExtension\n*L\n665#1:1199,2\n944#1:1201,2\n944#1:1203,4\n1195#1:1216,4\n1195#1:1207,7\n1195#1:1214\n1195#1:1215\n*E\n"})
public final class AnalyticsExtension
extends Extension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsDatabase analyticsDatabase;
    @NotNull
    private final AnalyticsProperties analyticsProperties;
    @NotNull
    private final AnalyticsState analyticsState;
    @NotNull
    private final NamedCollection dataStore;
    @NotNull
    private final ExtensionEventListener eventHandler;
    @NotNull
    private final AnalyticsTimer analyticsTimer;
    @NotNull
    private static final String CLASS_NAME = "AnalyticsExtension";
    @NotNull
    private static final List<String> ANALYTICS_HARD_DEPENDENCIES;
    @NotNull
    private static final List<String> ANALYTICS_SOFT_DEPENDENCIES;

    public AnalyticsExtension(@NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this(extensionApi, null);
    }

    @VisibleForTesting
    public AnalyticsExtension(@NotNull ExtensionApi extensionApi, @Nullable AnalyticsDatabase database) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        super(extensionApi);
        this.analyticsState = new AnalyticsState();
        NamedCollection namedCollection = ServiceProvider.getInstance().getDataStoreService().getNamedCollection("AnalyticsDataStorage");
        Intrinsics.checkNotNullExpressionValue((Object)namedCollection, (String)"getInstance().dataStoreS\u2026Constants.DATASTORE_NAME)");
        this.dataStore = namedCollection;
        this.eventHandler = arg_0 -> AnalyticsExtension.eventHandler$lambda$0(this, arg_0);
        this.analyticsTimer = new AnalyticsTimer();
        this.analyticsProperties = new AnalyticsProperties(this.dataStore);
        AnalyticsDatabase analyticsDatabase = database;
        if (analyticsDatabase == null) {
            analyticsDatabase = new AnalyticsDatabase(new AnalyticsHitProcessor(this.analyticsState, extensionApi), this.analyticsState);
        }
        this.analyticsDatabase = analyticsDatabase;
    }

    @NotNull
    protected String getName() {
        return "com.adobe.module.analytics";
    }

    @NotNull
    protected String getFriendlyName() {
        return "Analytics";
    }

    @NotNull
    protected String getVersion() {
        return "3.0.2";
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.rulesEngine", "com.adobe.eventSource.responseContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.analytics", "com.adobe.eventSource.requestContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.analytics", "com.adobe.eventSource.requestIdentity", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.generic.lifecycle", "com.adobe.eventSource.requestContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.lifecycle", "com.adobe.eventSource.responseContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.acquisition", "com.adobe.eventSource.responseContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.generic.track", "com.adobe.eventSource.requestContent", this.eventHandler);
        this.getApi().registerEventListener("com.adobe.eventType.generic.identity", "com.adobe.eventSource.requestReset", this.eventHandler);
        this.deleteDeprecatedV5HitDatabase();
        this.boot();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readyForEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SharedStateResult configurationStatus = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY);
        SharedStateResult identityStatus = this.getApi().getSharedState("com.adobe.module.identity", event, false, SharedStateResolution.ANY);
        SharedStateResult sharedStateResult = configurationStatus;
        if ((sharedStateResult != null ? sharedStateResult.getStatus() : null) != SharedStateStatus.SET) return false;
        SharedStateResult sharedStateResult2 = identityStatus;
        if ((sharedStateResult2 != null ? sharedStateResult2.getStatus() : null) != SharedStateStatus.SET) return false;
        return true;
    }

    @VisibleForTesting
    public final void handleIncomingEvent$analytics_phoneRelease(@NotNull Event event) {
        block29: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            String string = event.getType();
            if (string == null) break block29;
            int n = -1;
            switch (string.hashCode()) {
                case -485068825: {
                    if (string.equals("com.adobe.eventType.acquisition")) {
                        n = 1;
                    }
                    break;
                }
                case -1916134322: {
                    if (string.equals("com.adobe.eventType.generic.track")) {
                        n = 2;
                    }
                    break;
                }
                case 1388788339: {
                    if (string.equals("com.adobe.eventType.rulesEngine")) {
                        n = 3;
                    }
                    break;
                }
                case -364259091: {
                    if (string.equals("com.adobe.eventType.generic.lifecycle")) {
                        n = 4;
                    }
                    break;
                }
                case -1784231328: {
                    if (string.equals("com.adobe.eventType.analytics")) {
                        n = 5;
                    }
                    break;
                }
                case -553401637: {
                    if (string.equals("com.adobe.eventType.generic.identity")) {
                        n = 6;
                    }
                    break;
                }
                case 972859088: {
                    if (string.equals("com.adobe.eventType.configuration")) {
                        n = 7;
                    }
                    break;
                }
                case -393537980: {
                    if (string.equals("com.adobe.eventType.lifecycle")) {
                        n = 8;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.handleGenericTrackEvent(event);
                    break;
                }
                case 3: {
                    this.handleRuleEngineResponse$analytics_phoneRelease(event);
                    break;
                }
                case 7: {
                    this.handleConfigurationResponseEvent(event);
                    break;
                }
                case 8: {
                    this.handleLifecycleEvents(event);
                    break;
                }
                case 4: {
                    this.handleGenericLifecycleEvents$analytics_phoneRelease(event);
                    break;
                }
                case 1: {
                    this.handleAcquisitionEvent(event);
                    break;
                }
                case 5: {
                    String string2 = event.getSource();
                    if (Intrinsics.areEqual((Object)string2, (Object)"com.adobe.eventSource.requestIdentity")) {
                        this.handleAnalyticsRequestIdentityEvent(event);
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)string2, (Object)"com.adobe.eventSource.requestContent")) break;
                    this.handleAnalyticsRequestContentEvent(event);
                    break;
                }
                case 6: {
                    this.handleResetIdentitiesEvent$analytics_phoneRelease(event);
                }
            }
        }
    }

    @VisibleForTesting
    public final void handleResetIdentitiesEvent$analytics_phoneRelease(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getType(), (Object)"com.adobe.eventType.generic.identity") || !Intrinsics.areEqual((Object)event.getSource(), (Object)"com.adobe.eventSource.requestReset")) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleResetIdentitiesEvent - Ignoring reset event (event is of unexpected type or source).", (Object[])new Object[0]);
            return;
        }
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleResetIdentitiesEvent - Resetting all identifiers.", (Object[])new Object[0]);
        this.analyticsDatabase.reset();
        this.analyticsProperties.reset();
        this.analyticsState.resetIdentities();
        this.analyticsState.setLastResetIdentitiesTimestampSec$analytics_phoneRelease(event.getTimestampInSeconds());
        this.getApi().createSharedState(this.getAnalyticsIds(), event);
    }

    private final void handleGenericTrackEvent(Event event) {
        if (!Intrinsics.areEqual((Object)event.getType(), (Object)"com.adobe.eventType.generic.track") || !Intrinsics.areEqual((Object)event.getSource(), (Object)"com.adobe.eventSource.requestContent")) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleAnalyticsTrackEvent - Ignoring track event (event is of unexpected type or source).", (Object[])new Object[0]);
            return;
        }
        this.updateAnalyticsState(event, CollectionsKt.plus((Collection)ANALYTICS_HARD_DEPENDENCIES, (Iterable)ANALYTICS_SOFT_DEPENDENCIES));
        Map map = event.getEventData();
        if (map == null) {
            AnalyticsExtension $this$handleGenericTrackEvent_u24lambda_u241 = this;
            boolean bl = false;
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleGenericTrackEvent - event data is null or empty.", (Object[])new Object[0]);
            return;
        }
        Map eventData = map;
        this.handleTrackRequest(event, eventData);
    }

    @VisibleForTesting
    public final void handleRuleEngineResponse$analytics_phoneRelease(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map map = event.getEventData();
        if (map == null) {
            AnalyticsExtension $this$handleRuleEngineResponse_u24lambda_u242 = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{event.getUniqueIdentifier()};
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"handleRuleEngineResponse - Event with id %s contained no data, ignoring.", (Object[])objectArray);
            return;
        }
        Map eventData = map;
        Map triggeredConsequence = DataReader.optTypedMap(Object.class, (Map)eventData, (String)"triggeredconsequence", null);
        if (triggeredConsequence == null || triggeredConsequence.isEmpty()) {
            Object[] objectArray = new Object[]{event.getUniqueIdentifier()};
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"handleRuleEngineResponse - Missing consequence data, ignoring event %s.", (Object[])objectArray);
            return;
        }
        String consequenceType = DataReader.optString((Map)triggeredConsequence, (String)"type", null);
        if (StringUtils.isNullOrEmpty((String)consequenceType)) {
            Object[] $this$handleRuleEngineResponse_u24lambda_u242 = new Object[]{event.getUniqueIdentifier()};
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"handleRuleEngineResponse - No consequence type received, ignoring event %s.", (Object[])$this$handleRuleEngineResponse_u24lambda_u242);
            return;
        }
        if (!Intrinsics.areEqual((Object)"an", (Object)consequenceType)) {
            Object[] $this$handleRuleEngineResponse_u24lambda_u242 = new Object[]{event.getUniqueIdentifier()};
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"handleRuleEngineResponse - Consequence type is not Analytics, ignoring event %s.", (Object[])$this$handleRuleEngineResponse_u24lambda_u242);
            return;
        }
        String consequenceId = DataReader.optString((Map)triggeredConsequence, (String)"id", null);
        if (StringUtils.isNullOrEmpty((String)consequenceId)) {
            Object[] bl = new Object[]{event.getUniqueIdentifier()};
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"handleRuleEngineResponse - Consequence id is missing, ignoring event  %s.", (Object[])bl);
            return;
        }
        Object[] bl = new Object[]{event.getUniqueIdentifier()};
        Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"handleRuleEngineResponse - Submitting Rules Engine Track response content event (%s) for processing.", (Object[])bl);
        this.updateAnalyticsState(event, CollectionsKt.plus((Collection)ANALYTICS_HARD_DEPENDENCIES, (Iterable)ANALYTICS_SOFT_DEPENDENCIES));
        Map consequenceDetail = DataReader.optTypedMap(Object.class, (Map)triggeredConsequence, (String)"detail", (Map)MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue((Object)consequenceDetail, (String)"consequenceDetail");
        this.handleTrackRequest(event, consequenceDetail);
    }

    private final void handleConfigurationResponseEvent(Event event) {
        this.updateAnalyticsState(event, CollectionsKt.plus((Collection)ANALYTICS_HARD_DEPENDENCIES, (Iterable)ANALYTICS_SOFT_DEPENDENCIES));
        if (this.analyticsState.getPrivacyStatus$analytics_phoneRelease() == MobilePrivacyStatus.OPT_OUT) {
            this.handleOptOut(event);
        } else if (this.analyticsState.getPrivacyStatus$analytics_phoneRelease() == MobilePrivacyStatus.OPT_IN) {
            this.analyticsDatabase.kick(false);
        }
    }

    private final void handleLifecycleEvents(Event event) {
        if (!Intrinsics.areEqual((Object)event.getType(), (Object)"com.adobe.eventType.lifecycle") || !Intrinsics.areEqual((Object)event.getSource(), (Object)"com.adobe.eventSource.responseContent")) {
            return;
        }
        this.updateAnalyticsState(event, CollectionsKt.plus((Collection)ANALYTICS_HARD_DEPENDENCIES, (Iterable)ANALYTICS_SOFT_DEPENDENCIES));
        this.trackLifecycle(event);
    }

    @VisibleForTesting
    public final void handleGenericLifecycleEvents$analytics_phoneRelease(@NotNull Event event) {
        Object v;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getType(), (Object)"com.adobe.eventType.generic.lifecycle") || !Intrinsics.areEqual((Object)event.getSource(), (Object)"com.adobe.eventSource.requestContent")) {
            return;
        }
        Map map = event.getEventData();
        Object object = v = map != null ? map.get("action") : null;
        if (Intrinsics.areEqual(v, (Object)"start")) {
            if (this.analyticsTimer.isTimerRunning$analytics_phoneRelease()) {
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleGenericLifecycleEvents - Exiting, Lifecycle timer is already running and this is a duplicate request", (Object[])new Object[0]);
                return;
            }
            this.analyticsDatabase.cancelWaitForAdditionalData(AnalyticsDatabase.DataType.REFERRER);
            this.analyticsDatabase.cancelWaitForAdditionalData(AnalyticsDatabase.DataType.LIFECYCLE);
            this.waitForLifecycleData();
        } else if (Intrinsics.areEqual(v, (Object)"pause")) {
            this.analyticsTimer.cancelLifecycleTimer();
            this.analyticsTimer.cancelReferrerTimer();
        }
    }

    private final void waitForLifecycleData() {
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"waitForLifecycleData - Lifecycle timer scheduled with timeout 1000", (Object[])new Object[0]);
        this.analyticsDatabase.waitForAdditionalData(AnalyticsDatabase.DataType.LIFECYCLE);
        this.analyticsTimer.startLifecycleTimer(1000L, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AnalyticsExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Log.warning((String)"Analytics", (String)"AnalyticsExtension", (String)"waitForLifecycleData - Lifecycle timeout has expired without Lifecycle data", (Object[])new Object[0]);
                AnalyticsExtension.access$getAnalyticsDatabase$p(this.this$0).cancelWaitForAdditionalData(AnalyticsDatabase.DataType.LIFECYCLE);
            }
        }));
    }

    private final void handleAcquisitionEvent(Event event) {
        if (!Intrinsics.areEqual((Object)event.getType(), (Object)"com.adobe.eventType.acquisition") || !Intrinsics.areEqual((Object)event.getSource(), (Object)"com.adobe.eventSource.responseContent")) {
            return;
        }
        this.updateAnalyticsState(event, CollectionsKt.plus((Collection)ANALYTICS_HARD_DEPENDENCIES, (Iterable)ANALYTICS_SOFT_DEPENDENCIES));
        this.trackAcquisitionData(event);
    }

    private final void handleAnalyticsRequestIdentityEvent(Event event) {
        Map map = event.getEventData();
        boolean bl = map != null ? map.containsKey("vid") : false;
        if (bl) {
            if (this.analyticsState.getPrivacyStatus$analytics_phoneRelease() == MobilePrivacyStatus.OPT_OUT) {
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleAnalyticsRequestIdentityEvent - Privacy is opted out, ignoring the update visitor identifier request.", (Object[])new Object[0]);
                return;
            }
            try {
                this.analyticsProperties.setVid$analytics_phoneRelease(DataReader.getString((Map)event.getEventData(), (String)"vid"));
            }
            catch (DataReaderException ex) {
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleAnalyticsRequestIdentityEvent - Failed to parse the visitor identifier to string, ignoring the update visitor identifier request.", (Object[])new Object[0]);
                return;
            }
            Map<String, Object> data = this.getAnalyticsIds();
            this.getApi().createSharedState(data, event);
            this.dispatchAnalyticsResponseIdentity(data, event);
        } else {
            this.dispatchAnalyticsResponseIdentity(this.getAnalyticsIds(), event);
        }
    }

    private final void handleAnalyticsRequestContentEvent(Event event) {
        Map eventData;
        Map map = eventData = event.getEventData();
        if (!(map != null ? !map.isEmpty() : false)) {
            Log.warning((String)"Analytics", (String)CLASS_NAME, (String)"handleAnalyticsRequestContentEvent - Returning early, event data is null or empty.", (Object[])new Object[0]);
            return;
        }
        if (eventData.containsKey("clearhitsqueue")) {
            this.analyticsDatabase.reset();
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)eventData, (String)"eventData");
            if (this.isTrackActionOrTrackStateEvent(eventData)) {
                this.updateAnalyticsState(event, CollectionsKt.plus((Collection)ANALYTICS_HARD_DEPENDENCIES, (Iterable)ANALYTICS_SOFT_DEPENDENCIES));
                long l = event.getTimestampInSeconds();
                String string = event.getUniqueIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.uniqueIdentifier");
                this.track(eventData, l, false, string);
            } else if (eventData.containsKey("getqueuesize")) {
                int queueSize = this.analyticsDatabase.getQueueSize$analytics_phoneRelease();
                Map data = MapsKt.mapOf((Pair)TuplesKt.to((Object)"queuesize", (Object)queueSize));
                Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("Dispatching Analytics hit queue size response event with eventdata " + data), (Object[])new Object[0]);
                this.getApi().dispatch(new Event.Builder("QueueSizeValue", "com.adobe.eventType.analytics", "com.adobe.eventSource.responseContent").inResponseToEvent(event).setEventData(data).build());
            } else if (eventData.containsKey("forcekick")) {
                this.analyticsDatabase.kick(true);
            }
        }
    }

    private final boolean isTrackActionOrTrackStateEvent(Map<String, ? extends Object> eventData) {
        return eventData.containsKey("state") || eventData.containsKey("action") || eventData.containsKey("contextdata");
    }

    private final void trackAcquisitionData(Event event) {
        Map map = DataReader.optTypedMap(String.class, (Map)event.getEventData(), (String)"contextdata", (Map)MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"optTypedMap(\n           \u2026     emptyMap()\n        )");
        Map acquisitionContextData = map;
        if (this.analyticsTimer.isReferrerTimerRunning()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackAcquisition - Cancelling referrer timer", (Object[])new Object[0]);
            this.analyticsTimer.cancelReferrerTimer();
        }
        if (this.analyticsDatabase.isHitWaiting()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackAcquisition - Append referrer data to pending hit", (Object[])new Object[0]);
            this.analyticsDatabase.kickWithAdditionalData(AnalyticsDatabase.DataType.REFERRER, acquisitionContextData);
        } else {
            this.analyticsDatabase.cancelWaitForAdditionalData(AnalyticsDatabase.DataType.REFERRER);
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackAcquisition - Sending referrer data as separate tracking hit", (Object[])new Object[0]);
            Map acquisitionData = new HashMap();
            acquisitionData.put("action", "AdobeLink");
            acquisitionData.put("contextdata", acquisitionContextData);
            acquisitionData.put("trackinternal", true);
            long l = event.getTimestampInSeconds();
            String string = event.getUniqueIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.uniqueIdentifier");
            this.track(acquisitionData, l, false, string);
        }
    }

    private final void trackLifecycle(Event event) {
        Map map = DataReader.optTypedMap(String.class, (Map)event.getEventData(), (String)"lifecyclecontextdata", null);
        if (map == null) {
            AnalyticsExtension $this$trackLifecycle_u24lambda_u243 = this;
            boolean bl = false;
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackLifecycle - Failed to track lifecycle event (context data was null or empty)", (Object[])new Object[0]);
            return;
        }
        Map eventLifecycleContextData = map;
        Map tempLifecycleContextData = new HashMap(eventLifecycleContextData);
        Map lifecycleContextData = new HashMap();
        String previousOsVersion = (String)tempLifecycleContextData.remove("previousosversion");
        String previousAppIdVersion = (String)tempLifecycleContextData.remove("previousappid");
        Map<String, String> $this$forEach$iv = AnalyticsConstants.INSTANCE.getMAP_TO_CONTEXT_DATA_KEYS$analytics_phoneRelease();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = object.next();
            boolean bl = false;
            String value = (String)tempLifecycleContextData.get(entry.getKey());
            if (value == null || !(((CharSequence)value).length() > 0)) continue;
            lifecycleContextData.put(entry.getValue(), value);
            tempLifecycleContextData.remove(entry.getKey());
        }
        lifecycleContextData.putAll(tempLifecycleContextData);
        if (lifecycleContextData.containsKey("a.InstallEvent")) {
            this.waitForAcquisitionData(TimeUnit.SECONDS.toMillis(this.analyticsState.getReferrerTimeout$analytics_phoneRelease()));
        } else if (lifecycleContextData.containsKey("a.LaunchEvent")) {
            this.waitForAcquisitionData(500L);
        }
        if (this.analyticsState.isBackdateSessionInfoEnabled$analytics_phoneRelease() && this.analyticsState.isOfflineTrackingEnabled$analytics_phoneRelease()) {
            if (lifecycleContextData.containsKey("a.CrashEvent")) {
                lifecycleContextData.remove("a.CrashEvent");
                String string = event.getUniqueIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.uniqueIdentifier");
                this.backdateLifecycleCrash(previousOsVersion, previousAppIdVersion, string);
            }
            if (lifecycleContextData.containsKey("a.PrevSessionLength")) {
                String previousSessionLength = (String)lifecycleContextData.remove("a.PrevSessionLength");
                object = (String)tempLifecycleContextData.remove("previoussessionpausetimestampmillis");
                Long previousSessionPauseTimestamp = object != null ? Long.valueOf(Long.parseLong((String)object)) : null;
                String string = event.getUniqueIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.uniqueIdentifier");
                this.backdateLifecycleSessionInfo(previousSessionLength, previousSessionPauseTimestamp, previousOsVersion, previousAppIdVersion, string);
            }
        }
        if (this.analyticsTimer.isLifecycleTimerRunning()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackLifecycle - Cancelling lifecycle timer", (Object[])new Object[0]);
            this.analyticsTimer.cancelLifecycleTimer();
        }
        if (this.analyticsDatabase.isHitWaiting()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackLifecycle - Append lifecycle data to pending hit", (Object[])new Object[0]);
            this.analyticsDatabase.kickWithAdditionalData(AnalyticsDatabase.DataType.LIFECYCLE, lifecycleContextData);
        } else {
            this.analyticsDatabase.cancelWaitForAdditionalData(AnalyticsDatabase.DataType.LIFECYCLE);
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"trackLifecycle - Sending lifecycle data as separate tracking hit", (Object[])new Object[0]);
            Map lifecycleData = new HashMap();
            lifecycleData.put("action", "Lifecycle");
            lifecycleData.put("contextdata", lifecycleContextData);
            lifecycleData.put("trackinternal", true);
            long l = event.getTimestampInSeconds();
            String string = event.getUniqueIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.uniqueIdentifier");
            this.track(lifecycleData, l, false, string);
        }
    }

    private final void backdateLifecycleSessionInfo(String previousSessionLength, Long previousSessionPauseTimestamp, String previousOSVersion, String previousAppIdVersion, String eventUniqueIdentifier) {
        Map sessionContextData = new HashMap();
        if (previousSessionLength != null) {
            sessionContextData.put("a.PrevSessionLength", previousSessionLength);
        }
        if (previousOSVersion != null && ((CharSequence)previousOSVersion).length() > 0) {
            sessionContextData.put("a.OSVersion", previousOSVersion);
        }
        if (previousAppIdVersion != null && ((CharSequence)previousAppIdVersion).length() > 0) {
            sessionContextData.put("a.AppID", previousAppIdVersion);
        }
        Map lifecycleSessionData = new HashMap();
        lifecycleSessionData.put("action", "SessionInfo");
        lifecycleSessionData.put("contextdata", sessionContextData);
        lifecycleSessionData.put("trackinternal", true);
        Long l = previousSessionPauseTimestamp;
        long backdateTimestamp = RangesKt.coerceAtLeast((long)this.analyticsProperties.getMostRecentHitTimeStampInSeconds$analytics_phoneRelease(), (long)(l != null ? l : 0L));
        this.track(lifecycleSessionData, backdateTimestamp + 1L, true, eventUniqueIdentifier);
    }

    private final void backdateLifecycleCrash(String previousOSVersion, String previousAppIdVersion, String eventUniqueIdentifier) {
        Map crashContextData = new HashMap();
        crashContextData.put("a.CrashEvent", "CrashEvent");
        if (previousOSVersion != null && ((CharSequence)previousOSVersion).length() > 0) {
            crashContextData.put("a.OSVersion", previousOSVersion);
        }
        if (previousAppIdVersion != null && ((CharSequence)previousAppIdVersion).length() > 0) {
            crashContextData.put("a.AppID", previousAppIdVersion);
        }
        Map lifecycleSessionData = new HashMap();
        lifecycleSessionData.put("action", "Crash");
        lifecycleSessionData.put("contextdata", crashContextData);
        lifecycleSessionData.put("trackinternal", true);
        this.track(lifecycleSessionData, this.analyticsProperties.getMostRecentHitTimeStampInSeconds$analytics_phoneRelease() + 1L, true, eventUniqueIdentifier);
    }

    private final void waitForAcquisitionData(long timeout) {
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)("waitForAcquisitionData - Referrer timer scheduled with timeout " + timeout), (Object[])new Object[0]);
        this.analyticsDatabase.waitForAdditionalData(AnalyticsDatabase.DataType.REFERRER);
        this.analyticsTimer.startReferrerTimer(timeout, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AnalyticsExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Log.warning((String)"Analytics", (String)"AnalyticsExtension", (String)"waitForAcquisitionData - Launch hit delay has expired without referrer data.", (Object[])new Object[0]);
                AnalyticsExtension.access$getAnalyticsDatabase$p(this.this$0).cancelWaitForAdditionalData(AnalyticsDatabase.DataType.REFERRER);
            }
        }));
    }

    private final void handleOptOut(Event event) {
        Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleOptOut - Privacy status is opted-out. Queued Analytics hits, stored state data, and properties will be cleared.", (Object[])new Object[0]);
        this.analyticsDatabase.reset();
        this.analyticsProperties.reset();
        this.getApi().createSharedState(this.getAnalyticsIds(), event);
    }

    private final Map<String, Object> getAnalyticsIds() {
        Map data;
        block1: {
            data = new LinkedHashMap();
            String string = this.analyticsProperties.getAid$analytics_phoneRelease();
            if (string != null) {
                String aid = string;
                boolean bl = false;
                data.put("aid", aid);
            }
            String string2 = this.analyticsProperties.getVid$analytics_phoneRelease();
            if (string2 == null) break block1;
            String vid = string2;
            boolean bl = false;
            data.put("vid", vid);
        }
        return data;
    }

    private final void dispatchAnalyticsResponseIdentity(Map<String, ? extends Object> data, Event event) {
        Event pairedResponseEvent = new Event.Builder("TrackingIdentifierValue", "com.adobe.eventType.analytics", "com.adobe.eventSource.responseIdentity").setEventData(data).inResponseToEvent(event).build();
        this.getApi().dispatch(pairedResponseEvent);
        Object[] objectArray = new Object[]{data};
        Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"Dispatching Analytics paired response identity event with eventdata: %s.", (Object[])objectArray);
        Event responseEvent = new Event.Builder("TrackingIdentifierValue", "com.adobe.eventType.analytics", "com.adobe.eventSource.responseIdentity").setEventData(data).build();
        this.getApi().dispatch(responseEvent);
        Object[] objectArray2 = new Object[]{data};
        Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"Dispatching Analytics unpaired response identity event with eventdata: %s.", (Object[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAnalyticsState(Event event, List<String> dependencies) {
        Iterable $this$associateWith$iv = dependencies;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void extensionName;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            SharedStateResult sharedStateResult = this.getApi().getSharedState((String)extensionName, event, true, SharedStateResolution.ANY);
            Map map2 = sharedStateResult != null ? sharedStateResult.getValue() : null;
            map.put(t, map2);
        }
        Map map = result$iv;
        this.analyticsState.update$analytics_phoneRelease(map);
    }

    private final void handleTrackRequest(Event event, Map<String, ? extends Object> data) {
        if (data.isEmpty()) {
            Log.debug((String)"Analytics", (String)CLASS_NAME, (String)"handleTrackRequest - event data is null or empty.", (Object[])new Object[0]);
            return;
        }
        if (this.isTrackActionOrTrackStateEvent(data)) {
            long l = event.getTimestampInSeconds();
            String string = event.getUniqueIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.uniqueIdentifier");
            this.track(data, l, false, string);
        }
    }

    private final void track(Map<String, ? extends Object> eventData, long timeStampInSeconds, boolean isBackdatedHit, String eventUniqueIdentifier) {
        if (MobilePrivacyStatus.OPT_OUT == this.analyticsState.getPrivacyStatus$analytics_phoneRelease()) {
            Log.warning((String)"Analytics", (String)CLASS_NAME, (String)"track - Dropping the Analytics track request, privacy status is opted out.", (Object[])new Object[0]);
            return;
        }
        if (!this.analyticsState.isAnalyticsConfigured()) {
            Log.warning((String)"Analytics", (String)CLASS_NAME, (String)"track - Dropping the Analytics track request, Analytics is not configured.", (Object[])new Object[0]);
            return;
        }
        this.analyticsProperties.setMostRecentHitTimeStamp$analytics_phoneRelease(timeStampInSeconds);
        Map<String, String> analyticsData = this.processAnalyticsContextData(timeStampInSeconds, eventData);
        Map<String, String> analyticsVars = this.processAnalyticsVars(eventData, timeStampInSeconds);
        String builtRequest = AnalyticsRequestSerializer.Companion.buildRequest$analytics_phoneRelease(this.analyticsState, analyticsData, analyticsVars);
        this.analyticsDatabase.queue$analytics_phoneRelease(builtRequest, timeStampInSeconds, eventUniqueIdentifier, isBackdatedHit);
    }

    private final Map<String, String> processAnalyticsContextData(long timeStampInSeconds, Map<String, ? extends Object> trackEventData) {
        String requestIdentifier;
        long lifecycleSessionStartTimestamp;
        Map analyticsData = new HashMap();
        analyticsData.putAll(this.analyticsState.getDefaultData$analytics_phoneRelease());
        Map contextData = DataReader.optTypedMap(String.class, trackEventData, (String)"contextdata", null);
        if (contextData != null) {
            Map<String, String> cleanedData = this.cleanContextData(contextData);
            analyticsData.putAll(cleanedData);
        }
        String actionName = DataReader.optString(trackEventData, (String)"action", null);
        boolean isInternal = DataReader.optBoolean(trackEventData, (String)"trackinternal", (boolean)false);
        if (!StringUtils.isNullOrEmpty((String)actionName)) {
            String actionKey = isInternal ? "a.internalaction" : "a.action";
            Intrinsics.checkNotNullExpressionValue((Object)actionName, (String)"actionName");
            analyticsData.put(actionKey, actionName);
        }
        if ((lifecycleSessionStartTimestamp = this.analyticsState.getLifecycleSessionStartTimestamp$analytics_phoneRelease()) > 0L) {
            long timeSinceLaunchInSeconds = timeStampInSeconds - TimeUnit.MILLISECONDS.toSeconds(lifecycleSessionStartTimestamp);
            boolean bl = 1L <= timeSinceLaunchInSeconds ? timeSinceLaunchInSeconds <= this.analyticsState.getLifecycleMaxSessionLength$analytics_phoneRelease() : false;
            if (bl) {
                analyticsData.put("a.TimeSinceLaunch", String.valueOf(timeSinceLaunchInSeconds));
            }
        }
        if (this.analyticsState.getPrivacyStatus$analytics_phoneRelease() == MobilePrivacyStatus.UNKNOWN) {
            analyticsData.put("a.privacy.mode", "unknown");
        }
        if ((requestIdentifier = DataReader.optString(trackEventData, (String)"requestEventIdentifier", null)) != null) {
            analyticsData.put("a.DebugEventIdentifier", requestIdentifier);
        }
        return analyticsData;
    }

    private final Map<String, String> processAnalyticsVars(Map<String, ? extends Object> trackData, long timestamp) {
        String it;
        Map analyticsVars = new HashMap();
        String actionName = DataReader.optString(trackData, (String)"action", null);
        String stateName = DataReader.optString(trackData, (String)"state", null);
        if (!StringUtils.isNullOrEmpty((String)actionName)) {
            analyticsVars.put("pe", "lnk_o");
            boolean isInternal = DataReader.optBoolean(trackData, (String)"trackinternal", (boolean)false);
            String actionPrefix = isInternal ? "ADBINTERNAL:" : "AMACTION:";
            analyticsVars.put("pev2", actionPrefix + actionName);
        }
        String string = this.analyticsState.getApplicationID$analytics_phoneRelease();
        if (string != null) {
            it = string;
            boolean bl = false;
            analyticsVars.put("pageName", it);
        }
        if (!StringUtils.isNullOrEmpty((String)stateName)) {
            Intrinsics.checkNotNullExpressionValue((Object)stateName, (String)"stateName");
            analyticsVars.put("pageName", stateName);
        }
        String string2 = this.analyticsProperties.getAid$analytics_phoneRelease();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            analyticsVars.put("aid", it);
        }
        String string3 = this.analyticsProperties.getVid$analytics_phoneRelease();
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            analyticsVars.put("vid", it);
        }
        analyticsVars.put("ce", AnalyticsProperties.Companion.getCHARSET());
        Map isInternal = analyticsVars;
        String string4 = "t";
        String string5 = TimeZone.TIMESTAMP_TIMEZONE_OFFSET;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"TIMESTAMP_TIMEZONE_OFFSET");
        String string6 = string5;
        isInternal.put(string4, string6);
        if (this.analyticsState.isOfflineTrackingEnabled$analytics_phoneRelease()) {
            analyticsVars.put("ts", String.valueOf(timestamp));
        }
        if (this.analyticsState.isVisitorIDServiceEnabled()) {
            analyticsVars.putAll(this.analyticsState.getAnalyticsIdVisitorParameters());
        }
        analyticsVars.put("cp", "foreground");
        if (ServiceProvider.getInstance().getAppContextService() != null) {
            AppState appState = ServiceProvider.getInstance().getAppContextService().getAppState();
            Intrinsics.checkNotNullExpressionValue((Object)appState, (String)"getInstance().appContextService.appState");
            AppState appState2 = appState;
            if (appState2 == AppState.BACKGROUND) {
                analyticsVars.put("cp", "background");
            }
        } else {
            Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"processAnalyticsVars - Unable to access platform services to retrieve foreground/background state. Defaulting customer perspective to foreground.", (Object[])new Object[0]);
        }
        return analyticsVars;
    }

    private final void deleteDeprecatedV5HitDatabase() {
        SQLiteUtils.deleteDBFromCacheDir((String)"ADBMobileDataCache.sqlite");
    }

    private final void boot() {
        Map<String, Object> data = this.getAnalyticsIds();
        this.getApi().createSharedState(data, null);
        Log.trace((String)"Analytics", (String)CLASS_NAME, (String)"Analytics boot-up complete, published initial shared state.", (Object[])new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> cleanContextData(Map<String, ? extends Object> eventData) {
        void $this$mapValuesTo$iv$iv;
        Map<String, ? extends Object> $this$filterValues$iv = eventData;
        boolean $i$f$filterValues = false;
        Map<String, Object> result$iv = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it instanceof String)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$mapValues$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)v;
            map2.put(k, string);
        }
        return destination$iv$iv;
    }

    private static final void eventHandler$lambda$0(AnalyticsExtension this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleIncomingEvent$analytics_phoneRelease(it);
    }

    public static final /* synthetic */ AnalyticsDatabase access$getAnalyticsDatabase$p(AnalyticsExtension $this) {
        return $this.analyticsDatabase;
    }

    static {
        Object[] objectArray = new String[]{"com.adobe.module.configuration", "com.adobe.module.identity"};
        ANALYTICS_HARD_DEPENDENCIES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"com.adobe.module.lifecycle", "com.adobe.assurance", "com.adobe.module.places"};
        ANALYTICS_SOFT_DEPENDENCIES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/adobe/marketing/mobile/analytics/internal/AnalyticsExtension$Companion;", "", "()V", "ANALYTICS_HARD_DEPENDENCIES", "", "", "ANALYTICS_SOFT_DEPENDENCIES", "CLASS_NAME", "analytics_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

