/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.analytics.internal.AnalyticsExtension;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import java.util.HashMap;
import java.util.Map;

public class Analytics {
    private static final String LOG_TAG = "Analytics";
    private static final String EXTENSION_VERSION = "3.0.2";
    private static final String ANALYTICS_ID = "aid";
    private static final String GET_QUEUE_SIZE = "getqueuesize";
    private static final String QUEUE_SIZE = "queuesize";
    private static final String CLEAR_HITS_QUEUE = "clearhitsqueue";
    private static final String FORCE_KICK_HITS = "forcekick";
    private static final String VISITOR_IDENTIFIER = "vid";
    private static final long EVENT_PROCESSING_TIMEOUT_MS = 5000L;
    public static final Class<? extends Extension> EXTENSION = AnalyticsExtension.class;

    private Analytics() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void getTrackingIdentifier(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            return;
        }
        final AdobeCallbackWithError adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        Event analyticsReqEvent = new Event.Builder("GetTrackingIdentifier", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestIdentity").build();
        MobileCore.dispatchEventWithResponseCallback((Event)analyticsReqEvent, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void call(Event event) {
                Map eventData = event.getEventData();
                callback.call(eventData != null ? DataReader.optString((Map)eventData, (String)Analytics.ANALYTICS_ID, null) : null);
            }

            public void fail(AdobeError adobeError) {
                if (adobeCallbackWithError != null) {
                    adobeCallbackWithError.fail(adobeError);
                }
            }
        });
        Log.debug((String)LOG_TAG, (String)LOG_TAG, (String)"getTrackingIdentifier - Get tracking identifier request event was sent", (Object[])new Object[0]);
    }

    public static void getQueueSize(final @NonNull AdobeCallback<Long> callback) {
        if (callback == null) {
            return;
        }
        final AdobeCallbackWithError adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        HashMap<String, Boolean> eventDataMap = new HashMap<String, Boolean>();
        eventDataMap.put(GET_QUEUE_SIZE, true);
        Event analyticsReqEvent = new Event.Builder("GetQueueSize", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build();
        MobileCore.dispatchEventWithResponseCallback((Event)analyticsReqEvent, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void call(Event event) {
                Map eventData = event.getEventData();
                callback.call((Object)(eventData != null ? DataReader.optLong((Map)eventData, (String)Analytics.QUEUE_SIZE, (long)0L) : 0L));
            }

            public void fail(AdobeError adobeError) {
                if (adobeCallbackWithError != null) {
                    adobeCallbackWithError.fail(adobeError);
                }
            }
        });
        Log.debug((String)LOG_TAG, (String)LOG_TAG, (String)"getQueueSize - Get hits queue size request event was sent", (Object[])new Object[0]);
    }

    public static void clearQueue() {
        HashMap<String, Boolean> eventDataMap = new HashMap<String, Boolean>();
        eventDataMap.put(CLEAR_HITS_QUEUE, true);
        MobileCore.dispatchEvent((Event)new Event.Builder("ClearHitsQueue", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build());
        Log.debug((String)LOG_TAG, (String)LOG_TAG, (String)"clearQueue - Clear hits queue event was sent", (Object[])new Object[0]);
    }

    public static void sendQueuedHits() {
        HashMap<String, Boolean> eventDataMap = new HashMap<String, Boolean>();
        eventDataMap.put(FORCE_KICK_HITS, true);
        MobileCore.dispatchEvent((Event)new Event.Builder("ForceKickHits", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build());
        Log.debug((String)LOG_TAG, (String)LOG_TAG, (String)"sendQueuedHits - Kick all hits event was sent", (Object[])new Object[0]);
    }

    public static void getVisitorIdentifier(final @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            return;
        }
        Event analyticsReqEvent = new Event.Builder("GetVisitorIdentifier", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestIdentity").build();
        final AdobeCallbackWithError adobeCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
        MobileCore.dispatchEventWithResponseCallback((Event)analyticsReqEvent, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void call(Event event) {
                Map eventData = event.getEventData();
                callback.call(eventData != null ? DataReader.optString((Map)eventData, (String)Analytics.VISITOR_IDENTIFIER, null) : null);
            }

            public void fail(AdobeError adobeError) {
                if (adobeCallbackWithError != null) {
                    adobeCallbackWithError.fail(adobeError);
                }
            }
        });
    }

    public static void setVisitorIdentifier(@Nullable String visitorID) {
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        eventDataMap.put(VISITOR_IDENTIFIER, visitorID);
        MobileCore.dispatchEvent((Event)new Event.Builder("UpdateVisitorIdentifier", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestIdentity").setEventData(eventDataMap).build());
        Log.debug((String)LOG_TAG, (String)LOG_TAG, (String)"setVisitorIdentifier - vid is (%s)", (Object[])new Object[]{visitorID});
    }
}

