/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl;

import com.day.cq.auth.impl.AbstractHTTPAuthHandler;
import com.day.cq.auth.impl.CugSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.auth.spi.AuthenticationHandler;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPAuthHandler
extends AbstractHTTPAuthHandler {
    private static final Logger log = LoggerFactory.getLogger(HTTPAuthHandler.class);
    private static final String DESCRIPTION = "HTTP Basic Authentication Handler";
    private SlingRepository repository;
    private ResourceResolverFactory resolverFactory;
    private CugSupport cugSupport;
    private ServiceRegistration registration;
    private Dictionary<?, ?> props;

    @Override
    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.requestCredentials(request, response);
    }

    @Override
    protected void configure(Dictionary<?, ?> properties) {
        super.configure(properties);
        this.props = properties;
    }

    @Override
    protected String getLoginPage(HttpServletRequest request) {
        return null;
    }

    @Override
    protected String getRealm(HttpServletRequest request) {
        String realm = this.cugSupport.getRealm(request);
        log.info("CUG realm: {}", (Object)realm);
        return realm;
    }

    public String toString() {
        return DESCRIPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        ResourceResolver adminResourceResolver = null;
        try {
            adminResourceResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            this.registration = componentContext.getBundleContext().registerService(AuthenticationHandler.class.getName(), (Object)this, this.getProperties(adminResourceResolver));
        }
        catch (LoginException re) {
            log.error("bindRepository: Failed logging in, cannot handle Closed User Groups", (Throwable)re);
        }
        finally {
            if (adminResourceResolver != null) {
                adminResourceResolver.close();
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    private Dictionary<String, Object> getProperties(ResourceResolver resourceResolver) {
        Hashtable<String, Object> newProps = new Hashtable<String, Object>();
        Enumeration<?> ke = this.props.keys();
        while (ke.hasMoreElements()) {
            Object key = ke.nextElement();
            newProps.put(key.toString(), this.props.get(key));
        }
        ArrayList<String> merged = new ArrayList<String>();
        HashSet<String> authReqs = new HashSet<String>();
        authReqs.add("-" + HTTPAuthHandler.toRawPath(this.getDefaultLoginPage(), resourceResolver));
        String[] paths = OsgiUtil.toStringArray(this.props.get("path"));
        if (paths != null) {
            merged.addAll(Arrays.asList(paths));
        }
        newProps.put("sling.auth.requirements", authReqs.toArray(new String[authReqs.size()]));
        newProps.put("path", merged.toArray(new String[merged.size()]));
        return newProps;
    }

    private static String toRawPath(String path, ResourceResolver resourceResolver) {
        Resource loginPageResource;
        if (resourceResolver != null && !ResourceUtil.isNonExistingResource((Resource)(loginPageResource = resourceResolver.resolve(path)))) {
            return resourceResolver.map(loginPageResource.getPath());
        }
        return path;
    }
}

